<?php

namespace app\controllers;

use app\models\Permiso;
use app\customs\BaseController;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Controlador;
use app\models\Rol;
/**
 * PermisosController implements the CRUD actions for Permiso model.
 */
class PermisosController extends BaseController
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    public function actionRol($id){
        $rol = Rol::findOne(['id'=>$id]);
        if(isset($_POST['permisos'])){
            $this->guardarPermisos($_POST['permisos'],$rol);
            return $this->redirect(['rol/index']);
        }
        else{
            
            $controladores = Controlador::find()->orderBy('nombre_amigable')->all();
            $permisos= Permiso::find()->where(['id_rol'=>$id,'permitido'=>1])->all();
            $concedidos=$this->toSimpleArray($permisos);
            return $this->render('rol', [
                    'model' => $rol,
                    'controladores' => $controladores,
                    'permisos'=>$concedidos,
                ]);
        }
    }
    
    protected function toSimpleArray($permisos){
        $final=[];
        foreach ($permisos as $permiso){
            array_push($final,$permiso->id_accion);
        }
        return $final;
    }
    
    protected function guardarPermisos($permisos,$rol){
        $perms=$rol->permisos;
        foreach ($perms as $per) {
            $per->permitido=0;
            $per->save();
        }
        foreach ($permisos as $permiso){
            $p=Permiso::findOne(['id_accion'=>$permiso,'id_rol'=>$rol->id]);
            if(empty($p)){
                $p=new Permiso();
                $p->id_accion=$permiso;
                $p->id_rol=$rol->id;
            }
            $p->permitido=1;
            $p->save();
        }
    }

    /**
     * Finds the Permiso model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Permiso the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Permiso::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
