<?php

namespace app\controllers;

use Yii;
use app\models\Pagadito;
use app\customs\BaseController;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\Response;

class PagaditoController  extends BaseController {
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }
    
    public function actionIndex(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $id_suscripcion = $usuario->suscripcion->id;
        $model = Pagadito::find()->where(['id_suscripcion' => $id_suscripcion])->one();
        return ['Correcto'=>true, 'pagadito'=>$model];
        
    }
    
    /**
     * Creates a new Pagadito model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $post = Yii::$app->request->post();
        $usuario = Yii::$app->user->identity;
        $id_suscripcion = $usuario->suscripcion->id;
        if (Yii::$app->request->isAjax) {
            $model = empty($post['id']) ? new Pagadito() : $this->findModel($post['id']);
            if ( !empty($post['id']) && $model->id_suscripcion != $id_suscripcion) {
                return ['Correcto' => false, 'mensaje' => 'La información de la cuenta no pertenece a su suscripción'];
            }
            $model->uid = $post['uid'];
            $model->wsk = $post['wsk'];
            $model->metodo_cobro = $post['metodo_cobro'];
            $model->cargar_iva = $post['cargar_iva'];
            $model->id_suscripcion = $id_suscripcion;
            $model->cobrar_pasarela = 0;
            $model->tipo = Pagadito::PAGADITO;
            if($model->save()){
                return ['Correcto'=>true, 'pagadito'=>$model];
            } else {
                return ['Correcto'=>false, 'mensaje'=>'No se pudo enviar la información'];
            }

        }
        
        return ['Correcto'=>false, 'mensaje'=>'No se pudo enviar la información'];
    }
    
    /**
     * Configuración del link de cobro personalizado 
     * @return mixed
     */
    public function actionLinkCobroPropio(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $post = Yii::$app->request->post();
        $usuario = Yii::$app->user->identity;
        $id_suscripcion = $usuario->suscripcion->id;
        $model = Pagadito::find()->where(['id_suscripcion' => $id_suscripcion])->one();
        if( empty($model) ){
            $model = new Pagadito(); 
            $model->id_suscripcion = $id_suscripcion;
        }
        $model->cargar_iva = $post['metodo_iva'];
        $model->cobrar_pasarela = $post['cobrar_pasarela'];
        $model->metodo_cobro = \boolval($post['cobrar_pasarela']) ? $post['cargo_pasarela'] : null;
        if( \boolval($post['cobrar_pasarela']) ){
            $model->monto_fijo = $post['monto_fijo']; 
            $model->monto_porcentual = $post['monto_porcentual']; 
        }
        $model->tipo = Pagadito::LINK_EXTERNO;
        $model->link_externo = $post['link'];
        if( $model->save() ){
            return ['Correcto' => true];
        }
        return ['Correcto' => false];
    }
    
    
    /**
     * Updates an existing Pagadito model.
     * If update is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $id_suscripcion = $usuario->suscripcion->id;
        $post = Yii::$app->request->post(); 
        $model = $this->findModel($post['id']);
        if($model->id_suscripcion != $id_suscripcion){
            return ['Correcto'=>false, 'mensaje'=>'La información de la cuenta no pertenece a su suscripción'];
        }
        if (Yii::$app->request->isAjax) {
            $model->uid = $post['uid'];
            $model->wsk = $post['wsk'];
            $model->metodo_cobro = $post['metodo_cobro'];
            $model->cargar_iva = $post['cargar_iva'];
            $model->tipo = Pagadito::PAGADITO;
            if($model->save()){
                return ['Correcto'=>true, 'pagadito'=>$model];
            } else {
                return ['Correcto'=>false, 'mensaje'=>'No se pudo enviar la información'];
            }

        }
        return ['Correcto'=>false, 'mensaje'=>'No se pudo enviar la información'];
    }
    
    /**
     * Deletes an existing Pagadito model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $id_suscripcion = $usuario->suscripcion->id;
        $post = Yii::$app->request->post(); 
        $model = $this->findModel($post['id']);
        if($model->id_suscripcion != $id_suscripcion){
            return ['Correcto'=>false, 'mensaje'=>'La información de la cuenta no pertenece a su suscripción'];
        }
        $model->delete();
        return ['Correcto'=>true, 'mensaje'=>'Se ha eliminado correctamente'];
    }
    
    
    public function beforeAction($action) {
        if($action->id == 'create' || $action->id == 'update' || $action->id == 'link-cobro-propio'){
            $this->enableCsrfValidation = false;
        }
        return parent::beforeAction($action);
    }
    
    public function excludeFromSecurity() {
        return ['link-cobro-propio'];
    }
    
    /**
     * Finds the Pagadito model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Paciente the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Pagadito::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    
   
    
}
