<?php
namespace app\controllers;

use Yii;
use app\customs\BaseController;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\ActiveDataProvider;
use yii\web\Response;
use yii\helpers\Url;
use yii\db\Query;
use yii\helpers\ArrayHelper;
use app\models\Notificacion;
use app\models\Suscripcion;
use app\models\NotificacionSuscripcion;

/**
 * NotificacionController implements the CRUD actions for Cita model.
 */
class NotificacionController extends BaseController
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }
    
    /**
     * List all Notification model
     * @return mixed
     */
    public function actionIndex()
    {
        $dataProvider = new ActiveDataProvider([
            'query' => Notificacion::find(),
        ]);
        return $this->render('index',[
            'dataProvider' => $dataProvider
        ]);
    }
    
    /**
     * Displays a single Notificacion model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id){
        $model = $this->findModel($id);
        return $this->render('view', ['model'=>$model]);
    }
    
            
    /**
     * Create a new Notificacion model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Notificacion;
        $post = Yii::$app->request->post();
        if($model->load($post)){
            $model->es_privado = 0;
            if($model->save()){            
                $this->enlazarNotificacion($model->id);
                $this->redirect(['view', 'id'=>$model->id]);
            }
        }
        return $this->render('create',['model'=>$model]);
    }
    
    /**
     * Enlazar la notificacion con las suscripciones 
     * @param int $idNotificacion
     */
    private function enlazarNotificacion($idNotificacion)
    {
        $suscripciones = Suscripcion::find()->all();
        foreach($suscripciones as $suscripcion){
            $notificacionSus = new NotificacionSuscripcion();
            $notificacionSus->id_notificacion = $idNotificacion;
            $notificacionSus->id_suscripcion = $suscripcion->id;
            $notificacionSus->fecha_creacion = date('Y-m-d H:i:s');
            $notificacionSus->visto = 0;
            $notificacionSus->leido = 0;
            $notificacionSus->save();
            unset($notificacionSus);
        }
    }
    
    /**
     * Updates an existing Notificacion model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $post = Yii::$app->request->post();
        if($model->load($post) && $model->save()){
            return $this->redirect(['view', 'id'=>$model->id]);
        }
        return $this->render('create',['model'=>$model]);
    }
    
    public function actionNotificaciones()
    {
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $idSuscripcion = $usuario->suscripcion->id;
        $notificaciones = ArrayHelper::merge($this->notificacionesOlivia($usuario), $this->notificacionesOliviaLeidos($usuario));
        $totalNotificaciones =  count($notificaciones);
        $vistos = count(NotificacionSuscripcion::find()->where(['id_suscripcion'=>$idSuscripcion, 'visto'=>1])->all());        
        $leidos = count(NotificacionSuscripcion::find()->where(['id_suscripcion'=>$idSuscripcion, 'leido'=>1])->all());
        $pendientes = count(NotificacionSuscripcion::find()->where(['id_suscripcion'=>$idSuscripcion, 'leido'=>0])->all());
        $mostrarTotal = $totalNotificaciones == $vistos ? false : true;
        return ['Correcto'=>true, 'Notificaciones'=>$notificaciones, 'totalNotificaciones'=>$totalNotificaciones, 'leidos'=>$leidos, 'pendientes'=>$pendientes, 'vistos'=>$vistos, 'mostrarTotal'=>$mostrarTotal];

    }
    
    /**
     * @param $usuario 
     * @return array
     */
    private function notificacionesOlivia($usuario)
    {
        $idSuscripcion = $usuario->suscripcion->id;
        $notificacionesQ =  NotificacionSuscripcion::find()
                ->andWhere(['id_suscripcion'=>$idSuscripcion, 'leido'=>0])
                ->all();
        $notificaciones = [];
        $titulo = '';
        $descripcion = '';
        foreach($notificacionesQ as $notificacion){
            $titulo = $notificacion->notificacion->titulo;
            $descripcion = $notificacion->notificacion->descripcion;
            $notificaciones[] = [
                'id'=>$notificacion->notificacion->id,
                'titulo' => $titulo,
                'leido'=>$notificacion->leido,
                'tipo' => $notificacion->notificacion->tipo, 
                
            ];
        }
        return $notificaciones;
    }
    
    private function notificacionesOliviaLeidos($usuario)
    {
        $idSuscripcion = $usuario->suscripcion->id;
        $notificacionesQ =  NotificacionSuscripcion::find()
                ->andWhere(['id_suscripcion'=>$idSuscripcion, 'leido'=>1])
                ->all();
        $notificaciones = [];
        $titulo = '';
        $descripcion = '';
        foreach($notificacionesQ as $notificacion){
            $titulo = $notificacion->notificacion->titulo;
            $descripcion = $notificacion->notificacion->descripcion;
            $notificaciones[] = [
                'id'=>$notificacion->notificacion->id,
                'titulo' => $titulo,
                'leido'=>$notificacion->leido,
                'tipo' => $notificacion->notificacion->tipo, 
                
            ];
        }
        return $notificaciones;
    }
    
    private function notificacionesFactura()
    {
        
    }
    
    public function actionMarcarVisto()
    {
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $idSuscripcion = $usuario->suscripcion->id;
        $open = filter_input(INPUT_POST, 'open');
        if($open){
        $notificaciones = NotificacionSuscripcion::find()
                            ->where(['visto' => 0, 'id_suscripcion' => $idSuscripcion])           
                            ->all();
            foreach ($notificaciones as $notificacion){
               $notificacion->visto = 1;
               $notificacion->fecha_visto = date('Y-m-d H:i:s');
               $notificacion->save();
               unset($notificacion);
            }
            return ['Correcto'=>true];
        }
    }
    
    public function actionDetalleNotificacion()
    {
        Yii::$app->response->format = Response::FORMAT_JSON;
        $id = filter_input(INPUT_POST, 'id');
        $usuario = Yii::$app->user->identity;
        $idSuscripcion = $usuario->suscripcion->id;
        $notificacionSus = NotificacionSuscripcion::find()
                ->where(['id_notificacion'=>$id, 'id_suscripcion'=>$idSuscripcion])
                ->one();
        $notificacionSus->leido = 1;
        $notificacionSus->fecha_leido = date('Y-m-d H:i:s');
        $notificacionSus->update();
        $titulo = $notificacionSus->notificacion->titulo;
        $descripcion = $notificacionSus->notificacion->descripcionNotificacion;
        $accion = $notificacionSus->notificacion->accionNotificacion;
        $verbo = $notificacionSus->notificacion->verbo == null ? 'No definido' : $notificacionSus->notificacion->verbo;  
        return ['Correcto'=>true, 'id'=>$id, 'titulo'=>$titulo, 'descripcion'=>$descripcion, 'accion'=>$accion, 'verbo'=>$verbo];
       
    }
    
    /**
     * Delete an existing Notification model
     * If delete is successful, the broswer will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        NotificacionSuscripcion::deleteAll(['id_notificacion'=>$id]);
        $this->findModel($id)->delete();
        return $this->redirect(['index']);
    }
    
    /**
     * Finds the Notificacion model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Notificacion the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    private function findModel($id)
    {
        if(($model = Notificacion::findOne($id)) != null){
            return $model;
        }
        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    public function excludeFromSecurity() {
        return ['notificaciones','marcar-visto', 'marcar-leido', 'detalle-notificacion'];
    }
    
    public function beforeAction($action)
    {            
        if ($action->id == 'notificaciones') {
            $this->enableCsrfValidation = false;
        }

        return parent::beforeAction($action);
    }
}
