<?php

namespace app\controllers;

use Yii;
use app\models\PlantillaMensaje;
use yii\web\Response;
use app\customs\BaseController;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Paciente;
use ClickSend\Configuration;
use ClickSend\Api\SMSApi;
use GuzzleHttp\Client;
use ClickSend\Model\SmsMessage;
use ClickSend\Model\SmsMessageCollection;
use app\models\BitacoraMensajeLibre;
use app\models\BitacoraMensajePaciente;
use app\customs\SesionUtils;
use app\customs\Utils;


class MensajeriaController extends BaseController
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all PlantillaMensaje models.
     * @return mixed
     */
    public function actionIndex()
    {
        $prefijo = SesionUtils::getLlaveValor('identificativo_profesion')->valor;
        return $this->render('index',['prefijo'=>$prefijo]);
    }

    
    public function actionSend(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $post = Yii::$app->request->post();
        $envioSMS = \app\models\Configuracion::findOne(['llave' => 'envio_global_sms']);
        $strEnvioSMS = $envioSMS->valor;
        $msg = $post["msg"];
        $recp = $post["recp"];
        $email = filter_var($post["email"],FILTER_VALIDATE_BOOLEAN);
        $sms = filter_var($post["sms"],FILTER_VALIDATE_BOOLEAN);
        if($email){
            $this->sendMail($msg, $recp);
        }
        if($sms && filter_var($strEnvioSMS,FILTER_VALIDATE_BOOLEAN)){
            $this->sendSms($msg, $recp);
        }
        $this->guardarBitacora($email, $sms, $msg, $recp);
        return ['Correcto'=>true];
    }
    

    /**
     * Displays a single PlantillaMensaje model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new PlantillaMensaje model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new PlantillaMensaje();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing PlantillaMensaje model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing PlantillaMensaje model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the PlantillaMensaje model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return PlantillaMensaje the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = PlantillaMensaje::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

    private function sendMail($mensaje,$idPacientes)
    {
        
        $usuario  = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $apellido = $suscripcion->usuario->perfil->primerApellido;
        //Arreglo de objeto del modelo de la tabla
        $prefijo = SesionUtils::getLlaveValor('identificativo_profesion')->valor;
        $nombrePl = SesionUtils::getLlaveValor('nombre_publico')->valor;
        foreach ($idPacientes as $id)
        {
            $paciente = Paciente::findOne(['id' => $id]);
            $nombre_paciente=$paciente->primerNombre;
            $email=$paciente->email == null ? null : $paciente->email;
            $search= array('{paciente}','{especialista}');
            $replace  = array($nombre_paciente, $prefijo.' '.$nombrePl);
            $per_msg=str_replace($search,$replace,nl2br($mensaje)); //Reemplaza los parámetros por los valores personales cuando envía los correos
            if($email != null){
                Yii::$app->mailer->compose('correo-libre',['message'=>$per_msg])
                    ->setFrom(['info@oliviahealth.com' => 'Olivia Health'])
                    ->setTo($email)
                    ->setSubject("Mensaje de ".SesionUtils::armarArticulo($suscripcion->id))
                    ->send();
            }
         }

     return true;
    }

    private function sendSms($mensaje,$idPacientes)
    {
        $messages = [];
        $username = \yii::$app->params["clickSendU"];
        $password = \yii::$app->params["clickSendP"];
        $csConfig = Configuration::getDefaultConfiguration()
            ->setUsername($username)
            ->setPassword($password);
        $csApi = new SMSApi(new Client(['verify' => false]),$csConfig);
        $smsCollector = new SmsMessageCollection();
        $usuario  = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $prefijo = SesionUtils::getLlaveValor('identificativo_profesion')->valor;
        $nombrePl = SesionUtils::getLlaveValor('nombre_publico')->valor;
        $nombePublico = Utils::eliminarTildes($nombrePl);
        foreach ($idPacientes as $id)
        {
            $paciente = Paciente::findOne(['id' => $id]);
            $nombre_paciente=$paciente->primerNombre;
            $celular=$paciente->celular;
           // $email=$paciente->email;
            $search= array('{paciente}', '{especialista}');
            $replace  = array($nombre_paciente, $nombePublico);
            $per_msg=str_replace($search,$replace,$mensaje); //Reemplaza los parámetros por los valores personales cuando envía los correos
            $final_message= new SmsMessage();
            $final_message->setBody(html_entity_decode(strip_tags($per_msg)));
            $final_message->setTo($celular);
            $final_message->setSource("sdk");
            //Accede a la instancia de la API y envía los mensajes
            $messages[]=$final_message;
        }
        if(count($messages) > 0)
        {
            $smsCollector->setMessages($messages);
            $result = $csApi->smsSendPost($smsCollector);
        }
        return true;
    }
    
    /**
     * 
     * @param boolean $email
     * @param boolean $sms
     * @param string $msg
     * @param int[] $idsPacientes
     */
    private function guardarBitacora($email,$sms,$msg,$idsPacientes){
        $usuario = Yii::$app->user->identity;
        $bitacora = new BitacoraMensajeLibre();
        $bitacora->es_email = $email ? 1 : 0;
        $bitacora->es_sms = $sms ? 1 : 0;
        $bitacora->id_suscripcion = $usuario->suscripcion->id;
        $bitacora->id_usuario = $usuario->id;
        $bitacora->mensaje = $msg;
        $bitacora->fecha = \date("Y-m-d H:i:s");
        $bitacora->save();
        foreach ($idsPacientes as $idPaciente){
            $pacienteBitacora = new BitacoraMensajePaciente();
            $pacienteBitacora->id_bitacora_mensaje = $bitacora->id;
            $pacienteBitacora->id_paciente = $idPaciente;
            $pacienteBitacora->save();
        }
    }
    
    public function excludeFromSecurity(){
         return ['send'];
    }
    
    
    public function checkForSubscription() {
        return ['index'];
    }
}

