<?php

namespace app\controllers;
use yii\helpers\Url;
use yii\web\Controller;

//use bitcko\googlecalendar\GoogleCalendarApi;
use app\customs\GoogleCalendarApi;

/**
 * GoogleApi controller.
 *
 * @package app\controllers
 * @author  Mhmd Backer shehadi (bitcko) <www.bitcko.com>

 */
class GoogleApiController extends Controller
{


    public function actionIndex()
    {
        return "Ok";
    }

    public function actionAuth(){

        $redirectUrl = Url::to(['/google-api/auth'],true);
        $calendarId = 'primary';
        $username=\Yii::$app->user->identity->suscripcion->email;
        $googleApi = new GoogleCalendarApi($username,$calendarId,$redirectUrl);
        if(!$googleApi->checkIfCredentialFileExists()){            
            $googleApi->generateGoogleApiAccessToken();            
        }else{
          return  $this->redirect(array('settings/index'));
        }
        
        if(isset($_GET['code'])){
            return  $this->redirect(array('settings/index'));
        }
    }

    public function actionCreateEvent(){
        $redirectUrl = Url::to(['/google-api/auth'],true);

        $calendarId = 'ckqbkege4a2se66sfnp57j5sro@group.calendar.google.com';
        $username=\Yii::$app->user->identity->suscripcion->email;
        $googleApi = new GoogleCalendarApi($username,$calendarId,$redirectUrl);
        if($googleApi->checkIfCredentialFileExists()){
            $event = array(
                'summary' => 'Google I/O 2021',
                'location' => '800 Howard St., San Francisco, CA 94103',
                'description' => 'A chance to hear more about Google\'s developer products.',
                'start' => array(
                    'dateTime' => '2021-06-24T06:00:00-10:00',
                    'timeZone' => 'America/El_Salvador',
                ),
                'end' => array(
                    'dateTime' => '2021-06-24T06:00:00-10:40',
                    'timeZone' => 'America/El_Salvador',
                ),
                'recurrence' => array(
                    'RRULE:FREQ=DAILY;COUNT=2'
                ),
                'attendees' => array(
                    array('email' => 'lpage@example.com'),
                    array('email' => 'sbrin@example.com'),
                ),
                'reminders' => array(
                    'useDefault' => FALSE,
                    'overrides' => array(
                        array('method' => 'email', 'minutes' => 24 * 60),
                        array('method' => 'popup', 'minutes' => 10),
                    ),
                ),
            );

           $calEvent = $googleApi->createGoogleCalendarEvent($event);
            \Yii::$app->response->data = "New event added with id: ".$calEvent->getId();
        }else{
            return $this->redirect(['auth']);
        }
    }


    public function actionDeleteEvent(){
        $calendarId = 'primary';
        $username="any_name";
        $googleApi = new GoogleCalendarApi($username,$calendarId);
        if($googleApi->checkIfCredentialFileExists()){
            $eventId ='q3bva46vc6s346fuc8jr3qrqn4' ;

             $googleApi->deleteGoogleCalendarEvent($eventId);
            \Yii::$app->response->data = "Event deleted";
        }else{
            return $this->redirect(['auth']);
        }
    }

    public function actionCalendarsList(){
        $redirectUrl = Url::to(['/google-api/auth'],true);
       
        $calendarId = 'ckqbkege4a2se66sfnp57j5sro@group.calendar.google.com';
        $username=\Yii::$app->user->identity->suscripcion->email;
        $googleApi = new GoogleCalendarApi($username,$calendarId,$redirectUrl);

        if($googleApi->checkIfCredentialFileExists()){
          $calendars =    $googleApi->calendarList();
            \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
            \Yii::$app->response->data = $calendars;
        }else{
            return $this->redirect(['auth']);
        }
    }

    public function actionEventsList(){
        $redirectUrl = Url::to(['/google-api/auth'],true);
       
        $calendarId = 'ckqbkege4a2se66sfnp57j5sro@group.calendar.google.com';
        $username=\Yii::$app->user->identity->suscripcion->email;
        $googleApi = new GoogleCalendarApi($username,$calendarId,$redirectUrl);

        if($googleApi->checkIfCredentialFileExists()){
          $calendars =    $googleApi->eventsList();
            \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
            \Yii::$app->response->data = $calendars;
        }else{
            return "error";
        }

       
    }


}