<?php

namespace app\controllers;

use Yii;
use app\models\FormaPago;
use app\customs\BaseController;
use yii\filters\VerbFilter;
use Stripe\Stripe;
use Stripe\Customer;
use Stripe\Subscription;
use app\customs\StripeUtils;
use app\customs\SesionUtils;
use Stripe\Invoice;
use Stripe\Plan;
use Stripe\SubscriptionItem;
/**
 * FormaPagoController implements the CRUD actions for FormaPago model.
 */
class FormaPagoController extends BaseController
{
    
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'create' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all FormaPago models.
     * @return mixed
     */
    public function actionIndex()
    {
        $user = \Yii::$app->user->identity;
        $pref = SesionUtils::getLlaveValor('identificativo_profesion')->valor;
        if($user->tipo == \app\models\Usuario::ASISTENTE){
            $estadoSuscripcion = SesionUtils::EstadoSuscripcionStripe();
            $revisarStripe = SesionUtils::RevisarStripe();
            if($estadoSuscripcion == StripeUtils::ESTADO_ACTIVA 
                    || $estadoSuscripcion == StripeUtils::ESTADO_PRUEBA 
                    || $revisarStripe === false)
            {
                return $this->redirect(['site/index']);
            }
            return $this->render('asistente',['user' => $user, 'prefijo'=>$pref]);
        }
        $secretStripeKey = \Yii::$app->params['strSKey'];
        $publicStripeKey = \Yii::$app->params['strPKey'];
        Stripe::setApiKey($secretStripeKey);
        $model = FormaPago::findOne(['id' => $user->id]);
        $customerSource = null;
        $subscription = null;
        $planStripe = null;
        $usage = 0;
        $extras = 0;
        if($model != null){
			$customerSource = null;
			try{
				$customerSource = Customer::retrieveSource(
					$model->customer_id,
					$model->pay_method
				);
                                $subscriptionSource = Subscription::retrieve($model->subcription_id);
                                $invoiceSource = Invoice::upcoming(['customer'=>$model->customer_id]);
                                $usage = $invoiceSource->lines->data[0]->quantity;
                                if(isset($invoiceSource->lines->data[2])){
                                    $extras = $invoiceSource->lines->data[2]->quantity;
                                }    
			}
			catch(\Exception $ex){
				\Yii::$app->session->setFlash("warning","Existe un error con su forma de pago, por favor revise su cuenta.");
			}
            if($model->subcription_id != null || $model->subcription_id != ''){
                $subscription = StripeUtils::ObtenerSuscripcion($model->subcription_id);
                $planStripe = Plan::retrieve($user->suscripcion->plan->stripe_id);
            }
        }
        $plan = $user->suscripcion->plan;
        return $this->render('index', [
            'model' => $model,
            'customerSrc' => $customerSource,
            'user' => $user,
            'strPKey' => $publicStripeKey,
            'plan' => $plan,
            'estado_suscripcion' => StripeUtils::StatusSuscripcion(),
            'suscripcion' => $subscription,
            'usage' => $usage,
            'extras' => $extras,
            'planStripe' => $planStripe
        ]);
    }
    
    /**
     * Creates a new FormaPago model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {   
        $user = \Yii::$app->user->identity;
        $model = FormaPago::findOne(['id' => $user->id]);
        if (Yii::$app->request->post()) {
            $post = Yii::$app->request->post();
            $stripeToken = $post['stripeToken'];
            $stripeEmail = $post['stripeEmail'];
            $secretStripeKey = \Yii::$app->params['strSKey'];
            Stripe::setApiKey($secretStripeKey);
            $plan = $user->suscripcion->plan;
            $suscripcion = $user->suscripcion;
            if($model == null){
                try{
                    $model = new FormaPago();
                    $customerResult = Customer::create([
                        'email' => $user->nombre_usuario,
                        'name' => $user->perfil->nombreCompleto,
                        'description' => 'Sr(a) ' . $user->perfil->nombreCompleto . ' (Id: ' . $suscripcion->id . ') ' . $suscripcion->email,
                        'source' => $stripeToken,
                    ]);
              
                    $subcriptionResult = Subscription::create([
                      'customer' => $customerResult->id,
                      'trial_from_plan'=>false,
                      'items' => [
                        [
                          'plan' => $plan->stripe_id
                        ],
                      ],
                    ]);

                    $model->id = $user->id;
                    $model->created = $customerResult->created;
                    $model->currency = $customerResult->currency;
                    $model->customer_id = $customerResult->id;
                    $model->description = $customerResult->description;
                    $model->invoice_prefix = $customerResult->invoice_prefix;
                    $model->pay_method = $customerResult->default_source;
                    $model->subcription_id = $subcriptionResult->id;
                    $model->save();
                } catch (\Stripe\Error\Base $e) {
                    $t = Yii::t('app',$e->getMessage());
                    Yii::$app->session->setFlash('danger', $e->getMessage());
                    return $this->redirect(['index']);
                 } catch (\Exception $e) {
                    Yii::$app->session->setFlash('danger', 'Ocurrio un error inesperado ' . $e->getMessage());
                    return $this->redirect(['index']);
                }
                
            }
            else{
                try{
                    $customerResult = Customer::update(
                        $model->customer_id, // stored in your application
                        [
                          'source' => $stripeToken // obtained with Checkout
                        ]
                      );
                $model->pay_method = $customerResult->default_source;
                $model->save();
                } catch (\Stripe\Error\Base $e) {
                    Yii::$app->session->setFlash('danger', $e->getMessage());
                    return $this->redirect(['index']);
                } catch (\Exception $e) {
                    Yii::$app->session->setFlash('danger', 'Ocurrio un error inesperado: ' . $e->getMessage());
                    return $this->redirect(['index']);
                }


            }
            
            Yii::$app->session->set("estado_suscripcion",null);
            Yii::$app->session->set("stripe_activo",null);
            
            return $this->redirect(['index']);
        }
        return $this->render('create', [
            'model' => $model,
        ]);
    }
    
    
    public function actionFacturas(){
        $secretStripeKey = \Yii::$app->params['strSKey'];
        Stripe::setApiKey($secretStripeKey);
        $user = \Yii::$app->user->identity;
        $formaPago = FormaPago::findOne(['id' => $user->id]);
        $resInovice = \Stripe\Invoice::all(['limit' => 3,'customer' => $formaPago->customer_id]);
        return $this->render('facturas',['response' => $resInovice]);
    }
        
    public function actionPlanesDisponibles(){
        return $this->render('planes');
    }
    
        public function actionCambiarPlan(){
        $user = \Yii::$app->user->identity;
        $model = FormaPago::findOne(['id' => $user->id]);
        if (Yii::$app->request->post()) {
            $post = Yii::$app->request->post();
            $stripeToken = $post['stripeToken'];
            $stripeEmail = $post['stripeEmail'];
            $secretStripeKey = \Yii::$app->params['strSKey'];
            Stripe::setApiKey($secretStripeKey);
            $plan = $user->suscripcion->plan;
            $suscripcion = $user->suscripcion;
            if($model == null){
                try{
         
                    $subcriptionResult = Subscription::create([
                      'customer' => $customerResult->id,
                      'trial_from_plan'=>false,
                      'items' => [
                        [
                          'plan' => $plan->stripe_id
                        ],
                      ],
                    ]);

                } catch (\Stripe\Error\Base $e) {
                    $t = Yii::t('app',$e->getMessage());
                    Yii::$app->session->setFlash('danger', $e->getMessage());
                    return $this->redirect(['index']);
                 } catch (\Exception $e) {
                    Yii::$app->session->setFlash('danger', 'Ocurrio un error inesperado ' . $e->getMessage());
                    return $this->redirect(['index']);
                }
                
            }
        }
    }
    
    public function beforeAction($action)
    {            
        if ($action->id == 'create') {
            $this->enableCsrfValidation = false;
        }

        return parent::beforeAction($action);
    }
    
    public function excludeFromSecurity() {
        return ['asistente'];
    }
}
