<?php

namespace app\controllers;

use Yii;
use app\models\FirmaMedico;
use app\customs\BaseController;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;

/**
 * ClinicaController implements the CRUD actions for FirmaMedico model.
 */
class FirmaMedicoController extends BaseController
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }



    /**
     * Creates a new FirmaMedico model.
     * If creation is successful, the browser will be redirected to the 'perfil' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new FirmaMedico();
        $usuario = Yii::$app->user->identity; 
        $model->id_suscripcion = $usuario->suscripcion->id;
        $idS = $usuario->suscripcion->id;
        $firma_act = FirmaMedico::find()->where(['id_suscripcion'=>$idS])->one();
        if ($model->load(Yii::$app->request->post())) {
            $firma = UploadedFile::getInstance($model, 'firma');
            if(!is_null($firma)){
                if($firma_act != null){
                    $file = $firma_act->firma_src_nombre;
                    unlink(strval(Yii::$app->basePath."/web/uploads/firma_medico/".$file)); 
                }
                FirmaMedico::deleteAll(['id_suscripcion'=>$idS]);
                list($nombre,$ext) = explode(".", $firma->name );
                $model->firma_src_nombre = $nombre.'_'.$idS.Yii::$app->security->generateRandomString(8).".{$ext}";
                $model->firma_web_ruta = Yii::$app->security->generateRandomString().".{$ext}";
                Yii::$app->params['uploadPath'] = Yii::$app->basePath.FirmaMedico::RUTA_CARGA;
                $path = Yii::$app->params['uploadPath'] . $model->firma_src_nombre;
                $firma->saveAs($path);
            }
            if($model->save()){
                Yii::$app->session->setFlash('success','Firma guardada exitosamente');
                return $this->redirect(['usuario/profile']);
            }

        }
        
        return $this->render('create', [
            'model' => $model,
        ]);
    }
    
        /**
     * Deletes an existing Clinica model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $usuario = Yii::$app->user->identity;
        $model = $this->findModel($id);
        if($model->id_suscripcion != $usuario->suscripcion->id){
            return $this->redirect(["site/forbidden"], 403);
        }
        $file = $model->firma_src_nombre;
        unlink(strval(Yii::$app->basePath."/web/uploads/firma_medico/".$file)); 
        $model->delete();
        Yii::$app->session->setFlash('danger','Se ha eliminado la firma');
        return $this->redirect(['usuario/profile']);
    }

    /**
     * Finds the FirmaMedico model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return FirmaMedico the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = FirmaMedico::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

}
