<?php

namespace app\controllers;

use Yii;
use app\models\Evento;
use yii\data\ActiveDataProvider;
use app\customs\BaseController;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Usuario;
use app\models\Suscripcion;
use app\customs\SesionUtils;
use app\customs\CalendarGoogle;

/**
 * EventoController implements the CRUD actions for Evento model.
 */
class EventoController extends BaseController
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Evento models.
     * @return mixed
     */
    public function actionIndex()
    {
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $id_suscripcion = $suscripcion->id;
        $queryEventos =  Evento::find()->where(['id_suscripcion' => $id_suscripcion]);
        if($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA){
            $queryEventos->andWhere(['id_clinica' => SesionUtils::ClinicaSeleccionada()->id]);
        }
        $dataProvider = new ActiveDataProvider([
            'query' => $queryEventos
        ]);

        return $this->render('index', [
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Evento model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        $usuario = Yii::$app->user->identity;
        $model = $this->findModel($id);
        if($model->id_suscripcion != $usuario->suscripcion->id){
            //return $this->redirect(["site/forbidden"], 403);
            return $this->redirect(['evento/index']);
        }
        return $this->render('view', [
            'model' => $model,
        ]);
    }

    /**
     * Creates a new Evento model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Evento();
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $model->id_suscripcion = $usuario->suscripcion->id;
        $this->bodyClass ="evento-form";
        if($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA){
            $model->id_clinica = SesionUtils::ClinicaSeleccionada()->id;
        }
        if ( $model->load( Yii::$app->request->post() ) ) {
            $model->id_evento_google_calendar = CalendarGoogle::crearEvento($model);
            if ( $model->save() ) {
                Yii::$app->session->setFlash('success', "El evento ".$model->nombreEvento." se ha guardado exitosamente");
                return $this->redirect(['view', 'id' => $model->id]);
            }
        }
        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Evento model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $usuario = Yii::$app->user->identity;
        if($model->id_suscripcion != $usuario->suscripcion->id){
            //return $this->redirect(["site/forbidden"], 403);
            return $this->redirect(['evento/index']);
        }
        if($model->privacidad == 1  && $usuario->tipo == Usuario::ASISTENTE){
            //return $this->redirect(["site/forbidden"], 403);
            return $this->redirect(['evento/index']);
        }
        if ($model->load(Yii::$app->request->post()) && $model->save()) {

            $updateEvent = CalendarGoogle::actualizarEvento($model);

            Yii::$app->session->setFlash('success', "El evento ".$model->nombreEvento." ha sido actualizado exitosamente");
            return $this->redirect(['view', 'id' => $model->id]);
        }
        $this->bodyClass ="evento-form";
        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Evento model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $usuario = Yii::$app->user->identity;
        $model = $this->findModel($id);
        if($model->id_suscripcion != $usuario->suscripcion->id){
            return $this->redirect(["site/forbidden"], 403);
        }
        if($model->privacidad == 1  && $usuario->tipo == Usuario::ASISTENTE){
            return $this->redirect(["site/forbidden"], 403);
        }
        if( !empty( $model->id_evento_google_calendar ) ){ 
            CalendarGoogle::eliminarEvento( $model->id_evento_google_calendar );
        }
        $model->delete();
        Yii::$app->session->setFlash('danger', "Se ha eliminado el evento ".$model->nombreEvento);
        return $this->redirect(['index']);
    }
    
    /**
     * Finds the Evento model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Evento the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Evento::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    
    public function checkForSubscription() {
        return ['create','update'];
    }
}
