<?php

namespace app\controllers;

use Yii;
use app\models\Clinica;
use app\models\Usuario;
use yii\data\ActiveDataProvider;
use app\customs\BaseController;
use app\models\UsuarioSuscripcion;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\ClinicaProcedimiento;
use yii\web\UploadedFile;

/**
 * ClinicaController implements the CRUD actions for Clinica model.
 */
class ClinicaController extends BaseController
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Clinica models.
     * @return mixed
     */
    public function actionIndex()
    {
        $usuario = Yii::$app->user->identity;
        $id_suscripcion = $usuario->suscripcion->id;
        $dataProvider = new ActiveDataProvider([
            'query' => Clinica::find()->where(['id_suscripcion' => $id_suscripcion]),
        ]);

        return $this->render('index', [
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Clinica model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        $usuario = Yii::$app->user->identity;
        $model = $this->findModel($id);
        $asistentes=UsuarioSuscripcion::find()->where(["id_clinica" => $model->id])->all();
        $clinica_procedimiento_array=$usuario->tipo == Usuario::DOCTOR ? ClinicaProcedimiento::find()->where(['id_clinica' => $model->id])->all() :[];
        if($model->id_suscripcion != $usuario->suscripcion->id){
            return $this->redirect(["site/forbidden"], 403);
        }
        return $this->render('view', [
            'model' => $this->findModel($id),
            'asistentes' => $asistentes,
            'clinica_procedimiento_array'=> $clinica_procedimiento_array
        ]);
    }

    /**
     * Creates a new Clinica model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Clinica();
        $usuario = Yii::$app->user->identity; 
        $model->id_suscripcion = $usuario->suscripcion->id;
        $idS = $usuario->suscripcion->id;
        if ($model->load(Yii::$app->request->post())) {
            $logo = UploadedFile::getInstance($model, 'logo');
            if(!is_null($logo)){
                $nombreExt = explode(".", $logo->name );
                $ext = $nombreExt[1];
                $model->logo_src_nombre = $nombreExt[0].'_'.$idS.Yii::$app->security->generateRandomString(5).".{$ext}";
                $model->logo_web_ruta = Yii::$app->security->generateRandomString().".{$ext}";
                Yii::$app->params['uploadPath'] = Yii::$app->basePath.Yii::$app->params['urlLogoClinica'];
                $path = Yii::$app->params['uploadPath'] . $model->logo_src_nombre;
                $logo->saveAs($path);
            }
            if($model->save()){
                Yii::$app->session->setFlash('success','La Clinica '.$model->nombre.' se ha guardado exitosamente');
                return $this->redirect(['view', 'id' => $model->id]);
            }

        }
        
        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Clinica model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $usuario = Yii::$app->user->identity;
        $idS = $usuario->suscripcion->id;
        if ($model->load(Yii::$app->request->post())) {
            $model->id_suscripcion = $usuario->suscripcion->id;
            $logo = UploadedFile::getInstance($model, 'logo');
            if(!\is_null($logo)){
                $file = $model->logo_src_nombre;
                if($file != null )unlink(strval(Yii::$app->basePath."/web/uploads/logo_clinica/".$file));
                $nombreExt = explode(".", $logo->name );
                $ext = $nombreExt[1];
                $model->logo_src_nombre = $nombreExt[0].'_'.$idS.Yii::$app->security->generateRandomString(5).".{$ext}";
                $model->logo_web_ruta = Yii::$app->security->generateRandomString().".{$ext}";
                Yii::$app->params['uploadPath'] = Yii::$app->basePath.Yii::$app->params['urlLogoClinica'];
                $path = Yii::$app->params['uploadPath'] . $model->logo_src_nombre;
                $logo->saveAs($path);
            }
            if($model->save()){
                Yii::$app->session->setFlash('success', 'La clinica '.$model->nombre.' se ha actualizado exitosamente');
                return $this->redirect(['view', 'id' => $model->id]);
            }
        }
        if($model->id_suscripcion != $usuario->suscripcion->id){
            return $this->redirect(["site/forbidden"], 403);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Clinica model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $usuario = Yii::$app->user->identity;
        $model = $this->findModel($id);
        if($model->id_suscripcion != $usuario->suscripcion->id){
            return $this->redirect(["site/forbidden"], 403);
        }
        if($model->getCitas()->count() > 0){
            Yii::$app->session->setFlash("danger","La clínica no puede ser eliminada ya que cuenta con citas.");
            return $this->redirect(['index']);
        }
        $model->delete();
        Yii::$app->session->setFlash('danger','Se ha eliminado la clinica '.$model->nombre);
        return $this->redirect(['index']);
    }

    /**
     * Finds the Clinica model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Clinica the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Clinica::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
