<?php

namespace app\controllers;

use Yii;
use app\models\Cita;
use app\models\web\CitaWeb;
use app\models\Evento;
use app\customs\BaseController;
use yii\helpers\Url;
use yii\filters\VerbFilter;
use yii\web\Response;
use DateTime;
use DateInterval;
use app\models\Usuario;
use app\customs\SesionUtils;
use app\models\RecordatorioDoctor;
use app\models\Seguimiento;
use app\models\Procedimiento;
use app\models\Suscripcion;
use app\customs\Utils;
use app\customs\GoogleCalendarApi;

class CalendarioController extends BaseController {
    //put your code here
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'citas' => ['post'],
                    'eventos' => ['post'],
                ],
            ],
        ];
    }
    
    public function actionIndex(){

        /*$citaLIKE2 = Cita::find()->filterWhere(['id_cita_google_calendar' => '%'.'r1l9e1d8l9lri7v3k1cq14q7rs'.'%'])->exists();
        $citaLIKE = Cita::find()->where(['like', 'id_cita_google_calendar','%'.'r1l9e1d8l9lri7v3k1cq14q7rs'.'%', false])->exists();
        #r1l9e1d8l9lri7v3k1cq14q7rs_20220301T144000Z
        var_dump($citaLIKE);
        exit();


        $eventoLIKE = Evento::find()->where(['fecha_inicio'=>'2022-03-04 14:00:00','fecha_fin'=>'2022-03-04 14:30:00'])->andfilterWhere(['id_evento_google_calendar' => 'rkc0tmcchernutljdl5msdfnsc'])->exists();
        var_dump($eventoLIKE);
        exit();

        $eventoLIKE = Evento::find()->where(['fecha_inicio'=>'2022-03-04 14:00:00','fecha_fin'=>'2022-03-04 14:30:00'])->andfilterWhere(['id_evento_google_calendar' => 'rkc0tmcchernutljdl5msdfnsc'])->exists();
        var_dump($eventoLIKE);
        exit();
        '2022-03-03 19:00', '2022-03-03 20:00', 15, 1, 'han0jl8g409fa7a3qo58nh7hie_20220304T010000Z',
        */

        

        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $idSuscripcion = $suscripcion->id;
        $id_clinica = $usuario->tipo == Usuario::DOCTOR 
                ? null 
                : SesionUtils::ClinicaSeleccionada()->id;
        $procedimientos = $suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL 
                ? Utils::obtenerProcedimientosClinica($usuario->tipo,$id_clinica,$idSuscripcion)
                : Utils::obtenerProcedimientosGrupo();
        $this->syncEventosGoogleCalendar();
        return $this->render('index' ,['procedimientos' => $procedimientos ]);
    }
    
    
    
    public function actionCitas(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $post = Yii::$app->request->post();
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $start = $post["start"];
        $end = $post["end"];
        //Filtro para clinicas jerarquizadas e individuales
        $esJerarquia = $suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA; 
        $clinicaSelecc = $esJerarquia ? SesionUtils::ClinicaSeleccionada() : null;
        $where = ($usuario->tipo == Usuario::DOCTOR && $suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL)
                ? ['id_suscripcion' => $suscripcion->id]
                : ['id_suscripcion' => $suscripcion->id,
                    'id_clinica' => SesionUtils::ClinicaSeleccionada()->id];
        $citas = Cita::find()->where($where)
                ->andWhere([
                    'or',
                    ['between','fecha',$start,$end],
                    ['between','DATE_ADD(fecha,INTERVAL tiempo_estimado MINUTE)',$start,$end] 
                ])->andFilterWhere(['<>','estado',Cita::CANCELADA])->all();
        
        $citasJson = [];
        foreach ($citas as $cita) {
            $fecha = \DateTime::createFromFormat('d/m/Y H:i', $cita->fecha)->format('Y-m-d H:i');
            list( $colorFondo,$colorBorde ) = $this->coloresCita($fecha, $cita->estado);  
            $curr_date=new DateTime($fecha);
            $curr_date->add(new DateInterval('PT' . $cita->tiempo_estimado . 'M'));
            $citasJson[] = [
                    'title' => $cita->paciente->nombreCompleto,
                    'start' => $fecha,
                    'className' => $cita->estado == Cita::CONFIRMADA ? 'fc-event-success fc-event-solid-primary' : 'fc-event-light fc-event-solid-primary',
                    'color' => $colorFondo,
                    'borderColor' => $colorBorde,
                    'type' => 'cita',
                    'esPresencial' => $cita->tipo_cita == Cita::CITA_PRESENCIAL ? true : false,
                    'end' => $curr_date->format('Y-m-d H:i'),
                    'description' => $cita->asunto == '' ? '(No definido)' : $cita->asunto,
                    'procedimientos' => $cita->procedimientosAplicadosStr,
                    'editable' => false,
                    'tooltip' => true,
                    'cel' => $cita->paciente->celular == '' ? '(No definido)' : $cita->paciente->celular,
                    'email' => $cita->paciente->email == '' ? '(No definido)' : $cita->paciente->email,
                    'url' => Url::toRoute(['cita/view','id' => $cita->id])
                ];
        }
        return $citasJson;
    }
    
    /**
     * Identificadores de color de borde y fondo de cita:  
     * agendada(azul): #85c1e9, 
     * completada(verde): #2ecc71, 
     * reprogramada(naranja): #f39c12, 
     * cancelada(rojo): #f1948a,
     * Inasistencia(rojo): #EC7063; 
     * Asistio (): #013220\
     * @param string $fechaCita
     * @param int $estado
     * @return array ['colorFondo', 'colorBorde']
     */
    private function coloresCita($fecha,$estado){
        $now = strtotime(date('Y-m-d H:i'));
        if( $now > strtotime($fecha) && $estado == Cita::COMPLETADA ){
            return [ '#2ecc71', '#28A45C' ];
        }else if( $now < strtotime($fecha) && ($estado == Cita::CONFIRMADA || $estado == Cita::REPROGRAMADA || $estado == Cita::AGENDADA )){
            return [ '', '#2232AA' ];
        } else if ( $estado == Cita::INASISTENCIA ){
            return [ '#ec7063', '#B62416' ];
        }else {
            return [ '#f39c12', '#C27B0A'];
        } 
    }
    
    public function actionCitasWeb(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $post = Yii::$app->request->post();
        $usuario = Yii::$app->user->identity;
        $start = $post["start"];
        $end = $post["end"];
        $where = $usuario->tipo == Usuario::DOCTOR 
                ? ['id_suscripcion' => $usuario->suscripcion->id]
                : ['id_suscripcion' => $usuario->suscripcion->id,
                    'id_clinica' => SesionUtils::ClinicaSeleccionada()->id];
        $citas = CitaWeb::find()->where($where)
                ->andWhere([
                    'or',
                    ['between','fecha',$start,$end],
                    ['between','DATE_ADD(fecha,INTERVAL tiempo_estimado MINUTE)',$start,$end] 
                ])
                ->andFilterWhere(['estado' => CitaWeb::ACTIVA])
                ->all();
        
        $citasJson = [];
        $color = '#A2D9CE';//gris azulado
        $now = strtotime(date('Y-m-d H:i'));
        foreach ($citas as $cita) {
            $fecha = \DateTime::createFromFormat('d/m/Y H:i', $cita->fecha)->format('Y-m-d H:i');
            $procedimientos = $cita->primerProcedimiento->nombre;
            $curr_date = new DateTime($fecha);
            $curr_date->add(new DateInterval('PT' . $cita->tiempo_estimado . 'M'));
            $citasJson[] = [
                    'start' => $fecha,
                    'end' => $curr_date->format('Y-m-d H:i'),
                    'title' => $cita->paciente->nombreCompleto,
                    'id' => $cita->id,
                    'className' => 'fc-event-ligth fc-event-solid-primary',
                    'color' => $color,
                    'borderColor' => '#343A65',
                    'type' => 'solicitud',
                    'description' => $cita->comentario == null ? '(No definido)' : $cita->comentario,
                    'procedimientos' => $procedimientos,
                    'editable' => false,
                    'tooltip' => true,
                    'cel' => $cita->paciente->celular == '' ? '(No definido)' : $cita->paciente->celular,
                    'email' => $cita->paciente->email == '' ? '(No definido)' : $cita->paciente->email,
                    'url' => 'javascript:void(0);'
                ];
        }
        return $citasJson;
    }
        
    public function actionEventos(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $post = Yii::$app->request->post();
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $id_suscripcion = $suscripcion->id;
        $start = $post["start"];
        $end = $post["end"];
        $esDoctor = $usuario->tipo == Usuario::DOCTOR;
        $Qeventos = Evento::find()->where(['id_suscripcion' => $id_suscripcion])
                ->andWhere([
                'or',
                ['between','fecha_inicio',$start,$end],
                ['between','fecha_fin',$start,$end] 
            ]);
        
        if($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA){
            $Qeventos->andWhere(['id_clinica' => SesionUtils::ClinicaSeleccionada()->id]);
        }
        $eventos = $Qeventos->all();
        $eventosJson = [];
        foreach ($eventos as $evento) {
            $eventosJson[] = [
                    'title' => $evento->nombreEvento,
                    'start' => $evento->fechaInicioDB,
                    'className' => 'fc-event-light fc-event-solid-primary',
                    'color' => '#a569bd',
                    'type' => 'evento',
                    'end' => $evento->fechaFinDB,
                    'allDay' => $evento->todo_dia == null ? false : $evento->todo_dia,
                    'description' => $evento->descripcionEvento,
                    'editable' => false,
                    'tooltip' => false,
                    'url' => Url::toRoute(['evento/view','id' => $evento->id])
                ];
        }
        return $eventosJson;
    }
    
    public function actionRecordatorios(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $post = Yii::$app->request->post();
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $idSuscripcion = $suscripcion->id;
        $start = $post["start"];
        $end = $post["end"];
        $recordatoriosD = RecordatorioDoctor::find()
                        ->where(['id_suscripcion' =>$idSuscripcion, 'finalizado'=>0])
                        ->andWhere([
                            'or',
                            ['between','fecha_inicio',$start,$end],
                            ['between','fecha_fin',$start,$end]
                        ]);
        if($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA){
            $recordatoriosD->andWhere(['id_clinica' => SesionUtils::ClinicaSeleccionada()->id]);
        }
        $recordatorios = $recordatoriosD->all();
        $recordatoriosJson = [];
        $now = date('Y-m-d H:i:s');
        foreach ($recordatorios as $recordatorio){
            $esPaciente = boolval($recordatorio->es_paciente);
            if(strtotime($now) > strtotime($recordatorio->fechaInicioDB) && strtotime($now) > strtotime($recordatorio->fechaFinDB)){
                $color = '#ba4a00';
            } else {
                $color = '#eb984e';
            }
            $recordatoriosJson[] = [
                'title' => $recordatorio->asuntoRecordatorio,
                'start' => $recordatorio->fechaInicioDB,
                'end' => $recordatorio->fechaFinDB,
                'className' => 'fc-event-light fc-event-solid-primary',
                'color'=> $color,
                'type' => 'recordatorio',
                'allDay' => $recordatorio->todo_dia == null ? false : $recordatorio->todo_dia,
                'editable' => false,
                'tooltip' => $usuario->tipo == Usuario::DOCTOR ? true : (($usuario->tipo == Usuario::ASISTENTE && $recordatorio->privacidad ) ? false : true),
                'paciente' => $esPaciente ? $recordatorio->nombrePaciente : 'No definido',
                'cel' => $esPaciente ? ($recordatorio->paciente->celular == '' ? 'No definido' : $recordatorio->paciente->celular) : 'No definido',
                'email' => $esPaciente ? ($recordatorio->paciente->email == '' ? 'No definido' : $recordatorio->paciente->email) : 'No definido', 
                'url' => Url::toRoute(['recordatorio-doctor/view','id' => $recordatorio->id])
            ];
        }        
        return $recordatoriosJson;        
    }
    
    public function actionSeguimientos(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $post = Yii::$app->request->post();
        $hoy = date('Y-m-d H:i');
        $usuario = Yii::$app->user->identity;
        $qSeguimientos  = Seguimiento::find()
            ->where(['id_suscripcion' => $usuario->suscripcion->id])
            ->andWhere(['estado'=> Seguimiento::PENDIENTE])
            ->andWhere(['<=','fecha_seguimiento',date('Y-m-d')]);
        if( $usuario->suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA ){
            $qSeguimientos->andWhere(['id_clinica' => SesionUtils::ClinicaSeleccionada()->id ]);
        }
        $seguimientos = $qSeguimientos->all();
        $result = [];
        if(count($seguimientos) > 0){
            $result[] = [
                'title' => 'Seguimientos Pendientes',
                'start' => $hoy,
                'end' => \date('Y-m-d H:i', \strtotime($hoy.'+5 hours')),
                'className' => 'fc-event-light fc-event-solid-info',
                'color'=> '#ff0800',
                'type' => 'seguimientos',
                'allDay' => true,
                'editable' => false,
                'url' => Url::toRoute(['seguimiento/index']) 
            ];
        }
        return $result;
    }
    
    
    public function excludeFromSecurity(){
         return [
             'citas',
             'citas-web',
             'eventos', 
             'recordatorios', 
             'seguimientos'];
    }
    
    public function beforeAction($action)
    {            
        if ($action->id == 'citas' || $action->id == 'citas-web' ||$action->id == 'eventos' || $action->id == 'recordatorios' || $action->id == 'seguimientos') {
            $this->enableCsrfValidation = false;
        }

        return parent::beforeAction($action);
    }

    private function syncEventosGoogleCalendar($data = null){


        $google_calendar = SesionUtils::configuracionSesion('google_calendar');
        $calendarId = $google_calendar->valor;
            

        if( empty($calendarId) ){
            return;
        }

        if(is_null($data)){
            $eventos = $this->listarEventos($calendarId);            
        }else{
            $eventos = $this->listarEventos($calendarId, $data);            
        }
        $k=0;

        foreach($eventos as $evento=>$e){

            $id_google_evento = $evento;

            $existe = $this->existeEvento($e[0]['id'],$e[0]['start'],$e[0]['end'],$calendarId);
               
             
            if(!$existe){

                $model = new Evento();
                $model->nombre = $e[0]['summary'];
                $model->descripcion = $e[0]['description'];
                $model->fecha_inicio = $e[0]['start'];
                $model->fecha_fin = $e[0]['end'];
                $model->id_suscripcion = \Yii::$app->user->identity->suscripcion->id;
                $model->privacidad = 1;
                $model->id_evento_google_calendar = $id_google_evento;
                $model->tododiaGoogleCalendar();
                $model->save();
                //$err = $model->getErrors();
            }           
        }
        
    }

    /**
     * Verificar si existe google calendar en la tabla citas, eventos y recordatorio_doctor
     * @param string $id_google_calendar
     * @return boolean
     */
    private function existeEvento($id_google_calendar,$dateStart,$dateEnd,$calendarId=null){

        $explodeIdGoogle = explode('_', $id_google_calendar);
        $id_google_calendar_cita = $explodeIdGoogle[0];

        $citaLIKE = Cita::find()->where(['like', 'id_cita_google_calendar','%'.$id_google_calendar_cita.'%', false])->exists();
        $existeCita = ($citaLIKE) ? true : false ;
        
        $eventoQuery =  Evento::find()
                                ->where(['like', 'id_evento_google_calendar','%'.$id_google_calendar_cita.'%', false])
                                ->one();

        if($eventoQuery){                        
            if($eventoQuery->fecha_inicio==$dateStart && $eventoQuery->fecha_fin==$dateEnd){
                $existeEvento = true;
            }else{
                $existeEvento = false;
                $this->borrarEvento($eventoQuery->id);    
            }
            
        }else{            
            $existeEvento = false;
        }


        

         
        $existeRecordatorio = ( RecordatorioDoctor::find()->where(['id_evento_google_calendar' => $id_google_calendar])->exists() ) ? true : false ;


        #var_dump($existeEvento);
        #var_dump($existeCita);
        #var_dump($existeRecordatorio);
        
        if( !$existeEvento && !$citaLIKE ){
            return false;
        }else{
            return true;
        }
        
    }

    private function listarEventos($calendarId, $data=null){
        $calendars = "";
        $redirectUrl = Url::to(['/google-api/auth'],true);
        $username=\Yii::$app->user->identity->suscripcion->email;
        $googleApi = new GoogleCalendarApi($username,$calendarId,$redirectUrl);

        if( $googleApi->checkIfCredentialFileExists() ){
          $calendars =    $googleApi->eventsList();
        }else{
            return [];
        }
        return  $calendars;
    }

    private function obtenerEvento($calendarId,$eventId){
        $calendars = false;
        $redirectUrl = Url::to(['/google-api/auth'],true);
        $username=\Yii::$app->user->identity->suscripcion->email;
        $googleApi = new GoogleCalendarApi($username,$calendarId,$redirectUrl);
        var_dump($eventId);
        var_dump($googleApi->getGoogleCalendarEvent($eventId));
        if( !$googleApi->getGoogleCalendarEvent($eventId) ){
          return false;
        }else{
            return true;
        }
        return  $calendars;
    }

    private function borrarEvento($id){
        $evento = Evento::findOne($id);
        $evento->delete();
    }

    private function deleteEventInNotExist(){
        
    }


}
