<?php

namespace app\controllers;

use Yii;
use app\customs\BaseController;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\Response;
use app\models\Adjunto;
use yii\web\UploadedFile;
use app\models\CitaAdjunto;

class AdjuntoController extends BaseController 
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }
        
    public function actionUpdate($id){
        $model = $this->findModel($id);
        if($model->load(Yii::$app->request->post())){
            $adjunto = UploadedFile::getInstances($model, 'adjunto');
            if(!is_null($adjunto)){
                $model->adjunto_src_nombre = $adjunto->name;
                $ext = explode(".", $adjunto->name )[1];
                $model->adjunto_web_ruta = Yii::$app->security->generateRandomString().".{$ext}";
                Yii::$app->params['uploadPath'] = Yii::$app->basePath . '/web/uploads/adjuntos/';
                $path = Yii::$app->params['uploadPath'] . $model->adjunto_web_ruta;
                $adjunto->saveAs($path);
                if($model->save()){
                    return $this->redirect(['']);
                }
            }
        }
    }
    
    public function actionUpdateDescripcion(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $id = filter_input(INPUT_POST, 'id');
        $descripcion = filter_input(INPUT_POST, 'title');
        $model = $this->findModel($id);
        $model->descripcion = $descripcion;
        if($model->save()){
            return [
                'Correcto' => true, 
                'id' => $model->id, 
                'src' => $model->urlAdjunto, 
                'srcname' => $model->urlAdjunto, 
                'tipo' => $model->tipo, 
                'descripcion' => $model->descripcion, 
                '_nombre_' => $model->adjunto_src_nombre
            ];
        }
    }
    
    public function actionDelete(){
        $id = filter_input(INPUT_POST, 'id');
        $model = $this->findModel($id);
        Yii::$app->response->format = Response::FORMAT_JSON;
        $citaAdjunto = CitaAdjunto::find()->where(['id_adjunto'=>$model->id]);
        if($citaAdjunto != null){
            CitaAdjunto::deleteAll(['id_adjunto'=>$model->id]);
        }
        $model->delete();
        return ['Correcto'=>true];
    }
    
    /**
     * Finds the Adjunto model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Adjunto the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    private function findModel($id){
        if(($model = Adjunto::findOne($id) )!= null){
            return $model;
        }
        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    public function beforeAction($action)
    {            
        if ($action->id == 'confirmar-cita') {
            $this->enableCsrfValidation = false;
        }

        return parent::beforeAction($action);
    }
    
    public function excludeFromSecurity() {
        return ['update-descripcion'];
    }
    
    
    
}

