<?php

$params = require __DIR__ . '/params.php';
$db = require __DIR__ . '/db.php';
$cronDB = require __DIR__ . '/cron_db.php';
$solicitudWebDB = require __DIR__. '/solicitud_web_db.php';


$config = [
    'id' => 'basic',
    'name'=>'Olivia',
    'language' => 'es',
    'timezone' => 'America/El_Salvador',
    'basePath' => dirname(__DIR__),
    'bootstrap' => ['log'],
    'aliases' => [
        '@bower' => '@vendor/bower-asset',
        '@npm'   => '@vendor/npm-asset',
    ],
    'components' => [
        'request' => [
            // !!! insert a secret key in the following (if it is empty) - this is required by cookie validation
            'cookieValidationKey' => 'CcLDCdlXotWKgiGdxM6PRBZoEUV2loqi',
        ],
        'cache' => [
            'class' => 'yii\caching\FileCache',
        ],
        'user' => [
            'identityClass' => 'app\models\Usuario',
            'enableAutoLogin' => true,
            'enableSession' => true,
            'authTimeout'=> 18000
        ],
        'errorHandler' => [
            'errorAction' => 'site/error',
        ],
        'mailer' => [
            'class' => 'yii\swiftmailer\Mailer',
            // send all mails to a file by default. You have to set
            // 'useFileTransport' to false and configure a transport
            // for the mailer to send real emails.
            'useFileTransport' => false,
            'transport' => [
                'class' => 'Swift_SmtpTransport',
                'host' => 'mail.oliviahealth.com',  // e.g. smtp.mandrillapp.com or smtp.gmail.com
                'username' => 'info@oliviahealth.com',
                'password' => 'rrtm54R?dBZS',
                'port' => '25', // Port 25 is a very common port too
            ]
        ],
        'log' => [
            'traceLevel' => YII_DEBUG ? 3 : 0,
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                ],
            ],
        ],
        'db' => $db,
        'cronDB' => $cronDB,
        'citaWebDB' => $solicitudWebDB,
        
        'urlManager' => [
            'enablePrettyUrl' => true,
            'showScriptName' => false,
            'rules' => [
            ],
        ],
        
        'Menu' => [
            'class' => 'app\config\menu',
        ],
        
        'view' => [
            'theme' => [
                'basePath' => '@app/themes/metronic',
                'pathMap' => ['@app/views' => '@app/themes/metronic'],
                'baseUrl' => '@web/../themes/metronic',
            ],
        ],
    ],
    'params' => $params,
];
$config['bootstrap'][] = 'debug';
    $config['modules']['debug'] = [
        'class' => 'yii\debug\Module',
        // uncomment the following to add your IP if you are not connecting from localhost.
        //'allowedIPs' => ['127.0.0.1'],
        'allowedIPs' => ['179.51.12.21','205.169.39.19'],
    ];
if (YII_ENV_DEV) {
    // configuration adjustments for 'dev' environment
   $config['bootstrap'][] = 'debug';
   $config['modules']['debug'] = [
        'class' => 'yii\debug\Module',
        // uncomment the following to add your IP if you are not connecting from localhost.
        //'allowedIPs' => ['127.0.0.1', '::1'],
    ];

    $config['bootstrap'][] = 'gii';
    $config['modules']['gii'] = [
        'class' => 'yii\gii\Module',
        'generators' => [ //here
            'crud' => [ // generator name
                'class' => 'app\customs\crud\Generator', // generator class
                'templates' => [ //setting for out templates
                    'Metronic' => '@app/customs/crud/defaults', // template name => path to template
                ]
            ]
        ],
        // uncomment the following to add your IP if you are not connecting from localhost.
        //'allowedIPs' => ['127.0.0.1', '::1'],
    ];
}

return $config;
