<?php

$params = require __DIR__ . '/params.php';
$db = require __DIR__ . '/db.php';
$cronDB = require __DIR__ . '/cron_db.php';

$config = [
    'id' => 'basic-console',
    'language' => 'es',
    'timezone' => 'America/El_Salvador',
    'basePath' => dirname(__DIR__),
    'bootstrap' => ['log'],
    'controllerNamespace' => 'app\commands',
    'aliases' => [
        '@bower' => '@vendor/bower-asset',
        '@npm'   => '@vendor/npm-asset',
        '@tests' => '@app/tests',
    ],
    'components' => [
        'cache' => [
            'class' => 'yii\caching\FileCache',
        ],
        'mailer' => [
            'class' => 'yii\swiftmailer\Mailer',
            'useFileTransport' => false,
            'transport' => [
                'class' => 'Swift_SmtpTransport',
                'host' => 'mail.oliviahealth.com',  // e.g. smtp.mandrillapp.com or smtp.gmail.com
                'username' => 'citas@oliviahealth.com',
                'password' => 'Km,dcZnFr?UL',
                'port' => '2525', // Port 25 is a very common port too
            ]
        ],
        'log' => [
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                ],
            ],
        ],
        'db' => $db,
        'cronDB' => $cronDB,

    ],
    'params' => $params,
    /*
    'controllerMap' => [
        'fixture' => [ // Fixture generation command line.
            'class' => 'yii\faker\FixtureController',
        ],
    ],
    */
];

if (YII_ENV_DEV) {
    // configuration adjustments for 'dev' environment
    $config['bootstrap'][] = 'gii';
    $config['modules']['gii'] = [
        'class' => 'yii\gii\Module',
    ];
}

return $config;
