<?php
/**
 * @link http://www.yiiframework.com/
 * @copyright Copyright (c) 2008 Yii Software LLC
 * @license http://www.yiiframework.com/license/
 */

namespace app\assets;

use yii\web\AssetBundle;

/**
 * Main application asset bundle.
 *
 * @author Qiang Xue <qiang.xue@gmail.com>
 * @since 2.0
 */
class ConfiguracionAsset extends AssetBundle
{
    public $basePath = '@webroot';
    public $baseUrl = '@web';
    public $css = [
        //'css/site.css',
        'css/configuraciones.css',
    ];
    public $js = [
        'js/configuracion.js',
        'js/plantilla-historial-medico.js',
        'js/configuracion-pagadito.js',
        'js/url-solicitud-cita.js'
    ];
    public $depends = [
        'yii\web\JqueryAsset',
        'app\themes\metronic\assets\DataTablesAssets'
    ];
}
