/* global _baseURL */

const STR_LONG_USUARIO = 30;

$(document).ready(()=>{
   obtenerConfiguracionUrl();
   $('#url-solicitud').keyup( e => {
       let { value } = e.target;
       const chars = ['#', '^', '&', '*', '?', '\/', '%', '(', ')', '<', '>', ':', ',', '|', '_', '+', '=', '[', ']', '{','}', '~', '"'];
       $('#leng-url-sus').show();
       $('#leng-url-sus').html(value.length + '/' + STR_LONG_USUARIO + ' caracteres');
       $.each(chars, ( i, c )=> {
            if( value.includes( c ) ){
                $('#url-solicitud').val( value.replace(c , '') ); 
                $('#leng-url-sus').html( 'No se permite el uso de caracteres especiales' );
            }
       });
       if( value.length >  STR_LONG_USUARIO ){
            value = value.slice( 0, STR_LONG_USUARIO );
            $('#url-solicitud').val( value );
            $('#leng-url-sus').html( 'Máximo de caracteres permitidos ' + STR_LONG_USUARIO );
            $('#leng-url-sus').removeClass('kt-badge--brand');
            $('#leng-url-sus').addClass('kt-badge--danger');
       } else {
            $('#leng-url-sus').addClass('kt-badge--brand');
            $('#leng-url-sus').removeClass('kt-badge--danger');
            $('#mensaje-url-conf').html( '' );
       }
       if( value.length >= 4 ){
           validarUsuarioStr( value );
       }
   });
   
//   $('#copiar-url-sus').click(()=>{
//       const SHORT_URL = $('#short-url-server').text();
//       const USUARIO_STR = $('#url-solicitud').val();
//       var $temp = $('<input>');
//       $('body').append($temp);
//       $temp.val( SHORT_URL + USUARIO_STR ).select();
//       document.execCommand('copy');
//       $temp.remove();
//       $('#copiar-url-sus').html( '¡Copiado!' );
//       setTimeout( ()=>{ $('#copiar-url-sus').html( 'Copiar' ); }, 2000);
//   });
   
});

function obtenerConfiguracionUrl(){
    $.get( _baseURL + '/url-solicitud-cita/index',  
        ( json )=>{
            if( json.Correcto ){
                $('#url-solicitud').val( json.UsuarioUrl );
            } else {
                $.bsAlert( json.Mensaje );
            }
        }, 
    'json');
} 

function validarUsuarioStr( str ){
    $.get( _baseURL + '/url-solicitud-cita/validar-existencia',
        {
            str: str
        },
        ( json ) => {
            if(!json.Correcto){
                $('#mensaje-url-conf').html( json.Mensaje );
            }    
        }, 
    'json');
}

function guardarConfUrlUsuario(){
    const str = $('#url-solicitud').val();
    if( str === ''){
        $('#mensaje-url-conf').html( 'El campo no debe quedar vacío. Configure su usuario' );
        return 0;
    }
    $.post( _baseURL + '/url-solicitud-cita/guardar-url-usuario',
        {
            str: str
        },
        ( json ) => {
            if(json.Correcto){
                $('#mensaje-url-conf').html( json.Mensaje );
            }    
        }, 
    'json');
}
