    /* global _baseURL */

var modal_open = 'none';
var esDeLista = false;
const WINDOW_URL = window.location.href.split('/'); 
const controller = WINDOW_URL[WINDOW_URL.length -2];
const SITE = 'site';
const CALENDARIO = 'calendario';
$(document).ready(()=>{
    
    listarSolicitudes();
    
    $('.denegar').click( () =>{
        $('#confirmar-denegacion-modal').modal('toggle');
    });
    
    
    $('#info-coment').click( () =>{
        $('#solicitud-cita-web-info').modal('toggle');
    });
    
    $('#enviar-ls-espera').click(()=>{
        denegarSolicitud( true );
    });
    
    $('#no-enviar-ls-espera').click(()=>{
        denegarSolicitud( false );
    });
    
    $('.aceptar').click( ()=>{
        $('.aceptar').prop( 'disabled', true );
        const id = $('#id_solicitud').val()-0;
        aceptar(id);
    });
            
    $('#solicitud-cita-web-info').on('shown.bs.modal', ()=>{
        toggleHideShowModalOpen( 'hide', 'solicitud-cita-web-info' );
    });
    
    $('#solicitud-cita-web-info').on('hidden.bs.modal', ()=>{
        toggleHideShowModalOpen( 'show', 'solicitud-cita-web-info' );
    });
    
    $('#solicitud-cita-web-detalle').on('hidden.bs.modal', ()=>{
        resetDetalleModal();
        toggleHideShowModalOpen( 'show', 'solicitud-cita-web-detalle' );
    });
    
    $('#solicitud-cita-web-detalle').on('shown.bs.modal', ()=>{
        toggleHideShowModalOpen( 'hide', 'solicitud-cita-web-detalle' );
    });
    
    $('#confirmar-denegacion-modal').on('hidden.bs.modal', ()=>{
        $('#lista_espera').prop( 'checked', false );
        toggleHideShowModalOpen( 'show', 'confirmar-denegacion-modal' );
        esDeLista ? $('#solicitudes-cita-modal').show() : $('#solicitudes-cita-modal').hide();
        esDeLista = false;
    });
    
    $('#confirmar-denegacion-modal').on('shown.bs.modal', ()=>{
        toggleHideShowModalOpen( 'hide', 'confirmar-denegacion-modal' );
    });
    
    $('#solicitud-a-seguimiento-modal').on('shown.bs.modal', ()=>{
        toggleHideShowModalOpen( 'hide', 'solicitud-a-seguimiento-modal' );
    });
    
    $('#solicitud-a-seguimiento-modal').on('hidden.bs.modal', ()=>{
        toggleHideShowModalOpen( 'show', 'solicitud-a-seguimiento-modal' );
    });
    
    $('#guardar-seguimiento').click(()=>{
        const id = $('#id_solicitud').val()-0;
        const motivo = $('#motivo-seguimiento').val();
        $.post( _baseURL + '/solicitud-cita/solicitud-a-seguimiento',
        {
            id: id,
            motivo: motivo
            
        }, ( json ) =>{
            if( json.Correcto ){
                $.bsAlert('Seguimiento creado correctamente');
                $('#solicitud-a-seguimiento-modal').modal('toggle');
                listarSolicitudes();
                ( !esDeLista && controller === CALENDARIO ) && initCalendarVoidParams();
                ( !esDeLista && controller === CALENDARIO ) && $('#solicitud-cita-web-detalle').modal('toggle');
                esDeLista = false;
            } else {
                $.bsAlert( json.mensaje );
            }
        }, 'json');
    });
    
    
});

function toggleHideShowModalOpen( accion, id ){
    const modals = $('.modal-solicitud');
    $.each( modals, (i, m)=>{
        if( m.classList.contains('show') && m.id !== id ){
            accion === 'show' ? $( '#' + m.id ).show() : $( '#' + m.id ).hide();
        }
    });
}

function closeAllModalOpen(){
    const modals = $('.modal-solicitud');
    $.each( modals, (i, m)=>{
        if( m.classList.contains('show') && m.id !== 'solicitudes-cita-modal' )$( '#' + m.id ).modal('toggle');
    });
}

function showAllModalOpen(){
    const modals = $('.modal-solicitud');
    $.each( modals, (i, m)=>{
        $( '#' + m.id ).show();
    });
}


function listarSolicitudes(){
    $.get(_baseURL + '/solicitud-cita/index', (json)=>{
        if(json.Correcto){
            var elementos = '';
            $('#items-lista-solicitudes').children().remove();
            const numSolicitudes = json.Solicitudes.length;
            $('#label-num-sl').html( numSolicitudes );
            if( numSolicitudes > 0 ){
                $.each(json.Solicitudes,(i,el)=>{
                    elementos += '<div class="d-flex align-items-center bg-light rounded p-5 mb-9">\n\
                                <div class="d-flex flex-column flex-grow-1 mr-2">\n\
                                    <a href="#" class="font-weight-bold text-dark-75 text-hover-primary font-size-lg mb-1">\n\
                                        '+el.paciente.nombreCompleto+'\n\
                                    </a>\n\
                                    <span class="text-muted font-weight-bold">'+el.fecha+'</span>\n\
                                    <span class="text-muted font-weight-bold">'+el.comentario+'</span>\n\
                                    <span class="text-muted font-weight-bold">'+el.tipoCita+'</span>\n\
                                </div>\n\
                                    '+acionesSolicitudes( el.id, el.fecha_expirada )+'\n\
                            </div>\n\
                            <hr>';
                    });
                $('#items-lista-solicitudes').append( elementos );
                initInfoEventLs();
                initDenegarEventLs();
                initAceptarEventLs();
                initClickBtnSeguimiento()
            } else {
                noSolicitudesMsg();
            }
        }
    },'json');
}


function acionesSolicitudes(id, fechaExpirada){
    if ( fechaExpirada ){
        return '<button style="margin:5px;" data-id="'+id+'" class="font-weight-bolder btn btn-success btn-sm py-1 font-size-lg ls-s-seguimiento">Crear seguimiento</button>';
    } else {
        return '<a href="javascript:void(0);" style="margin:5px;" data-id="'+id+'" class="font-weight-bolder btn btn-danger btn-sm py-1 font-size-lg denegar-ls">Denegar</a>\n\
                <a href="javascript:void(0);" style="margin:5px;" data-id="'+id+'" class="font-weight-bolder btn btn-success btn-sm py-1 font-size-lg aceptar-ls">Aceptar</a>\n\
                <a href="javascript:void(0);" style="margin:5px;" data-id="'+id+'" class="font-weight-bolder btn btn-brand btn-sm py-1 font-size-lg info-ls">Información</a>';
    }
}

function initClickBtnSeguimiento(){
    $('.ls-s-seguimiento').click( e => {
        esDeLista = true;
        $('#id_solicitud').val( e.target.dataset.id-0 );
        $('#solicitud-a-seguimiento-modal').modal( 'toggle' );
    });
}


function viewSolicitud( id ){
    $.get( _baseURL + '/solicitud-cita/view', 
    {
        id: id
    }, ( json ) => {
        if(json.Correcto){
            setDetalleModal( json.model );
            setInfoModal( json.model );
            $('#solicitud-cita-web-detalle').modal('toggle');
        } else {
            $.bsAlert(json.mensaje);
        }
    },'json');
}


function setDetalleModal( model ){
    $('#id_solicitud').val( model.id );
    $('#paciente-detalle').html( model.paciente.nombreCompleto );
    $('#fecha-detalle').html( model.fecha );
    $('#tipo-cita-detalle').html( model.tipoCita );
    $('#acciones-secundarias').hide();
    $('#acciones-principales').show();
    if( model.fecha_expirada ){
        $('#acciones-principales').hide();
        $('#acciones-secundarias').show();
    }
}

function setInfoModal( model ){
    $('#titulo-solicitud').html('Solicitud de ' + model.paciente.nombreCorto );
    $('#paciente').html( model.paciente.nombreCompleto );
    $('#fecha').html( model.fecha );
    $('#tipo-cita-label').html( 'Tipo de cita: ' + model.tipoCita );
    $('#procedimiento').html( 'Procedimiento: ' + model.procedimientos );
    $('#cometario').html( 'Comentario: ' + model.comentario );
}

function resetDetalleModal(){
    $('#id_solicitud').val( '' );
    $('#paciente-detalle').html( '' );
    $('#fecha-detalle').html( '' );
    $('#tipo-cita-detalle').html( '' );
    $('#titulo-solicitud').html( '' );
    $('#paciente').html( '' );
    $('#fecha').html( '' );
    $('#tipo-cita-label').html( '' );
    $('#procedimiento').html( '' );
    $('#cometario').html( '' );
}

function noSolicitudesMsg(){
    $('#items-lista-solicitudes').append('<div class="d-flex align-items-center bg-light rounded p-5 mb-9">\n\
        <div class="d-flex flex-column flex-grow-1 mr-2">\n\
            <a href="javascript:void(0);" class="font-weight-bold text-dark-75 text-hover-primary font-size-lg mb-1">\n\
                No hay solicitudes para mostrar\n\
            </a>\n\
            <span class="text-muted font-weight-bold">No se ha realizado ninguna solicitud.</span>\n\
        </div>\n\
    </div>');
}


function initDenegarEventLs(){
    $('.denegar-ls').click( e =>{
        esDeLista = true;
        $('#id_solicitud').val( e.target.dataset.id-0 );
        $('#confirmar-denegacion-modal').modal('toggle');
    });
}

function initAceptarEventLs(){
    $('.aceptar-ls').click( e =>{
        $('.aceptar-ls').addClass('btn disabled');
        esDeLista = true;
        const id = e.target.dataset.id-0;
        aceptar(id);
    });
}

function initInfoEventLs(){
    $('.info-ls').click( e =>{
        const id = e.target.dataset.id-0;
        esDeLista = true;
        $.get( _baseURL + '/solicitud-cita/view', 
        {
            id: id
        }, ( json ) => {
            if( json.Correcto ){
                $('#id_solicitud').val( json.model.id );
                setInfoModal( json.model );
                $('#solicitud-cita-web-info').modal('toggle');
            } else {
                $.bsAlert(json.mensaje);
            }
        },'json');
    });
}

function aceptar( id ){
    $.get( _baseURL + '/solicitud-cita/aceptar',
    {
        id: id
    },
    ( json )=> {
        if( json.Correcto ){
            $.bsAlert( json.Mensaje ); 
            closeAllModalOpen();
            controller === CALENDARIO && initCalendarVoidParams();
            controller === SITE && funcionFinalConfirmarCita();
            listarSolicitudes();
        } else {
            $.bsAlert( json.Mensaje ); 
        }
        $('.aceptar').prop( 'disabled', false );
        $('.aceptar-ls').removeClass('btn disabled');
    },
    'json');
}

function denegarSolicitud( bool_lista_espera ){
    const id = $('#id_solicitud').val()-0;
    $.post( _baseURL + '/solicitud-cita/denegar', 
        {
            id: id,
            lista_espera: bool_lista_espera ? 1 : 0 
        }, ( json )=>{
            if( json.Correcto ){
                esDeLista = false;
                $('#confirmar-denegacion-modal').modal('toggle');
                closeAllModalOpen();
                listarSolicitudes();
                $.bsAlert( json.Mensaje ); 
                controller === CALENDARIO && initCalendarVoidParams();
                controller === SITE && funcionFinalConfirmarCita();
            } else {
                $('#confirmar-denegacion-modal').modal('toggle');
                $.bsAlert( json.Mensaje ); 
            }
    },'json'); 
}