Chart.defaults.line.spanGaps = true;

$(document).ready(function(){
    
    $("#btnLimpiar").click(function(){
        $("#citas-chart-container").children().remove();
    });
    
    $(".filtro-periodo").closest('label').click(function(){
        cargarDatos("citas-chart-container",$(this).find('.filtro-periodo').val());
    });
    
    $(".filtro-periodo").click(function(e){
        $('#badge-periodo').html(e.target.dataset.label);
        cargarDatos("citas-chart-container",e.target.dataset.periodo);
    });
    
    cargarDatos("citas-chart-container",'week');
    
    
    $('#fecha-inicio').keyup(function(){
        var fecha_n = $('#fecha-inicio').val();
        var re = new RegExp(escapeRegExp('_'),'g');
        var limpiarFecha = fecha_n.replace(re, '');
        var fechaLongitud = limpiarFecha.length;
        if(fechaLongitud == 10){
            var validarFn = existeFecha(fecha_n);
            if(!validarFn){
                $.bsAlert('La fecha ingresada no es válida');
                $('#fecha-inicio').val('');
            }
        }
    });
    
    
    $('#fecha-fin').keyup(function(){
        var fecha_n = $('#fecha-fin').val();
        var re = new RegExp(escapeRegExp('_'),'g');
        var limpiarFecha = fecha_n.replace(re, '');
        var fechaLongitud = limpiarFecha.length;
        if(fechaLongitud == 10){
            var validarFn = existeFecha(fecha_n);
            if(!validarFn){
                $.bsAlert('La fecha ingresada no es válida');
                $('#fecha-fin').val('');
            }
        }
    });
    
    
    $('#obtener-rango').click(function(){
        $('#rango-fechas').modal('toggle');
        $('#badge-periodo').html('Personalizado');
        var fecha_inicio = $('#fecha-inicio').val();
        var fecha_fin = $('#fecha-fin').val();
        if(fecha_inicio == '' || fecha_fin == '' ){
            $.bsAlert('Debe seleccionar dos fechas');
            return;
        }
        var partFi = fecha_inicio.split("/");
        var partFf = fecha_fin.split("/");
        var fI = new Date(partFi[2],partFi[1],partFi[0]);
        var fF = new Date(partFf[2],partFf[1],partFf[0]);
        if(fF.getTime() < fI.getTime()){
            $.bsAlert('La fecha final debe ser mayor a la de inicio');
            return;
        }
        
        var rango = fecha_inicio + '|' + fecha_fin;
        cargarDatos("citas-chart-container",'custom',rango);
        $('#fecha-inicio').val('');
        $('#fecha-fin').val('');
    });
    
});

function escapeRegExp(string) {
  return string.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');//buscar todas las incidencias del valor a reemplazar  
}

function existeFecha(fecha){
      var fechaf = fecha.split("/");
      var dia = fechaf[0];
      var mes = fechaf[1];
      var anio = fechaf[2];
      var f = new Date(anio,mes,'0');
      if( (dia-0)>( f.getDate()-0 ) || (mes-0) >( f.getMonth()+1 ) ){
            return false;
      }
      return true;
}

function cargarDatos(eId,periodo,rango = null){
    if(rango != null){
        data = {periodo:periodo, rango: rango};
    } else {
        data = {periodo:periodo};
    }
    
    $.post(_baseURL + '/reportes/datos-citas-periodo',data,function(data){
        
        var datosGrafica = data.Resultado.DatosGrafica;
        var datosCitas = data.Resultado.DatosCitas;
        $("#citas_versus_fraccion").text(datosCitas.TotalCompletas + "/" + datosCitas.TotalCitas);
        $("#citas_versus_porcentaje").text(datosCitas.Porcentaje + '%');
        $("#citas_ventas_aprox_entero").text('$' + datosCitas.MontoEntero);
        $("#citas_ventas_aprox_centavos").text(datosCitas.Centavos);
        drawChart(eId,datosGrafica,periodo);
        topProcedimientos(data.Resultado.TopProcedimientos);
    },'json');
}

function topProcedimientos(topProcedimientos){
    var divTop ='<div class="kt-widget4__item">\
        <div class="kt-widget4__info">\
            <span class="kt-widget4__title" id="cita_top_titulo_0">\
                $$titulo\
            </span>\
        </div>\
        <span class="kt-widget4__number kt-font-brand"  id="cita_top_cantidad_0">$$monto</span>\
    </div>';
    $("#top_procedimientos").children().remove();
    $("#top_ventas").children().remove();
    $.each(topProcedimientos.Top,function(i,top){
        $("#top_procedimientos").append(divTop.replace('$$titulo',top.nombre).replace('$$monto',top.total));
    });
    $.each(topProcedimientos.Ventas,function(i,top){
        $("#top_ventas").append(divTop.replace('$$titulo',top.nombre).replace('$$monto','$ ' + top.venta));
    });
}

function drawChart(eId,datosGrafica,periodo){
    $("#" + eId).children().remove();
    var canvas = '<canvas class="chart" height="400" width="400"></canvas>';
    $("#" + eId).append(canvas);
    var label = periodo == 'week' ? 'de la semana' : 'del período';
    var ctx = $("#" + eId + " canvas.chart");

    var barChartData = {
        labels: datosGrafica.Labels,
        datasets : [
            {
                label:'Citas ' + label,
                fill: false,
                borderColor : '#646c9aAA',
                pointHoverRadius: 4,
                pointHoverBorderWidth: 12,
                pointBackgroundColor: Chart.helpers.color('#000000').alpha(0).rgbString(),
                pointBorderColor: Chart.helpers.color('#000000').alpha(0).rgbString(),
                pointHoverBackgroundColor: '#74747499',
                pointHoverBorderColor: Chart.helpers.color('#000000').alpha(0.1).rgbString(),
                data: datosGrafica.Conteo,
                lineTension: 0
            },
        ]
    };

    var scatterChart = new Chart(ctx,{
        type: 'line',
        data: barChartData,
            options: {
                responsive: true,
                maintainAspectRatio: false,
                legend: false,
                scales: {
                    xAxes: [{
                        categoryPercentage: 0.35,
                        barPercentage: 0.70,
                        display: true,
                        scaleLabel: {
                            display: false,
                            labelString: 'Month'
                        },
                        gridLines: false,
                        ticks: {
                            display: true,
                            beginAtZero: true,
                            fontColor: '#545454',
                            fontSize: 13,
                            padding: 10
                        }
                    }],
                    yAxes: [{
                        categoryPercentage: 0.35,
                        barPercentage: 0.70,
                        display: true,
                        scaleLabel: {
                            display: false,
                            labelString: 'Value'
                        },
                        gridLines: {
                            color: '#A9A9A9',
                            drawBorder: false,
                            offsetGridLines: false,
                            drawTicks: false,
                            borderDash: [3, 4],
                            zeroLineWidth: 1,
                            zeroLineColor: '#A9A9A9',
                            zeroLineBorderDash: [3, 4]
                        },
                        ticks: {
                            max: Math.max(...datosGrafica.Conteo) + 1,
                            stepSize: 1,
                            display: true,
                            beginAtZero: true,
                            fontColor: '#545454',
                            fontSize: 13,
                            padding: 10
                        }
                    }]
                },
                title: {
                    display: true,
                    text: 'Citas ' + label,
                    fontSize: 18,
                    fontFamily: 'Helvetica Neue',
                    padding: 15
                },
                hover: {
                    mode: 'index'
                },
                tooltips: {
                    enabled: true,
                    intersect: false,
                    mode: 'nearest',
                    bodySpacing: 5,
                    yPadding: 10,
                    xPadding: 10, 
                    caretPadding: 0,
                    displayColors: false,
                    backgroundColor: '#454545AA',
                    titleFontColor: '#ffffff', 
                    cornerRadius: 4,
                    footerSpacing: 0,
                    titleSpacing: 0
                },
                layout: {
                    padding: {
                        left: 0,
                        right: 0,
                        top: 5,
                        bottom: 5
                    }
                }
            }
    });
}