/* global _baseURL, id_paciente, hoy */

$(document).ready(function(){
    $('#fecha_historial').val(hoy);
    $('#plantillas').change(function(){
        const id = $('#plantillas').val();
        let diagnostico = $('#cuerpo_historial').val().trim(); 
        $.get(_baseURL + '/plantilla-historial/view', {id:id},function(json){
            if( json.Correcto ){
                const {titulo,cuerpo} = json;
                $('#plantillas').val('');
                let separador = '---------------------------------------------------';
                $('textarea#cuerpo_historial').val(diagnostico+(diagnostico === '' ? "" : "\n\n")+separador+"\n"+titulo+"\n"+separador+"\n\n"+cuerpo);
            }
        });
    });
    nuevoHistorial();
});

function listaFechasHistorial(id){
    $.get(_baseURL + '/historial-paciente/historial-medico-paciente-fechas', {id:id},function(json){
        if(json.Correcto){
            let items = '';
            if(json.Historial.length > 0){
                $('#items-fecha-historial').children().remove();    
                items += '<div class="kt-list-timeline__item">\n\
                                <span class="kt-list-timeline__badge kt-list-timeline__badge--secondary"></span>\n\
                                <span class="kt-list-timeline__text text-center historial-lista-el" style="cursor: pointer;" id="all" >Todos los historiales</span>\n\
                            </div>';
                $.each(json.Historial,function(i,fecha){
                    const rep = new RegExp(escapeRegExp('/'),'g');
                    const fechaFormato = fecha.replace(rep, '-');
                    items += '<div class="kt-list-timeline__item">\n\
                                <span class="kt-list-timeline__badge kt-list-timeline__badge--brand"></span>\n\
                                <span class="kt-list-timeline__text text-center historial-lista-el" style="cursor: pointer;" id="'+fechaFormato+'" >'+fecha+'</span>\n\
                            </div>'; 
                });
                $('#items-fecha-historial').append( items );
                clickFechasHistorial();
                primerItemHistorial = $('#items-fecha-historial').children()[0].children[1].id;
                historialPaciente(primerItemHistorial);
            } else {
                items += '<div class="kt-list-timeline__item">\n\
                    <span class="kt-list-timeline__badge kt-list-timeline__badge--secondary"></span>\n\
                    <span class="kt-list-timeline__text text-center selected-item" style="cursor: pointer;" id="0" >Sin historiales</span>\n\
                </div>';
                $('#historiales-paciente').append( renderHistorialVacio() );
                $('#items-fecha-historial').append( items );
                documentosPacienteHistorial( [] );

            }
            $('#all').addClass('selected-item'); 
        }
    },'json');
}

function clickFechasHistorial(){
    $('.historial-lista-el').unbind();
    $('.historial-lista-el').click( e => {
        const fecha = e.target.id;
        $('.historial-lista-el').removeClass('selected-item');
        $('#'+fecha).addClass('selected-item'); 
        historialPaciente(fecha);
        //documentosPaciente(id_paciente, fecha);
    });
}


function nuevoHistorial(){
    $('#nuevo-historial').unbind();
    $('#nuevo-historial').click(function(){
        $('#pd-modal').modal('toggle');
        $('#tituloPD').html('Nuevo Historial Evolutivo');
        $('#footerPD').append('<button class="btn btn-success" id="guardar-historial">Guardar</button>');
        btnGuardarNuevoHistorial();
    });
}

function btnGuardarNuevoHistorial(){
    $('#guardar-historial').unbind();
    $('#guardar-historial').click( ()=>{
        const id_paciente = $('#id_paciente').val();
        let cuerpo = $('#cuerpo_historial').val().trim();
        let fecha = $('#fecha_historial').val().trim();
        if( cuerpo === '' || fecha === '' ){
            $.bsAlert('No se puede enviar campos vacios');
            return false;
        }
        $.post(_baseURL + '/historial-paciente/create',{id_paciente,fecha,cuerpo},(json) => {
            if(json.Correcto){
                listaFechasHistorial( id_paciente );
                $('#pd-modal').modal('toggle');
            }
        },'json');
    });
}

function historialPaciente(fecha){
    const id_paciente = $('#id_paciente').val();
    $.post(_baseURL + '/historial-paciente/historial-paciente',{'id':id_paciente, 'fecha':fecha}, function(json){
        if( json.Correcto ){
            let items = '';
            $('#historiales-paciente').children().remove();
            documentosPacienteHistorial( json.Documentos );
            if( json.Historial.length === 0 ){
                $('#historiales-paciente').append( renderHistorialVacio() );
                return;
            }
            $.each(json.Historial, function(i, his){
                if( his.label === 'historial' ){
                    items += '<div class="diagnostico" id="his-'+his.id+'">\n\
                                <div class="label-box text-left">Récord</div><div class="diagnostico-fecha text-right">'+his.fecha+'<i class="la la-print kt-font-primary imprimir-his" id="'+his.id+'"></i><i class="la la-trash kt-font-danger eliminar-his" id="'+his.id+'"></i></div>\n\
                                <a class="box" style="color: #2c3e50l" href="javascript:void(0)"><div id="'+his.id+'" class="diagnostico-box">'+his.cuerpo+'</div></a>\n\
                            </div>';
                } else if( his.label === 'receta' ) {
                    items += '<div class="diagnostico" id="rec-'+his.id+'">\n\
                                <div class="label-box text-left">Receta</div><div class="diagnostico-fecha text-right">'+his.fecha+'<i class="la la-print kt-font-primary icon-pdf" id="'+his.id+'"></i><i class="la la-trash kt-font-danger eliminar-rec" id="'+his.id+'"></i></div>\n\
                                <a class="box-receta" style="color: #2c3e50l" href="javascript:void(0)">\n\
                                    <div id="'+his.id+'" class="receta-box">\n\
                                        '+his.cuerpo+'\
                                    </div>\n\
                                </a>\n\
                            </div>';
                }

            });
            $('#historiales-paciente').append(items);
            editarHistorial();
            eliminarHistorial();
            imprimirHistorial();
            verReceta();
            editarReceta();
            eliminarReceta();
            imprimirReceta();
        }
    },'json');
}

function editarHistorial(){
    $('.box').unbind();
    $('.box').click( e => {
        const id = e.target.id;
        $.get(_baseURL + '/historial-paciente/view?id='+id, function(json){
            if(json.Correcto){
                $('#id_historial').val(json.id);
                $('textarea#cuerpo_historial').val(json.cuerpo);
                $('#fecha_historial').val(json.fecha);
                $('#pd-modal').modal('toggle');
                $('#tituloPD').html('Editar Historial Evolutivo');
                $('#footerPD').append('<button class="btn btn-success" id="editar-diagnostico">Guardar</button>');
                btnEditarHistorial();
            }
        },'json');
    });
}


function btnEditarHistorial(){
    $('#editar-diagnostico').unbind();
    $('#editar-diagnostico').click( ()=>{
        const id = $('#id_historial').val();
        const id_paciente = $('#id_paciente').val();
        let cuerpo = $('#cuerpo_historial').val().trim();
        let fecha = $('#fecha_historial').val().trim();
        if( cuerpo === '' || fecha === '' ){
            $.bsAlert('Debe ingresar los datos requeridos');
            return false;
        }
        $.post(_baseURL + '/historial-paciente/update',{id,fecha,id_paciente,cuerpo},({ Correcto, model})=>{
            if( Correcto ){
                const rep = new RegExp(escapeRegExp('/'),'g');
                const fechaFormato = fecha.replace(rep, '-');
                historialPaciente( fechaFormato );
                $('.historial-lista-el').removeClass('selected-item');
                $('#'+fechaFormato).addClass('selected-item'); 
                $('#pd-modal').modal('hide');
            }
        },'json');
    });
}

$('#pd-modal').on('hidden.bs.modal', function () {
        $('#id_historial').val('');
        $('#tituloPD').html('');
        $('#cuerpo_historial').val('');
        $('#fecha_historial').val(hoy);
        $('#footerPD').children().remove();
});


function eliminarHistorial(){
    $('.eliminar-his').unbind();
    $('.eliminar-his').click((e)=>{
        const id_paciente = $('#id_paciente').val();
        const id = e.target.id;
        let bool = confirm('¿Esta seguro de elimiar este elemento?');
        if( bool ){
            $('#his-'+id).addClass('del-el');
            $.post(_baseURL + '/historial-paciente/delete',{'id':id},(json)=>{
                if(json.Correcto){
                    historialPaciente('all');
                    listaFechasHistorial(id_paciente); 
                }
            },'json');
        }
    });
}

function imprimirHistorial(){
    $('.imprimir-his').unbind();
    $('.imprimir-his').click((e)=>{
        const id = e.target.id;
        window.open(_baseURL + '/historial-paciente/historial-pdf?id='+id, '_blank');
    });  
}

function renderHistorialVacio(){
    return ('<div class="diagnostico">\n\
                <div class="diagnostico-fecha text-right"></div>\n\
                <div class="diagnostico-box">¡No existe ningún historial ni evoluciones médicas para este paciente!</div>\n\
            </div>');
}

function escapeRegExp(string) {
  return string.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
}
