/* global _baseURL */
$(document).ready(function(){
    
    initTablaPlantillas();
    
    $('#crear-plantilla').click(() => {
        $('#tituloCrear').html('Nueva Plantilla de Hisrorial Médico');
        $('#footerCrear').append('<button id="save-plantilla" class="btn btn-success">Guardar</button>');
        $('#plantillaCrear').modal('show');
        toggleHideShowModalsOpen(id='#plantillaCrear',acction='hide');
        btnSavePlantilla();
    });

    $('#plantillaCrear').on('hidden.bs.modal', () => {
        $('#tituloCrear').html('');
        $('#tituloCrearInput').val('');
        $('#id-plantilla').val('');
        $('#footerCrear').children().remove();
        setValQuillEditor( '<p></p>' );
        toggleHideShowModalsOpen(id='plantillaCrear',acction='show');
    });
    
    $('#plantillaCrear').on('shown.bs.modal', ()=>{
        toggleHideShowModalsOpen(id='plantillaCrear',acction='hide');
    });

    $('#plantillaView').on('hidden.bs.modal', () => {
        $('#tituloView').html('');
        $('#bodyView').children().remove();
        $('#footerView').children().remove();
        toggleHideShowModalsOpen(id='plantillaView',acction='show');
    });
    
    $('#plantillaView').on('shown.bs.modal', ()=>{
        toggleHideShowModalsOpen(id='plantillaView',acction='hide');
    });
  
    
    $('body').on('shown.bs.modal', e => {
        console.log(e.target);
    });
    
});//ready function


function initTablaPlantillas() {
    $('#plantillas-t').DataTable({
        "pagingType": "full_numbers",
        "serverSide": true,
        "order": [[ 0, "asc" ]],
        "columnDefs": [{
                "targets": 2,
                "orderable": false
            }],
        "language": {
            "lengthMenu": "Mostrar _MENU_ entradas",
            "zeroRecords": "No se encontrarón resultados :(",
            "info": "Página _PAGE_ de _PAGES_",
            "infoEmpty": "Ninguna coincidencia encontrada",
            "infoFiltered": "(0 de _MAX_ )",
            "search": "Buscar:",
            "paginate": {
                "first": "Inicio",
                "last": "Fin",
                "next": "Sig.",
                "previous": "Ante."
            }
        },
        "createdRow": function (row, data, dataIndex) {
            $(row).attr('data-id', data[0]);
            $(row).addClass('trpointer');
        },
        "ajax": {
            "url": _baseURL + '/plantilla-historial/index',
            "type": "post",
            "dataType": "json",
            "error": (e) => console.log(e)
        },
        "columns": [
            { "data": 1},
            { "data": 2},
            { "data": 3}
        ]
    });
}

function dataTableReload(){
    $('#plantillas-t').DataTable().ajax.reload();
}

$(document).on('click','table tr td:not(.disable-click)',function(e) {
    var id = $(this).closest('tr').data('id');
    if (e.target == this && id){
        toggleCRUD = true;
        verPlantilla(id);
    }
});

function verPlantilla(id){
    $.get(_baseURL + '/plantilla-historial/view', { id }, (json)=>{
        if(json.Correcto){
            $('#tituloView').html(json.titulo);
            $('#bodyView').append('\n\
                <div class="row text-right">\n\
                    <div class="col-md-12"><button id="actualizar-plantilla" data-id="'+json.id+'" class="btn btn-primary">Configurar Plantilla</button>&nbsp;<button id="eliminar-plantilla" data-id="'+json.id+'" class="btn btn-danger">Eliminar</button></div>\n\
                </div>\n\
                <div  class="line"></div>\n\
                <div class="row">\n\
                    <div class="col-md-12">\n\
                        <div class="body-view-content" id="cuerpo-text">'+json.cuerpo+'</div>\n\
                    </div>\n\
                </div>');
            $('#plantillaView').modal('toggle');
            btnClickActualizar();
            btnEliminarPlantilla();
        }
    });
}

function btnClickActualizar(){
    $('#actualizar-plantilla').unbind();
    $('#actualizar-plantilla').click( e =>{
        const id = e.target.dataset.id;
        actualizarPlantilla(id, true);
    });
}


///[^a-zñáéíóúñ¿?¡!()@\/,.-_0-9\/\s]/gi regex aplicado
function btnSavePlantilla(){
    $('#save-plantilla').unbind();
    $('#save-plantilla').click( () => {     
        const titulo = $('#tituloCrearInput').val().trim();
        const cuerpo = $('#plantilla').val().trim();
        if(titulo === '' || cuerpo === ''){
            $.bsAlert('Debe ingresar los datos requeridos');
            return;
        }
        $.post(_baseURL + '/plantilla-historial/create', { titulo, cuerpo }, ({ Correcto })=>{
            if( Correcto ){
                dataTableReload();
                $('#plantillaCrear').modal('toggle');
            }
        },'json');
    });
}

function actualizar(){
    $('.update-btn').unbind();
    $('.update-btn').click( () => {
        const id = $('#id-plantilla').val();
        const titulo = $('#tituloCrearInput').val().trim();
        const cuerpo = $('#plantilla').val().trim();
        if( titulo === '' || cuerpo === '' ){
            $.bsAlert('Debe ingresar los datos requeridos');
            return;
        }
        $.post(_baseURL + '/plantilla-historial/update',{ id, titulo, cuerpo },({ Correcto, titulo, cuerpo })=>{
            if( Correcto ){
                dataTableReload();
                $('#tituloView').html('');
                $('#tituloView').html(titulo);
                $('#cuerpo-text').html('');
                $('#cuerpo-text').html(cuerpo);
                $('#plantillaViewCont').removeClass('no-visible');
                $('#plantillaCrear').modal('toggle');
            }
        },'json');
    });
}

function btnEliminarPlantilla(){
    $('#eliminar-plantilla').unbind();
    $('#eliminar-plantilla').click( (e) => {
        const id = e.target.dataset.id;
        eliminarPlantilla(id,true);
    });
}

function eliminarPlantilla(id,toggle=false){
    const bool = confirm('Esta seguro de eliminar este elemento?');
    if(bool){
        $.post(_baseURL + '/plantilla-historial/delete', { id }, (json) => {
            if(json.Correcto){
                dataTableReload('plantillas-t');
                toggle && $('#plantillaView').modal('toggle');
            }
        },'json');
    }    
}

function actualizarPlantilla(id){
    $.get(_baseURL + '/plantilla-historial/view', { id },({Correcto, id, titulo, cuerpo, cuerpoFormat })=>{
        if( Correcto ){
            $('#tituloCrear').html( titulo );
            $('#tituloCrearInput').val( titulo );
            $('#id-plantilla').val( id );
            setValQuillEditor( cuerpo );
            $('#footerCrear').append('<button id="actualizar-plantilla" class="btn btn-success update-btn">Guardar</button>');
            $('#plantillaCrear').modal('show');
            actualizar();
        }
    });
}

function toggleHideShowModalsOpen(id='none',acction='show'){
    const modals = $('.modal.fade.show');
    const modalsOpenLenght = modals.length;
    const modalBase = modals[0];
    $.map( modals, m => {
        if( m.id !== id && acction==='show'){ 
             m.style.display = 'block'; 
        }
        if( m.id !== id && acction==='hide' ){
            m.style.display = 'none'; 
        }    
    });
    if( modalsOpenLenght > 1 ){
        modalBase.style.display = 'none';
    } 
}

function setValQuillEditor(val){
    $('#historial').val(val);
    $('.ql-editor').html(val);
    //$('#plantilla ')[0]['data-froala.editor'].html.set( cuerpo );
}