/* global _baseURL */
var filtroActividad = 'all';
var actividadManana = 0;
var fechaNotif = '';
var allFilters = true;
var recent = true;
var fechaBase = $('#fecha-actividad').val();
const Seg = 60000;
const Min = 10;
$(document).ready(function(){
    document.cookie = "sort_notif="+(readCookie('sort_notif') === null ? 'SORT_ASC' :  readCookie('sort_notif'));
    funcionFinalConfirmarCita();
    selectedSort();
    selectedFilter();
    $('#fecha-actividad').datepicker({
        'gotoCurrent': true,
        'todayHighlight': true
    });
    $(".filters-notificaciones a").click(function(){
        var tipo = $(this).data('filtro');
        filtrarNotificaciones(this,tipo);
        filtroActividad = tipo;
    });
    $("#confirmarCitaModal").on("hidden.bs.modal", function () {
        if($('#confirmarCitaModal').data("desmarcar")){
            var idCita = $('#confirmarCitaModal').data("id-cita");
            $("#nf-"+idCita).prop("checked", false);
        }
        $('#confirmarCitaModal').data("id-cita",0);
        $('#confirmarCitaModal').find('#btn-confirmarCitaModalYes').unbind( "click" );
        $('#confirmarCitaModal').find('#btn-confirmarCitaModalNo').unbind( "click" );
        $("#confirmarCitaModal button.close").unbind( "click" );
    });
    
    $(".filters-notificaciones-hora a").click(function(){
        var tipo = $(this).data('filtro');
        filtrarNotificacionesOrden(this,tipo);
    });
    
    
    
    setInterval(()=>{
        funcionFinalConfirmarCita();
    }, Seg * Min );
    
});


function filtrarNotificacionesOrden(e,tipo){
    $('.filters-notificaciones-hora').find('.kt-notification__item-icon').remove();
    $(e).prepend('<div class="kt-notification__item-icon">\
                    <i class="flaticon2-checkmark kt-font-success"></i>\
                </div>');
    document.cookie = "sort_notif="+tipo;
    funcionFinalConfirmarCita();
}

function selectedSort(){
    var e = $('.filters-notificaciones-hora a');
    var sortSelected = readCookie('sort_notif');
    $('.filters-notificaciones-hora').find('.kt-notification__item-icon').remove();
    for(i=0; i < e.length; i++ ){
        if(e[i].dataset.filtro === sortSelected){
            $(e[i]).prepend('<div class="kt-notification__item-icon">\
                <i class="flaticon2-checkmark kt-font-success"></i>\
            </div>');
        }
    }
}

function selectedFilter(){
    var e = $(".filters-notificaciones a");
    $('.filters-notificaciones').find('.kt-notification__item-icon').remove();
    for(i=0; i < e.length; i++ ){
        if(e[i].dataset.filtro === 'all'){
            $(e[i]).prepend('<div class="kt-notification__item-icon">\
                <i class="flaticon2-checkmark kt-font-success"></i>\
            </div>');
        }
    }

}

$('#fecha-actividad').change(function(){
   filtroActividad = 'all';
   fechaNotif = $('#fecha-actividad').val();
   var e = $("#all")[0];
   var hrefBtnPdf = $("#download-pdf").attr("href").split("?");
   var base = hrefBtnPdf[0];
   funcionFinalConfirmarCita();
   var splitFNoti = fechaNotif.split('/');
   var splitFBase = fechaBase.split('/');
   var F_Noti = new Date(splitFNoti[2],splitFNoti[1],splitFNoti[0]);
   var F_Base = new Date(splitFBase[2],splitFBase[1],splitFBase[0]);
   if(F_Base.getTime() != F_Noti.getTime()){
       allFilters = true;
       recent = false;
       $("#download-pdf").attr('href',base+'?fe='+fechaNotif);
       filtrarNotificaciones(e,'all');
   }
   if(F_Base.getTime() < F_Noti.getTime()){
       allFilters = false;
       recent = false;
       $("#download-pdf").attr('href',base+'?fe='+fechaNotif);
       filtrarNotificaciones(e,'all');
   }
   if(F_Base.getTime() == F_Noti.getTime()){
       allFilters = true;
       recent = true;
       $("#download-pdf").attr('href',base+'?fe=0');
       filtrarNotificaciones(e,'all');
   }
});

function filtrarNotificaciones(e,tipo){
    $('.filters-notificaciones').find('.kt-notification__item-icon').remove();
    $(e).prepend('<div class="kt-notification__item-icon">\
                    <i class="flaticon2-checkmark kt-font-success"></i>\
                </div>');
     
    if(tipo == 'all'){
        $(".kt-notification-v2__item").show();
        $(".notificacion-recordatorio").hide();
    }
    else{
        $(".kt-notification-v2__item").hide();
        if(tipo == 'evento'){
           $(".notificacion-" + tipo).show();
           $(".notificacion-recordatorio-doctor").show();
        } else if(tipo == 'paciente'){
           $(".notificacion-" + tipo).show();
           $(".notificacion-paciente-nuevo").show();
        }else{
           $(".notificacion-" + tipo).show(); 
        }
    }
    
}

function funcionFinalConfirmarCita(){
    $("#notificaciones-clinica").children().remove();
    $.post(_baseURL + '/site/notificaciones-clinica',{f:'all',sort:readCookie('sort_notif'), fecha:fechaNotif},function(json){
        var notificaciones = "";
        if(json.Correcto){
            $("#fecha-panel").html(json.fechaPanel);
            $.each(json.Notificaciones,function(i,notificacion){
                var icon = iconNotificacion( notificacion );
                var color = colorNotificacion( notificacion );
                var tools = ((json.TipoUsuario == 1 || (json.TipoUsuario == 2 && json.toolCita) ) && (notificacion.tipo == 'cita' && (parseInt(notificacion.estado) < 3) && notificacion.tool == 'Si'  )  )
                                ? ('<label><input type="checkbox" id="nf-' + notificacion.id + '" onclick="confirmar(' + notificacion.id + ')"/></label>\
                                    <!--<a class="btn btn-success btn-xs" href="javascript:void(0);" onclick="confirmar(' + notificacion.id + ',1)">Si</a>\
                                    <a class="btn btn-default btn-xs" href="javascript:void(0);" onclick="confirmar(' + notificacion.id + ',0)">No</a>-->'
                                    )
                                :  '' ;
                var notif = '<div class="kt-notification-v2__item notificacion-' + notificacion.tipo + '" data-id="' + notificacion.id +'">\
                                <a href="' + notificacion.url + '" class="kt-notification-v2__item-icon" data-id="' + notificacion.id +'">\
                                    <i class="' +icon +' '+color+ '"></i>\
                                </a>\
                                <div class="kt-notification-v2__itek-wrapper">\
                                    <span class="kt-notification-v2__item-title">\
                                        <a style="color: #5d5b6f;" href="' + notificacion.url + '" data-id="' + notificacion.id +'">\
                                            ' + notificacion.titulo + '\
                                        </a>\
                                        '+(tools != '' ? '&nbsp;' : '')+tools + '\
                                    </span>\
                                    <div class="kt-notification-v2__item-desc">\
                                        ' + notificacion.tiempo  + '\
                                    </div>\
                                </div>\
                            </div>';
                notificaciones += notif;
            });
            $("#notificaciones-clinica").append(notificaciones);
            showFilter();
            initEventSolicitud();
            filterExcludeActividad();
        }
    },'json');
}

function iconNotificacion( notif ){
    var text = ' t-' + notif.tipo + ' e-' + notif.estado;
    if( notif.tipo === 'paciente' || notif.tipo === 'cita'){
        if( notif.estado-0 === 0 && notif.tipo === 'paciente'){
            return 'flaticon2-list-1' + text;
        } else if((notif.estado-0 === 0 || notif.estado-0 === 2) && notif.tipo === 'cita'){
            return 'flaticon2-calendar-1' + text;
        } else if( notif.estado-0 === 1 ){
            return 'flaticon2-time' + text;
        } else if( notif.estado-0 === 2 && notif.tipo === 'paciente'){
            return 'flaticon2-writing' + text;            
        } else if( notif.estado-0 === 3 ){
            return 'flaticon2-trash' + text;
        } else if ( notif.estado-0 === 4 ){
            return 'flaticon2-checkmark' + text;
        } else {
            return 'flaticon2-cross' + text;
        }
    } else if( notif.tipo === 'mensaje' ){
        return 'flaticon2-talk' + text;
    } else if( notif.tipo === 'feedback' ){
        if( notif.estado-0 === 3 ){
            return 'far fa-grin' + text;
        } else if( notif.estado-0 === 2){
            return 'far fa-meh' + text;
        } else {
            return 'far fa-angry' + text;
        }
    } else if ( notif.tipo === 'recordatorio' ){
        return 'flaticon-bell' + text;
    } else if ( notif.tipo === 'evento' ) {
        return 'flaticon-event-calendar-symbol' + text;
    } else if ( notif.tipo === 'recordatorio-doctor' ){
        return 'flaticon2-clip-symbol' + text;
    } else if ( notif.tipo === 'paciente-nuevo' ){
        return 'flaticon-users-1' + text;
    } else if ( notif.tipo === 'seguimientos' ){
        return 'fa fa-retweet' + text;
    } else if ( notif.tipo === 'solicitud' ){
       return 'flaticon-edit-1' + text;
    }else {
        return 'flaticon2-calendar-1' + text;
    }
}

function colorNotificacion( notif ){
    if( notif.tipo === 'paciente' || notif.tipo === 'cita'){
        if( notif.estado-0 === 0 && notif.tipo === 'paciente'){
            return 'kt-font-primary';
        } else if((notif.estado-0 === 0 || notif.estado-0 === 2) && notif.tipo === 'cita'){
            return 'kt-font-success';
        } else if( notif.estado-0 === 1 ){
            return 'cita-reprogramada';
        } else if( notif.estado-0 === 2 ){
            return 'kt-font-primary';            
        } else if( notif.estado-0 === 3 ){
            return 'cita-cancelada';
        } else if ( notif.estado-0 === 4 ){
            return 'cita-completada';
        } else {
            return 'cita-inasistencia';
        }
    } else if ( notif.tipo === 'feedback' ){
        if( notif.estado-0 === 3 ){
            return 'feed-alto';
        } else if( notif.estado-0 === 2){
            return 'feed-medio';
        } else {
            return 'feed-bajo';
        }
    } else if ( notif.tipo === 'mensaje' ){
        return 'mensaje';
    } else if ( notif.tipo === 'recordatorio' ){
        return 'recordatorio';
    } else if ( notif.tipo === 'evento' ){
        return 'evento';
    } else if ( notif.tipo === 'recordatorio-doctor' ){
        return 'recordatorio-doctor';
    } else if ( notif.tipo === 'paciente-nuevo' ){
        return 'kt-font-info';
    } else {
        return 'kt-font-success';
    }
}

function filterExcludeActividad(){
    $(".notificacion-recordatorio").hide();
    if(allFilters){
        $(".kt-notification__item").show();
    } else {
        $(".citas").hide();
        $(".feedback").hide();
        $(".mensajeria").hide();
        $(".pacientes").hide();
        $(".recordatorios").hide();
    }
    recent ? $("#recent").show() : $("#recent").hide();
    
}

function readCookie(name) {
  var nombre = name + "="; 
  var ca = document.cookie.split(';');
  for(var i=0;i < ca.length;i++) {
    var c = ca[i];
    while (c.charAt(0)===' ') c = c.substring(1,c.length);
    if (c.indexOf(nombre) === 0) {
      return decodeURIComponent( c.substring(nombre.length,c.length) );
    }

  }
  return null;
}

function showFilter(){
    if(filtroActividad == 'all'){
        $(".kt-notification-v2__item").show();
        $(".notificacion-recordatorio").hide();
    }
    else{
        $(".kt-notification-v2__item").hide();
        $(".notificacion-" + filtroActividad).show();
    }
}

function initEventSolicitud(){
    $('.notificacion-solicitud').click( e => {
        const id = e.target.dataset.id;
        if( typeof id != 'undefined'){
            viewSolicitud( id );
        }
    });
}

function viewSolicitud( id ){
        $.get( _baseURL + '/solicitud-cita/view', 
    {
        id: id
    }, ( json ) => {
        if(json.Correcto){
            setInfoModal( json.model );
            $('#solicitud-cita-web-info').modal('toggle');
        } else {
            $.bsAlert(json.mensaje);
        }
    },'json');
}

function setInfoModal( model ){
    $('#id_solicitud').val( model.id );
    $('#titulo-solicitud').html('Solicitud de ' + model.paciente.nombreCorto );
    $('#paciente').html( model.paciente.nombreCompleto );
    $('#fecha').html( model.fecha );
    $('#tipo-cita-label').html( 'Tipo de cita: ' + model.tipoCita );
    $('#procedimiento').html( 'Procedimiento: ' + model.procedimientos );
    $('#cometario').html( 'Comentario: ' + model.comentario );
}

function aceptar( id ){
    $.get( _baseURL + '/solicitud-cita/aceptar',
    {
        id: id
    },
    ( json )=> {
        if( json.Correcto ){
            $('#solicitud-cita-web-info').modal('toggle');
            $.bsAlert( json.Mensaje );
            funcionFinalConfirmarCita();
        } else {
            $.bsAlert( json.Mensaje ); 
        }
    },
    'json');
}
         

