/* global _baseURL */
var index = 0;
var items = [];
$(document).ready(function(){
    $("#total-notif").hide();
    if( tipoUsuario == 1 || tipoUsuario == 2 ){
        getNotificaciones();
        eventoModalHide();
        verNotificacion();
    };
});

function eventoModalHide(){
    $('#view-notificacion').on('hidden.bs.modal', function (e) {
        getNotificaciones();
    }); 
}

function verNotificacion(){   
    $("#ver-notificaciones").click(function(){
        $.post(_baseURL + '/notificacion/marcar-visto', {'open':true},function(json){
            if(json.Correcto){
                $("#total-notif").hide();
            }
        },"json");
    });
}

function getNotificaciones(){
    $("#notificaciones-db").children().remove();
    var notificaciones = "";
    $.post(_baseURL + "/notificacion/notificaciones", {'n':'all'}, function(json){
        if(json.Correcto){
            //console.log(json);
            var totalNotif = json.Notificaciones.length;
            if(totalNotif == 0){
                notificaciones = '<a href="#" class="kt-notification__item">\n\
                                    <div class="kt-notification__item-icon">\n\
                                        <i class="flaticon-symbol kt-font-info"></i>\n\
                                    </div>\n\
                                    <div class="kt-notification__item-details">\n\
                                        <div class="kt-notification__item-title">\n\
                                            No hay notificaciones que mostrar \n\
                                        </div>\n\
                                        <div class="kt-notification__item-time">\n\
                                        </div>\n\
                                    </div>\n\
                                </a>';
                $("#total-notif").hide();
            } else {
                $("#total-notif").show();
                json.mostrarTotal ? $("#total-notif").html(json.pendientes) : $("#total-notif").hide();
                $.each(json.Notificaciones,function(i,notificacion){
                    var icon = notificacion.tipo == 0 ? 'flaticon-add' 
                        : (notificacion.tipo == 1 ? 'fa fa-undo-alt' 
                            : (notificacion.tipo == 2 ? 'fa fa-tools' : 'flaticon-information' )  );
                    var color = notificacion.tipo == 0 ? 'kt-font-brand' 
                            : (notificacion.tipo == 1 ? 'kt-font-warning' 
                                : (notificacion.tipo == 2 ? 'kt-font-info' : 'kt-font-success' )  );
                    var leido = notificacion.leido == 1 ? 'notificacion-leido' : 'notificacion-no-leido';             
                    var notif = '<a hfer="#" class="kt-notification__item '+leido+' notificacion-db" id="'+notificacion.id+'" data-leido="'+notificacion.leido+'">\n\
                                    <div class="kt-notification__item-icon">\n\
                                        <i class="'+icon+' '+color+'"></i>\n\
                                    </div>\n\
                                    <div class="kt-notification__item-details">\n\
                                        <div class="kt-notification__item-title">\n\
                                            '+ notificacion.titulo +'\n\
                                        </div>\n\
                                    </div>\n\
                                 </a>';
                    notificaciones += notif;
                });
            }
            json.totalNotificaciones == 1 ? $(".nav-notifications").hide() : $(".nav-notifications").show(); 
            //console.log(json.totalNotificaciones);
            $("#notificaciones-db").append(notificaciones);
            var elements = $(".notificacion-db");
            if(items.length > 0){
                items = [];
            }
            for(var i = 0; i < elements.length; i++){
                items.push(elements[i].id);
                if(elements[i].dataset.leido == 0){
                }    
            }
            $(".notificacion-db").click(function(e){
                var id  = e.currentTarget.id;
                index = items.indexOf(id);
                detalleNotificacion(id);
            });
            
        }
    },"json"); 
}

$(".nav-notifications").click(function(e){
    var step = e.target.id;
    if(step == 'next'){
        index = index + 1;
        if(index >= items.length){
            index = 0;
        }
        detalleNotificacion(items[index], false);
    } else {
        index = index -1;
        if(index < 0){
            index = items.length-1;
        }
        detalleNotificacion(items[index], false);
    }
});

function detalleNotificacion(id, toggle=true){
    $('.dropdown-menu').removeClass('show');
    $.ajax({
        url: _baseURL + '/notificacion/detalle-notificacion',
        method: 'POST',
        data: {'id':id},
        dataType: 'json',
        success: function(json){
            if(json.Correcto){
                $("#title-notificacion").html(json.titulo);
                $("#body-notificacion").html(json.descripcion);
                json.accion == 'No definido' ? $("#accion").hide() : $("#accion").show();
                json.accion == 'No definido' ? '' : $("#accion").attr('href',json.accion);
                $("#accion").html(json.verbo);
                toggle ? $("#view-notificacion").modal("toggle") : '';
                var back = $(".modal-backdrop");
                back.removeClass("modal-backdrop");
            }
        }
    });
}