
/* global _baseURL */

$(document).ready(function() {
    
    $("#btn-enviar-mensaje").click(function(){
        var mensaje = $("#EmailMessage").val();
        var recipes = $('#recipientes').val();
        var isEmail = $('#is-email').prop("checked");
        var isSms = $('#is-sms').prop("checked");
        if(recipes != "" && mensaje != "" && (isEmail || isSms)){
            $.blockUI({ message: '<h3>Enviando...</h3>'});
            $.post(_baseURL + '/mensajeria/send',{msg: mensaje,recp:recipes,email:isEmail,sms:isSms},function(json){
                $.unblockUI();
                if(json.Correcto){
                    $.bsAlert("Su mensaje ha sido enviado");
                    $("#EmailMessage").val('');
                    $('#recipientes').val('');
                    $("#recipientes").trigger("change");
                }
                else{
                    $.bsAlert("Ha ocurrido un error, por favor vuelva a intentarlo.");
                }
            },'json');
        }
        else{
            $.bsAlert("Por favor seleccione un paciente y coloque un mensaje.");
        }
    });
    
    $(".mensajeria-tools button").click(function(){
        var variable = $(this).val();
        var mensaje = $("#EmailMessage").val();
        $("#EmailMessage").val(mensaje+variable);
        $("#EmailMessage").focus();
    });
    
    $('#recipientes').select2({
        closeOnSelect: false,
        ajax: {
            url: _baseURL + "/utils/pacientes-select2",
            dataType: 'json'
        }
    });
    $('#recipientes').on('select2:select',function(e){
        $(".select2-search__field").val('');
    });
    
    $("#opt-pacientes input").change(mostrarCamposFiltro);
    
    $("#btn-ok").click(function(){
        var trs = $("#table-pacientes tbody tr");
        if(trs.length < 1){
            $.bsAlert("No se encontraron pacientes");
        }
        else{
            $("#recipientes").children().remove();
            $.each(trs,function(i,tr){
                var id = $(tr).find('.idpaciente').val();
                var nombre = $(tr).find('.nombre').val();
                var opt = new Option(nombre,id,false,true);
                $("#recipientes").append(opt);
            });
            $("#recipientes").trigger("change");
        }
        $("#modalPacientes").modal('hide');
        $("#table-pacientes tbody").children().remove();
    });
    $("#btn-obtener").click(function(){
        var opSelected = $("#opt-pacientes input:checked").val();
        var data = {opt: opSelected};
        if(opSelected == 'custom'){
            data.start = $("#fecha-inicio").val();
            data.end = $("#fecha-fin").val();
        }
        $.post(_baseURL + "/utils/pacientes-por-fecha",data,function(json){
            $("#table-pacientes tbody").children().remove();
            if(json.Correcto){
                var trs ="";
                $.each(json.Pacientes,function(i,p){
                    var nombreCompleto = p.nombre + ' ' + p.apellido;
                    trs += "<tr><td>\
                                <input type='hidden' class='idpaciente' value='" + p.id + "' />\
                                <input type='hidden' class='nombre' value='" + nombreCompleto + "' />\
                                " + nombreCompleto + "</td>\
                                <td>" + p.email + "</td></tr>";
                });
                $("#table-pacientes tbody").append(trs);
            }
        },'json');
    });
    
    $("#btn-personalizar").click(function(){
        $("#fecha-inicio").datepicker();
        $("#fecha-fin").datepicker();
        mostrarCamposFiltro();
        $("#modalPacientes").modal('show');
    });
});

function mostrarCamposFiltro(){
    $("#table-pacientes tbody").children().remove();
    $(".campos-filtro-pacientes").hide();
    var opSelected = $("#opt-pacientes input:checked").val();
    var mostrar=opSelected == 'custom' ? 'fecha-abierta-group' : (opSelected == 'today' ? 'fecha-hoy-group' : 'fecha-semana-group');
    $("#" + mostrar).show();
}