/* global _baseURL */

const selecInputLen = 2;
$(document).ready(()=>{
    listar();
    $('#id_paciente').select2({
        placeholder: ' Paciente',
        minimumInputLength: selecInputLen,
        language: {
            inputTooShort: ()=> 'Debe ingresar ' +selecInputLen+ ' caracteres o más.',
            searching: ()=> 'Buscando...'
        },
        ajax: {
            url: _baseURL + "/utils/pacientes-select2",
            method: 'get',
            dataType: 'json',
            data: function (params) {
                return { term: params.term };
            },
            processResults: function (data) {
                return { results: data.results };
            }
        }
    });
    
    $('#guradar-lista').click(()=>{
       var id_paciente = $('#id_paciente').val(); 
       var comentario = $('#comentario').val();
       if((id_paciente-0 === 0 || id_paciente === '')){
           $.bsAlert('Debe seleccionar un paciente');
           return 0;
       }
       $.post(_baseURL + '/lista-espera/create', 
        {
            id_paciente: id_paciente,
           comentario: comentario
        },(json)=>{
            if(json.Correcto){
               $('#agregar-form').modal('toggle'); 
               listar();
            }
        },'json')
    });
    
    $('#agregar-form').on('show.bs.modal', () => $('#ls-espera-modal').hide());
    $('#agregar-form').on('hide.bs.modal', () => $('#ls-espera-modal').show());
    
});

function listar(){
    $.get(_baseURL + '/lista-espera/index', (json)=>{
        if(json.Correcto){
            var elementos = '';
            $('#items-lista').children().remove();
            if( json.Lista.length > 0 ){
                $('#label-ls-es').html( json.Lista.length );
                $.each(json.Lista,(i,el)=>{
                    elementos += '<div class="d-flex align-items-center bg-light rounded p-5 mb-9">\n\
                                <div class="d-flex flex-column flex-grow-1 mr-2">\n\
                                    <a href="'+el.url_paciente+'" class="font-weight-bold text-dark-75 text-hover-primary font-size-lg mb-1">\n\
                                        '+el.paciente.nombre+' '+el.paciente.apellido+(el.paciente.codigo === null ? ' (No definido)' : ' ('+el.paciente.codigo+')' )+'\n\
                                    </a>\n\
                                    <span class="text-muted font-weight-bold">'+(el.comentario === '' ? '(No definido)' : el.comentario) +'</span>\n\
                                </div>\n\
                                <a href="'+el.url_agregar_cita+'" class="font-weight-bolder btn btn-brand btn-sm py-1 font-size-lg">Agregar Cita</a>\n\
                                <a href="#" data-id="'+el.id+'" class="font-weight-bolder btn btn-danger btn-sm py-1 font-size-lg eliminar-el ml-2"> X </a>\n\
                            </div>\n\
                            <hr>';
                });
                $('#items-lista').append( elementos );
                eliminarElemento();
            } else {
                $('#items-lista').append( mensajeListaVacia() );
            }
        }
    },'json');
}



function eliminarElemento(){
    $('.eliminar-el').click((e)=>{
        var { dataset } = e.target;
        var bool = confirm('¿Está seguro de quitar el elemento de la lista?');
        $.post(_baseURL + '/lista-espera/delete', 
        {
            id:dataset.id
        },
        (json)=>{
            if(json.Correcto){
                listar();
            } else {
                $.bsAlert(json.msg);
            }
        },'json'); 
    });
}

function mensajeListaVacia(){
    return '<div class="d-flex align-items-center bg-light rounded p-5 mb-9">\n\
                <div class="d-flex flex-column flex-grow-1 mr-2">\n\
                    <a href="javascrip:void(0);" class="font-weight-bold text-dark-75 text-hover-primary font-size-lg mb-1">\n\
                        Lista de espera vacía\n\
                    </a>\n\
                    <span class="text-muted font-weight-bold">Aún no hay pacientes en espera</span>\n\
                </div>\n\
            </div>\n\
            <hr>';
}

