/* global _baseURL */

var isNewRecord = false;
const modal = document.getElementById('seguimientosModal');
const span = document.getElementById('closeModalSeg');
$(document).ready(function(){
    span.onclick = function() {
      modal.style.display = "none";
      closeModal();
    }
    window.onclick = function(event) {
      if (event.target == modal) {
        modal.style.display = "none";
        closeModal();
      }
    }

});

function addPickers(){
    $('#seguimiento-fecha_seguimiento').datepicker();
    $('#seguimiento-hora_seguimiento').timepicker();
}

function closeModal(){
    if(isNewRecord){
        guardarSeguimiento();
    } 
    removeChildrensModal();
}


function saveBtnClick(){
    $('#seg-form').submit(function(e){
        e.preventDefault();
        if(isNewRecord){
           guardarSeguimiento();
       } 
    });
}

function guardarSeguimiento(){
    var paciente = $('#seguimiento-id_paciente').val();
    var fecha = $('#seguimiento-fecha_seguimiento').val();
    var hora = $('#seguimiento-hora_seguimiento').val();
    var motivo = $('#seguimiento-motivo').val();
    var interaccion = $('#seguimiento-interaccion').val();
    if(paciente == '' || fecha == '' || hora == '' || motivo == '' || interaccion == '')return;
    $.post( _baseURL + "/seguimiento/create", {
            'paciente_id':paciente,
            'fecha_seguimiento':fecha,
            'hora_seguimiento':hora,
            'motivo':motivo,
            'interaccion':interaccion
        }, function(json){
        if(json.Correcto){
            isNewRecord = false;
            modal.style.display = "none";
            removeChildrensModal();
            funcionFinalConfirmarCita();
        }
    },'json');
}

function removeChildrensModal(){
    $('#segTitulo').html('');
    $('#segCuerpo').children().remove();
    $('#segFooter').children().remove();
    $('.seg').html('');
}