/* global _baseURL, porcentajePasarela, montoPasarela, boolCobroPasarela, TIPO_COBRO, id_cita */

const IVA_INCLUIDO = 0;
const AGREGAR_IVA = 1;
const SIN_IVA = 2;

const ASUMIR_CARGO_PASARELA = 0;
const CARGO_PASARELA_PACIENTE = 1;

const PAGADITO = 0;
const LINK_EXTERNO = 1;

const mesageTime = 1500;

//const ocultarCampoUrl = () =>{
//    $('#url-fields').hide();
//}

const eventosCalcularTotal = () => {
    changeCosto();
    clickIvaOpt();
    clickCargoPasarelaOpt();
}

const copiarBtn = () => {
    $('#copiar-btn').click( e =>{
        var $temp = $('<input>');
        $('#cobrar-cita-modal-cont').hide();
        $(".modal-backdrop").hide();
        $.blockUI({ message: '<span><i class=" kt-font-success flaticon2-check-mark"></i> Url Copiada</span>'});       
        $('body').append($temp);
        $temp.val($('#url-cobro').val()).select();
        document.execCommand('copy');
        $temp.remove();
        setTimeout(()=>{
            $.unblockUI();
            $(".modal-backdrop").show();
            $('#cobrar-cita-modal-cont').show();
        },mesageTime);
    }); 
}

const copiarBtnDetalle = () => {
    $('#copiar-btn-detalle').click( e =>{
        var $temp = $('<input>');
        $('#detalle-cobro-modal').hide();
        $(".modal-backdrop").hide();
        $.blockUI({ message: '<span><i class=" kt-font-success flaticon2-check-mark"></i> Url Copiada</span>'});
        $('body').append($temp);
        $temp.val($('#url-cobro-detalle').val()).select();
        document.execCommand('copy');
        $temp.remove();
        setTimeout(()=>{
            $.unblockUI();
            $(".modal-backdrop").show();
            $('#detalle-cobro-modal').show();
        },mesageTime);
    }); 
}

const changeCosto = () =>{ 
    $('#costo').keyup((e) =>{
        calcularTotal();
    });
}
const clickIvaOpt = () =>{
    $("input[name='iva']").click((e) =>{
        calcularTotal();
    });
}
const clickCargoPasarelaOpt = () =>{
    $("input[name='cargo-pasarela']").click((e) =>{
        calcularTotal();
    });
}

const calcularTotal = () => {
    var costo = $('#costo').val() == '' ? 0 : parseFloat($('#costo').val()).toFixed(2);
    var metodo_iva = $("input[name='iva']:checked").val() -0;
    var opt_pasarela = $("input[name='cargo-pasarela']:checked").val() -0;
    var res = calcular_total_cobro(costo-0, metodo_iva, opt_pasarela);
    $('#total-iva').html(isNaN(res.iva) ? 0 : res.iva);
    $('#cargo-plataforma').html(isNaN(res.cargo_pasarela) ? 0 : res.cargo_pasarela);
    $('#monto-total').html(isNaN(res.total_cobrado) ? 0 : res.total_cobrado);
}

const efectuarCobroBtn = () => {
    $('#efectuar-cobro').click((e) => {
        let {dataset} = e.target;
        let id_cita = dataset.id;
        let costo = parseFloat($('#costo').val()).toFixed(2);
        let metodo_iva = $('input[name="iva"]:checked').val() -0;
        let sms = $('#sms')[0].checked ? 1 : 0;
        let correo = $('#correo')[0].checked ? 1 : 0;
        let cargo_pasarela = ((TIPO_COBRO === PAGADITO )||(TIPO_COBRO === LINK_EXTERNO && boolCobroPasarela)) 
        ? $('input[name="cargo-pasarela"]:checked').val() -0
        : null;
        $.post(_baseURL + '/cobro-cita/cobrar-cita', 
            {
                'id_cita':id_cita,
                'costo': costo,
                'cargo_pasarela': cargo_pasarela,
                'metodo_iva': metodo_iva,
                'enviar_sms': sms,
                'enviar_correo': correo
            }, (json)=>{
            if(json.Correcto){
                $('#url-cobro').val(json.URL_COBRO);
                $('#costo').attr('readonly', true);
                $('.to-hide').hide();
                $('#url-fields').show();    
                $('#efectuar-cobro').hide();
            } else {
                $.bsAlert(json.mensaje);
            }
        }, 'json');
        
    });
}

const cerrar_modal_cobro = () =>{
    $('#cobrar-cita-modal').on('hidden.bs.modal', () => {
        viewCita(id_cita);
    });
};

const cambioEstadoCobro = () => {
    $('#estados-link-externo').change( e => {
        const { value, dataset:{ id } } = e.target;
        $.post(_baseURL + '/cobro-cita/cambiar-estado',
        {
            id: id,
            id_cita:id_cita,
            estado: value
        }, 
        ( json ) => {
            if( json.Correcto ){
                if( json.ocultarUrl ){
                    $('#url-cobro').hide();
                    $('#estados-cobro-link').hide();
                    $('#fecha-cobro').html( json.fecha );
                    $('#fecha-cobro-group').show();
                }
            }
        },'json');
    });
};


const iva_incluido = ( costo ) =>  ( costo - ( costo / 1.13 ) ).toFixed(2);

const iva_incluido_2 = ( costo, iva=1.13 ) => ( ( costo / iva ) ).toFixed(2);

const agregar_iva = ( costo, iva=0.13 ) => ( costo * iva ).toFixed(2);

const calcular_cargo_pasarela = ( costo, porcentaje=0.05, monto=0.25, iva=1.13 ) => ( ( ( costo * porcentaje ) + monto )* iva ).toFixed(2);

const monto_cobrar = ( costo, porcentaje=0.05, monto=0.25, iva=1.13 ) => ((costo+(monto*iva)) / (1-(porcentaje*iva)) ).toFixed(2);


const monto_cobrar_2 = ( costo, porcentaje=0.05, monto=0.25, iva=1.13 ) =>{
    let pow = Math.pow( iva, 2 );
    let num = ( costo * iva ) + ( monto * pow );
    let den = 1-( porcentaje * pow );
    return (num / den).toFixed(2);
}

const monto_cobrar_3 = ( costo, iva=1.13 ) => ( costo * iva ).toFixed(2);


/**
 * Realizar operaciones segun los parametros seleccionados
 * boolCobroPasarela, porcentajePasarela, montoPasarela declaradas en cita/view.php
 * Caso 1:
        - IVA incluido
        - Asumir el cobro de la Plataforma
    Caso 2:
        - IVA incluido
        - Cobrar al Paciente
    Caso 3:
        - Agregar IVA
        - Asumir el cobro de la Plataforma
    Caso 4:
        - Agregar IVA
        - Cobrar al Paciente
    Caso 5:
        - Sin IVA
        - Asumir el cobro de la Plataforma
    Caso 6:
        - Sin IVA
        - Cobrar al Paciente
 * @param  {float} costo
 * @param  {number} metodo_iva
 * @param  {number} opt_pasarela
 * @return  {objet}
 */
const calcular_total_cobro = (costo, metodo_iva, opt_pasarela) => {
    let monto = 0;
    let iva = 0;
    let cargo_pasarela = 0;
    let total = 0;
    if( ( TIPO_COBRO === PAGADITO ) || (TIPO_COBRO === LINK_EXTERNO && boolCobroPasarela) ){
        if ( metodo_iva === IVA_INCLUIDO && opt_pasarela === ASUMIR_CARGO_PASARELA ){
            iva = iva_incluido(costo)-0;
            cargo_pasarela = ( boolCobroPasarela ) 
            ? calcular_cargo_pasarela(costo, porcentajePasarela, montoPasarela)-0 
            : calcular_cargo_pasarela(costo)-0;
            total = costo;
            return formato_respuesta(iva, cargo_pasarela, total);
        } else if ( metodo_iva === IVA_INCLUIDO && opt_pasarela === CARGO_PASARELA_PACIENTE ){//revisar
            iva = iva_incluido(costo)-0;
            var costo2 = costo -iva;
            monto = monto_cobrar_2(costo2)-0; 
            cargo_pasarela = ( boolCobroPasarela ) 
            ? calcular_cargo_pasarela(monto, porcentajePasarela, montoPasarela)-0
            : calcular_cargo_pasarela(costo)-0;
            total = monto; 
            return formato_respuesta(iva, cargo_pasarela, total);
        } else if ( metodo_iva === AGREGAR_IVA && opt_pasarela === ASUMIR_CARGO_PASARELA ){
            monto = monto_cobrar_3(costo)-0;
            iva = agregar_iva(costo)-0;
            cargo_pasarela = ( boolCobroPasarela ) 
            ? calcular_cargo_pasarela(monto, porcentajePasarela, montoPasarela)-0
            : calcular_cargo_pasarela(costo)-0;
            total = monto;
            return formato_respuesta(iva, cargo_pasarela, total);
        } else if ( metodo_iva === AGREGAR_IVA && opt_pasarela === CARGO_PASARELA_PACIENTE ){
            monto = monto_cobrar_2(costo)-0;
            iva = iva_incluido(monto)-0;//<- incluido || agregar iva ?
            cargo_pasarela = ( boolCobroPasarela ) 
            ? calcular_cargo_pasarela(monto, porcentajePasarela, montoPasarela)-0
            : calcular_cargo_pasarela(costo)-0;
            total = monto;
            return formato_respuesta(iva, cargo_pasarela, total);
        } else if ( metodo_iva === SIN_IVA && opt_pasarela === ASUMIR_CARGO_PASARELA ){
            iva = 0;
            cargo_pasarela = ( boolCobroPasarela ) 
            ? calcular_cargo_pasarela(monto, porcentajePasarela, montoPasarela)-0
            : calcular_cargo_pasarela(costo)-0;
            total = costo;
            return formato_respuesta(iva, cargo_pasarela, total);
        } else if ( metodo_iva === SIN_IVA && opt_pasarela === CARGO_PASARELA_PACIENTE ){
            monto = ( boolCobroPasarela ) 
            ? monto_cobrar(costo,porcentajePasarela, montoPasarela)-0 
            : monto_cobrar(costo)-0;
            iva = 0;
            cargo_pasarela = ( boolCobroPasarela ) 
            ? calcular_cargo_pasarela(monto, porcentajePasarela, montoPasarela)-0
            : calcular_cargo_pasarela(costo)-0;
            total = monto;
            return formato_respuesta(iva, cargo_pasarela, total);
        }
    }
    
    if( TIPO_COBRO === LINK_EXTERNO && !boolCobroPasarela ){
        if( metodo_iva === IVA_INCLUIDO ){
            iva = iva_incluido(costo)-0;
            total = costo;
            return formato_respuesta(iva, cargo_pasarela, total);
        } else if( metodo_iva === AGREGAR_IVA ){
            monto = monto_cobrar_3(costo)-0;
            iva = agregar_iva(costo)-0;
            total = monto;
            return formato_respuesta(iva, cargo_pasarela, total);
        } else if( metodo_iva === SIN_IVA ){
            total = costo;
            return formato_respuesta(iva, cargo_pasarela, total);
        }
    }
    
    return formato_respuesta(iva, cargo_pasarela, total);
}

const formato_respuesta = (iva, cargo_pasarela, total) => {
    return {
        iva: iva.toFixed(2) || 0.00,
        cargo_pasarela: cargo_pasarela.toFixed(2) || 0.00,
        total_cobrado: total.toFixed(2) || 0.00
    };
}


