/* global _baseURL, tipoUsuario */

$(document).ready( () => {
    document.addEventListener('keydown', e => {
        const NODE_NAME = e.target.nodeName;
        const WINDOW_URL = window.location.href; 
        if( NODE_NAME === 'INPUT' || NODE_NAME === 'TEXTAREA' || NODE_NAME === 'DIV' ){
            return false;
        }
        if(tipoUsuario-0 === 0){
            return false;
        }
        if ( e.shiftKey && String.fromCharCode( e.keyCode ) === 'C' && !WINDOW_URL.includes('/cita/create') ){
            window.location.href = _baseURL + '/cita/create';
        }
        if ( e.shiftKey && String.fromCharCode( e.keyCode ) === 'P' && !WINDOW_URL.includes('/paciente/create') ){
            window.location.href = _baseURL + '/paciente/create';
        }
        if ( e.shiftKey && String.fromCharCode( e.keyCode ) === 'A' && !WINDOW_URL.includes('/calendario/index') ){
            window.location.href = _baseURL + '/calendario/index';
        }
        if ( e.shiftKey && String.fromCharCode( e.keyCode ) === 'H' && !WINDOW_URL.includes('/site/index') ){
            window.location.href = _baseURL + '/site/index';
        }
    });
});

function _seleccionarClinica(idC){
    var idSeleccionado = $("#usuario-clinica-seleccionada").data("idseleccionado");
    if(idSeleccionado != idC){
        var url = _baseURL + "/site/cambiar-clinica";
        $.post(url,{idc: idC},function(json){
            if(json.Correcto){
                $("#usuario-clinica-seleccionada").data("idseleccionado",idC);
                $("#usuario-clinica-seleccionada #kt-subheader__btn-daterange-title").text(json.Doctor);
                $("#usuario-clinica-seleccionada #kt_dashboard_daterangepicker_date").text(json.Clinica);
                window.location.reload();
            }
        },"json");
    }
}
