<?php

use app\customs\SesionUtils;

/* @var $this \yii\web\View */
/* @var $clinica app\models\Clinica */
/* @var $clinicas app\models\Clinica[] */
/* @var $usuario app\models\Usuario */

$clinica = SesionUtils::ClinicaSeleccionada();
$clinicasGrupo = SesionUtils::ClinicasAgrupadasJerarquia();

$this->registerJsFile(
    '@web/js/jerarquias.js',
    ['depends' => [
            \yii\web\JqueryAsset::class,
            \app\themes\metronic\assets\Select2Assets::class
        ]
    ]
);

$this->registerCssFile('@web/css/jerarquias.css')
?>

<div class="kt-subheader__toolbar">
    <div class="kt-subheader__wrapper">
        <div class="input-group input-group-lg input-group-solid select-clinicas-jerarquia-container">
            <select class="form-control" id="select-clinica-jerarquia">
                <?php foreach($clinicasGrupo as $clinicaGrupo){ ?>
                <optgroup label="<?= $clinicaGrupo['Nombre']?>">
                    <?php 
                    $clinicas = $clinicaGrupo['Clinicas'];
                    foreach($clinicas as $cli){
                    ?>
                        <option value="<?= $cli->id ?>" <?= $clinica->id == $cli->id ? "selected='selected'" : "" ?> ><?= $cli->nombre ?></option>
                    <?php } ?>
                    </optgroup>
                <?php } ?> 
            </select>
        </div>
    </div>
</div>