
<?php
use yii\helpers\Html;
use yii\widgets\Breadcrumbs;
use app\assets\OliviaAsset;
use yii\helpers\Url;
use app\themes\metronic\assets\MetronicAsset;
use app\assets\AppAsset;
/* @var $this \yii\web\View */
/*
if (Yii::$app->controller->action->id === 'login') {
    echo $this->render(
        'main-login',
        ['content' => $content]
    );
} else {
 * 
 */
AppAsset::register($this);
MetronicAsset::register($this);
OliviaAsset::register($this);

?>
<?php $this->beginPage(); ?>

<html lang="es">
    <head>
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <title><?= Html::encode($this->title) ?></title>
        <?php $this->registerCsrfMetaTags() ?>
        
        <!--Import materialize.css-->
        <script src="https://ajax.googleapis.com/ajax/libs/webfont/1.6.16/webfont.js"></script>
        <script>
            WebFont.load({
                google: {
                    "families": ["Poppins:300,400,500,600,700", "Roboto:300,400,500,600,700"]
                },
                active: function() {
                    sessionStorage.fonts = true;
                }
            });
        </script>

        <!--begin::Page Vendors Styles(used by this page) -->
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/custom/fullcalendar/fullcalendar.bundle.css" rel="stylesheet" type="text/css" />
        <!--end::Page Vendors Styles -->

        <!--begin:: Global Mandatory Vendors -->
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" type="text/css" />
        <!--end:: Global Mandatory Vendors -->

        <!--begin:: Global Optional Vendors -->
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/tether/dist/css/tether.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/bootstrap-datepicker/dist/css/bootstrap-datepicker3.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/bootstrap-datetime-picker/css/bootstrap-datetimepicker.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/bootstrap-timepicker/css/bootstrap-timepicker.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/bootstrap-daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/bootstrap-touchspin/dist/jquery.bootstrap-touchspin.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/bootstrap-select/dist/css/bootstrap-select.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/bootstrap-switch/dist/css/bootstrap3/bootstrap-switch.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/select2/dist/css/select2.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/ion-rangeslider/css/ion.rangeSlider.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/nouislider/distribute/nouislider.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/owl.carousel/dist/assets/owl.carousel.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/owl.carousel/dist/assets/owl.theme.default.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/dropzone/dist/dropzone.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/summernote/dist/summernote.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/bootstrap-markdown/css/bootstrap-markdown.min.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/animate.css/animate.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/toastr/build/toastr.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/morris.js/morris.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/sweetalert2/dist/sweetalert2.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/socicon/css/socicon.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/custom/vendors/line-awesome/css/line-awesome.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/custom/vendors/flaticon/flaticon.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/custom/vendors/flaticon2/flaticon.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/@fortawesome/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/jquery-ui/jquery-ui.min.css" rel="stylesheet" type="text/css" />
	<!--end:: Global Optional Vendors -->
        
        <!--begin::Global Theme Styles(used by all pages) -->
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/css/demo1/style.bundle.css" rel="stylesheet" type="text/css" />
        <!--end::Global Theme Styles -->

        <!--begin::Layout Skins(used by all pages) -->
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/css/demo1/skins/header/base/light.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/css/demo1/skins/header/menu/light.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/css/demo1/skins/brand/dark.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/css/demo1/skins/aside/dark.css" rel="stylesheet" type="text/css" />
        <!--end::Layout Skins -->
        
        <link rel="shortcut icon" href="<?php echo $this->theme->baseUrl; ?>/assets/media/logos/favicon.ico" />
        
        <meta name="author" content="Misael Nieves - jmnievesc@gmail.com">
        <meta name="robots" content="all">
        <?php $this->head() ?>
    </head>
    <body class="kt-quick-panel--right kt-demo-panel--right kt-offcanvas-panel--right kt-header--fixed kt-header-mobile--fixed kt-subheader--fixed kt-subheader--enabled kt-subheader--solid kt-aside--enabled kt-aside--fixed kt-page--loading">
    <?php $this->beginBody() ?>
        <!-- begin:: Header Mobile -->
        <div id="kt_header_mobile" class="kt-header-mobile  kt-header-mobile--fixed ">
            <div class="kt-header-mobile__logo">
                <?= Html::a(Html::encode(\Yii::$app->name),["site/index"]) ?>
            </div>
            <div class="kt-header-mobile__toolbar">
                <button class="kt-header-mobile__toggler kt-header-mobile__toggler--left" id="kt_aside_mobile_toggler"><span></span></button>
                
            </div>
        </div>
        <!-- end:: Header Mobile -->
	
        
        <!-- begin:: Page -->
        <div class="kt-grid kt-grid--hor kt-grid--root">
            <div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--ver kt-page">

                <!-- begin:: Aside -->
                <?= $this->render('side_menu.php')?>
                <!-- end:: Aside -->
                
                <div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor kt-wrapper" id="kt_wrapper">

                    <!-- begin:: Header -->
                    <div id="kt_header" class="kt-header kt-grid__item  kt-header--fixed ">

                        <!-- begin:: Header Menu -->
                        <button class="kt-header-menu-wrapper-close" id="kt_header_menu_mobile_close_btn"><i class="la la-close"></i></button>
                        <div class="kt-header-menu-wrapper" id="kt_header_menu_wrapper">
                            <div id="kt_header_menu" class="kt-header-menu kt-header-menu-mobile  kt-header-menu--layout-default ">
                                    <!-- SOLO OCUPA ESPACIO A LA IZQUIERDA -->
                            </div>
                        </div>
                        <!-- end:: Header Menu -->
                        
                        <!-- begin:: Header Topbar -->
                        <?= $this->render('user_menu.php')?>
                        <!-- end:: Header Topbar -->
                        
                    </div>

                    <!-- end:: Header -->
                    <div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor">

                        <!-- begin:: Subheader -->
                        <div class="kt-subheader   kt-grid__item" id="kt_subheader">
                            
                            
                            <div class="kt-subheader__main">
                                
                                <h3 class="kt-subheader__title">
                                    <?= Html::encode($this->title) ?>
                                </h3>
                                
                                <?= Breadcrumbs::widget([
                                    'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
                                    /*'homeLink' => [
                                        'label' => '<i class="flaticon2-shelter"></i>',
                                        'class' => 'kt-subheader__breadcrumbs-home',
                                        'url' => '#',
                                        'encode' => false
                                    ],*/
                                    'tag' => 'div',
                                    'options' => ['class' => 'kt-subheader__breadcrumbs'],
                                    'itemTemplate' => "<span class=\"kt-subheader__breadcrumbs-separator\"></span>{link}\n",
                                    'activeItemTemplate' => "<span class=\"kt-subheader__breadcrumbs-separator\"></span><a href=\"\" class=\"kt-subheader__breadcrumbs-link\">{link}</a>\n"
                                ]) ?>

                                <!--
                                <span class="kt-subheader__separator kt-hidden"></span>
                                
                                <div class="kt-subheader__breadcrumbs">
                                    <a href="#" class="kt-subheader__breadcrumbs-home"><i class="flaticon2-shelter"></i></a>
                                    <span class="kt-subheader__breadcrumbs-separator"></span>
                                    <a href="" class="kt-subheader__breadcrumbs-link">
                                        General </a>
                                    <span class="kt-subheader__breadcrumbs-separator"></span>
                                    <a href="" class="kt-subheader__breadcrumbs-link">
                                        Empty Page </a>

                                </div>
                                -->
                            </div>
                            
                        </div>

                        <!-- end:: Subheader -->

                        <!-- begin:: Content -->
                        <div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
                            <?php echo $content; ?>
                        </div>

                        <!-- end:: Content -->
                    </div>

                    <!-- begin:: Footer -->
                    <div class="kt-footer kt-grid__item kt-grid kt-grid--desktop kt-grid--ver-desktop" id="kt_footer">
                        <div class="kt-footer__copyright">
                           <img  src="<?php echo $this->theme->baseUrl; ?>/assets/media/logos/Logo_Color_sm.png">
                        </div>
                        <div class="kt-footer__menu">
                            <a href="http://keenthemes.com/metronic" target="_blank" class="kt-footer__menu-link kt-link">About</a>
                            <a href="http://keenthemes.com/metronic" target="_blank" class="kt-footer__menu-link kt-link">Team</a>
                            <a href="http://keenthemes.com/metronic" target="_blank" class="kt-footer__menu-link kt-link">Contact</a>
                        </div>
                    </div>

                    <!-- end:: Footer -->
                </div>

            </div>
        </div>
        <!-- end:: Page -->

        <!-- begin::Scrolltop -->
        <div id="kt_scrolltop" class="kt-scrolltop">
                <i class="fa fa-arrow-up"></i>
        </div>

        <!-- end::Scrolltop -->



        <!-- begin::Global Config(global config for global JS sciprts) -->
        <script>
            var KTAppOptions = {
                "colors": {
                    "state": {
                        "brand": "#5d78ff",
                        "dark": "#282a3c",
                        "light": "#ffffff",
                        "primary": "#5867dd",
                        "success": "#34bfa3",
                        "info": "#36a3f7",
                        "warning": "#ffb822",
                        "danger": "#fd3995"
                    },
                    "base": {
                        "label": ["#c5cbe3", "#a1a8c3", "#3d4465", "#3e4466"],
                        "shape": ["#f0f3ff", "#d9dffa", "#afb4d4", "#646c9a"]
                    }
                }
            };
        </script>		
        <!-- end::Global Config -->
        
    <?php $this->endBody(); ?>
    <script type="text/javascript">
        $.fn.datepicker.defaults.format = "dd/mm/yyyy";
        $.fn.datepicker.defaults.language = "es";
        var $datetimePickerOptions = {
            format : "dd/mm/yyyy hh:ii",
            language : 'es'
        };
        var _baseURL ='<?= Url::base()?>'
    </script>
    </body>
</html>
<?php $this->endPage(); ?>

