<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Unidad Medidas';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="unidad-medida-index kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
        <p class="d-none d-md-block mt-2">
            <?= Html::a('Ver Categorías', ['categoria-producto/index'], ['class' => 'btn btn-primary']) ?>
            <?= Html::a('Ver Proveedores', ['proveedor/index'], ['class' => 'btn btn-primary']) ?>
            <?= Html::a('Ver Productos', ['producto/index'], ['class' => 'btn btn-primary']) ?>
            <?= Html::a('Crear Unidad Medida', ['create'], ['class' => 'btn btn-success']) ?>
        </p>
        <div class="d-md-none mt-2">
            <div class="btn-group dropleft">
                <button type="button" class="btn btn-secondary btn-md dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="margin-left: 0 !important;">
                    Opciones
                </button>
                <div class="dropdown-menu">
                    <?= Html::a('Crear Unidad Medida', ['create'], ['class' => 'dropdown-item']) ?>
                    <div class="dropdown-divider"></div>
                    <?= Html::a('Ver Categorías', ['categoria-producto/index'], ['class' => 'dropdown-item']) ?>
                    <div class="dropdown-divider"></div>
                    <?= Html::a('Ver Proveedores', ['proveedor/index'], ['class' => 'dropdown-item']) ?>
                    <div class="dropdown-divider"></div>
                    <?= Html::a('Ver Productos', ['producto/index'], ['class' => 'dropdown-item']) ?>
                </div>
            </div>
        </div>
    </div>
    <div class="kt-portlet__body">
        <div class="table-responsive">
            <?= GridView::widget([
                'dataProvider' => $dataProvider,
                'summary' => 'Mostrando {begin} - {end} de {totalCount} ítems',
                'tableOptions' => [ 'class' => 'table table-hover', 'style'=> 'font-size: 11pt;' ],    
                'rowOptions' => function( $model ){
                    return [ 'data-id' => $model->id ];
                },    
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],

                    'nombre',
                    'abreviatura',

                    ['class' => 'app\customs\ActionColumn'],
                ],
            ]); ?>
        </div>
        <?php $this->registerJs("
                    $('tbody td:not(.disable-click)').css('cursor', 'pointer');
                    $(document).on('click','table tr td:not(.disable-click)',function(e) {      
                        var id = $(this).closest('tr').data('id');
                        if (e.target == this && id)
                            location.href = '" . Url::to(['/unidad-medida/view']) . "?id=' + id;
                    });
                ");
        ?>
    </div>
</div>
