<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel app\models\FormaPagoSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Stripe';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="forma-pago-index kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
    </div>
    <div class="kt-portlet__body">
        <p>
            <?= Html::a('Crear Forma Pago', ['create'], ['class' => 'btn btn-success']) ?>
        </p>

                <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
    
            <?= GridView::widget([
            'dataProvider' => $dataProvider,
            'summary' => 'Mostrando {begin} - {end} de {totalCount} ítems',
            'filterModel' => $searchModel,
        'columns' => [
                ['class' => 'yii\grid\SerialColumn'],

                'nombreUsuario',
                'customer_id',
                ['attribute' => 'created','value' => function ($model){return \date('d/m/Y',$model->created);}],
                'subcription_id',

                ['class' => 'app\customs\ActionColumn'],
            ],
        ]); ?>
    
    
    </div>
</div>
