<?php

/* @var $this yii\web\View */
/* @var $form yii\bootstrap\ActiveForm */
/* @var $model app\models\LoginForm */

use yii\helpers\Html;
use yii\bootstrap\ActiveForm;
use app\assets\LoginAsset;

$this->title = 'Login';
$this->params['breadcrumbs'][] = $this->title;

LoginAsset::register($this);
?>
<?php $this->beginPage(); ?>
<html lang="es">
    <head>
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <title><?= Html::encode($this->title) ?></title>
        <?php $this->registerCsrfMetaTags() ?>
        
        <!--Import materialize.css-->
        <script src="https://ajax.googleapis.com/ajax/libs/webfont/1.6.16/webfont.js"></script>
        <script>
            WebFont.load({
                google: {
                    "families": ["Poppins:300,400,500,600,700", "Roboto:300,400,500,600,700"]
                },
                active: function() {
                    sessionStorage.fonts = true;
                }
            });
        </script>

        <!--begin::Page Vendors Styles(used by this page) -->
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/custom/fullcalendar/fullcalendar.bundle.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/css/demo1/pages/general/login/login-6.css" rel="stylesheet" type="text/css" />
        <!--end::Page Vendors Styles -->

        <!--begin:: Global Mandatory Vendors -->
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" type="text/css" />
        <!--end:: Global Mandatory Vendors -->

        <!--begin::Global Theme Styles(used by all pages) -->
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/css/demo1/style.bundle.css" rel="stylesheet" type="text/css" />
        <!--end::Global Theme Styles -->

        <!--begin::Layout Skins(used by all pages) -->
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/css/demo1/skins/header/base/light.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/css/demo1/skins/header/menu/light.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/css/demo1/skins/brand/dark.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $this->theme->baseUrl; ?>/assets/css/demo1/skins/aside/dark.css" rel="stylesheet" type="text/css" />
        <!--end::Layout Skins -->
        
        <link rel="shortcut icon" href="<?php echo $this->theme->baseUrl; ?>/assets/media/logos/favicon.ico" />
        
        <meta name="author" content="Misael Nieves - jmnievesc@gmail.com">
        <meta name="robots" content="all">
        <?php $this->head() ?>
    </head>
    <body class="kt-quick-panel--right kt-demo-panel--right kt-offcanvas-panel--right kt-header--fixed kt-header-mobile--fixed kt-subheader--fixed kt-subheader--enabled kt-subheader--solid kt-aside--enabled kt-aside--fixed kt-page--loading">
    <?php $this->beginBody() ?>

        <!-- begin:: Page -->
        <div class="kt-grid kt-grid--ver kt-grid--root">
            <div class="kt-grid kt-grid--hor kt-grid--root  kt-login kt-login--v6 kt-login--signin" id="kt_login">
                <div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--desktop kt-grid--ver-desktop kt-grid--hor-tablet-and-mobile">
                    <div class="kt-grid__item  kt-grid__item--order-tablet-and-mobile-2  kt-grid kt-grid--hor kt-login__aside">
                        <div class="kt-login__wrapper">
                            <div class="kt-login__container">
                                <div class="kt-login__body">
                                    <div class="kt-login__logo">
                                        <a href="#">
                                                <img width="400" src="<?php echo $this->theme->baseUrl; ?>/assets/media/logos/Logo_Color.png">
                                        </a>
                                    </div>
                                    <div class="kt-login__signin">
                                        <div class="kt-login__head">
                                            <h3 class="kt-login__title">Iniciar Sesión</h3>
                                        </div>
                                        <div class="kt-login__form">
                                            <?php $form = ActiveForm::begin([
                                                    'id' => 'login-form',
                                                    'layout' => 'horizontal',
                                                    'fieldConfig' => [
                                                    'template' => "{label}\n<div class=\"col-lg-12\">{input}</div>\n<div class=\"col-lg-12\">{error}</div>",
                                                    'labelOptions' => ['class' => 'col-lg-1 control-label'],
                                                    ],
                                                    ]); ?>
                                            <?php
                                                if($model->hasErrors()){
                                                    echo $form->errorSummary($model,['header'=>'']);
                                                }
                                            ?>

                                                <?= $form->field($model, 'username')->textInput(['autofocus' => true, 'style'=>'padding-left: 25px;']) ?>
                                                <?= $form->field($model, 'password')->passwordInput(['style'=>'padding-left: 25px;']) ?>

                                                <div class="kt-login__actions">
                                                           <?= Html::submitButton('Entrar', ['class' => 'btn btn-brand btn-pill btn-elevate', 'name' => 'login-button']) ?>
                                                </div>


                                            <?php ActiveForm::end(); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="kt-grid__item kt-grid__item--fluid kt-grid__item--center kt-grid kt-grid--ver kt-login__content">
                        <div class="kt-login__section">
                            <div class="kt-login__block">
<!--                                <center><h3 class="kt-login__title">Toma el Control de tu Consultorio</h3></center>-->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- begin::Global Config(global config for global JS sciprts) -->
        <script>
            var KTAppOptions = {
                "colors": {
                    "state": {
                        "brand": "#5d78ff",
                        "dark": "#282a3c",
                        "light": "#ffffff",
                        "primary": "#5867dd",
                        "success": "#34bfa3",
                        "info": "#36a3f7",
                        "warning": "#ffb822",
                        "danger": "#fd3995"
                    },
                    "base": {
                        "label": ["#c5cbe3", "#a1a8c3", "#3d4465", "#3e4466"],
                        "shape": ["#f0f3ff", "#d9dffa", "#afb4d4", "#646c9a"]
                    }
                }
            };
        </script>		
        <!-- end::Global Config -->
        
        <!--begin:: Global Mandatory Vendors -->
        <script src="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/jquery/dist/jquery.js" type="text/javascript"></script>
        <script src="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/popper.js/dist/umd/popper.js" type="text/javascript"></script>
        <script src="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/bootstrap/dist/js/bootstrap.min.js" type="text/javascript"></script>
        <script src="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/js-cookie/src/js.cookie.js" type="text/javascript"></script>
        <script src="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/moment/min/moment.min.js" type="text/javascript"></script>
        <script src="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/tooltip.js/dist/umd/tooltip.min.js" type="text/javascript"></script>
        <script src="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/perfect-scrollbar/dist/perfect-scrollbar.js" type="text/javascript"></script>
        <script src="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/sticky-js/dist/sticky.min.js" type="text/javascript"></script>
        <script src="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/wnumb/wNumb.js" type="text/javascript"></script>
        <script src="<?php echo $this->theme->baseUrl; ?>/assets/vendors/general/jquery-form/dist/jquery.form.min.js" type="text/javascript"></script>

        <!--end:: Global Mandatory Vendors -->
        
        <!--begin::Global Theme Bundle(used by all pages) -->
        <script src="<?php echo $this->theme->baseUrl; ?>/assets/js/demo1/scripts.bundle.js" type="text/javascript"></script>
 <script src="<?php echo $this->theme->baseUrl; ?>/assets/js/demo1/pages/login/login-general.js" type="text/javascript"></script>
        <!--end::Global Theme Bundle -->
        
        

    <?php $this->endBody(); ?>
    </body>
</html>
<?php $this->endPage(); ?>