<?php
use app\models\Usuario;
use yii\grid\GridView;
use yii\bootstrap\Html;
use app\assets\NotificacionesAsset;
/* @var $this yii\web\View */

$this->title = 'Olivia Health';
$usuario = Yii::$app->user->identity;

NotificacionesAsset::register($this);
?>
<style>
.letter {
    font-size: 12px;
}
@media (max-width: 200px) and (max-heigth: 160px) {
    .letter {
        font-size: 8px;
    }
}

</style>
 <div class="kt-portlet__body" style="box-shadow: none;">
    <?php if($usuario->tipo == Usuario::DOCTOR || $usuario->tipo == Usuario::ASISTENTE){?>

        <div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content" style="background-color: transparent; box-shadow: none;"> 
            <div class="row">
                <div class="col-lg-9">
                    <!--begin::Portlet-->
                    <div class="kt-portlet" style="background-color: white;">
                        <div class="kt-portlet__head">
                            <div class="kt-portlet__head-label">
                                <h3 class="kt-portlet__head-title">
                                    Actividades del día
                                    <small id="fecha-panel"></small>
                                </h3>
                            </div>
                            <div class="d-none d-md-block kt-portlet__head-label">
                                <?= Html::a("<h5 class='letter'><i class='flaticon-download-1'></i>Descargar en PDF</h5>", ['reportes/agenda-pdf', 'fe'=>'0'], ['id'=>'download-pdf', 'class' => 'btn btn-dark mt-2', 'target' => '_blank']) ?>            
                                <button data-toggle="modal" data-target="#solicitudes-cita-modal" class="btn btn-primary letter mt-2" >Solicitud de Citas <span id="label-num-sl" class="badge badge-pill badge-danger">0</span></button>
                            </div>
                        </div>
                        <div class="d-md-none mt-2 ml-2">
                            <?= Html::a("<h5 class='letter'><i class='flaticon-download-1'></i>Descargar en PDF</h5>", ['reportes/agenda-pdf', 'fe'=>'0'], ['id'=>'download-pdf', 'class' => 'btn btn-dark', 'target' => '_blank']) ?>            
                            <button data-toggle="modal" data-target="#solicitudes-cita-modal" class="btn btn-primary btn-sm btn-block" >Solicitud de Citas <span id="label-num-sl" class="badge badge-pill badge-danger">0</span></button>
                        </div>
                        <div class="kt-portlet__body">
                            <div class="kt-notification-v2" id="notificaciones-clinica">
                                
                            </div>
                        </div>
                    </div>
                <!--end::Portlet-->
                </div>
                <div class="col-lg-3">
                    <!--begin::Portlet-->
                    <div class="actividad-body kt-portlet" style="background-color: transparent; box-shadow: none;">
                        <input id="fecha-actividad" class="btn btn-success mt-2 mb-2 col-md-10 col-sm-6" value="<?=date('d/m/Y')?>" style="font-size:16px;">
                        <div class="kt-portlet__head">
                            <div class="kt-portlet__head-label">
                                <h3 class="kt-portlet__head-title">
                                    Filtros de actividad
                                </h3>
                            </div>
                        </div>
                        <div class="kt-portlet__body kt-padd">
                            <div class="kt-notification kt-notification--fit filters-notificaciones">
                                <a href="#" class="kt-notification__item" data-filtro="all" id="all">
                                    <div class="kt-notification__item-icon">
                                        
                                    </div>
                                    <div class="kt-notification__item-details">
                                        <div class="kt-notification__item-title">
                                            Toda la actividad 
                                        </div>
                                        
                                    </div>
                                </a>
                                <a href="#" class="kt-notification__item citas" data-filtro="cita">
                                    <div class="kt-notification__item-icon">

                                    </div>
                                    <div class="kt-notification__item-details">
                                        <div class="kt-notification__item-title">
                                           Citas
                                        </div>
                                        
                                    </div>
                                </a>
                                <a href="#" class="kt-notification__item citas" data-filtro="evento">
                                    <div class="kt-notification__item-icon">

                                    </div>
                                    <div class="kt-notification__item-details">
                                        <div class="kt-notification__item-title">
                                           Eventos y Recordatorios
                                        </div>

                                    </div>
                                </a>
                                <a href="#" class="kt-notification__item feedback" data-filtro="feedback">
                                    <div class="kt-notification__item-icon">

                                    </div>
                                    <div class="kt-notification__item-details">
                                        <div class="kt-notification__item-title">
                                           Retroalimentaciones
                                        </div>

                                    </div>
                                </a>
                                <a href="#" class="kt-notification__item mensajeria" data-filtro="mensaje">
                                    <div class="kt-notification__item-icon">

                                    </div>
                                    <div class="kt-notification__item-details">
                                        <div class="kt-notification__item-title">
                                            Mensajería
                                        </div>

                                    </div>
                                </a>
                                <a href="#" class="kt-notification__item pacientes" data-filtro="paciente">
                                    <div class="kt-notification__item-icon">

                                    </div>
                                    <div class="kt-notification__item-details">
                                        <div class="kt-notification__item-title">
                                           Pacientes
                                        </div>

                                    </div>
                                </a>
                                <a href="#" class="kt-notification__item pacientes" data-filtro="solicitud">
                                    <div class="kt-notification__item-icon">

                                    </div>
                                    <div class="kt-notification__item-details">
                                        <div class="kt-notification__item-title">
                                           Solicitud de citas
                                        </div>

                                    </div>
                                </a>
                                <a href="#" class="kt-notification__item recordatorios" data-filtro="recordatorio">
                                    <div class="kt-notification__item-icon">

                                    </div>
                                    <div class="kt-notification__item-details">
                                        <div class="kt-notification__item-title">
                                           Bandeja de salida
                                        </div>

                                    </div>
                                </a>
                            </div>
                            <div class="kt-separator kt-separator--space-lg kt-separator--border-dashed"></div>
                        </div>
                    </div>
                    <!--end::Portlet-->
                    <!--begin::Portlet-->
                    <div class="kt-portlet" style="background-color: transparent; box-shadow: none; margin-top: -90px;">
                        <div class="kt-portlet__head">
                            <div class="kt-portlet__head-label">
                                <h3 class="kt-portlet__head-title">
                                    Filtros por hora
                                </h3>
                            </div>
                        </div>
                        <div class="kt-portlet__body kt-padd">
                            <div class="kt-notification kt-notification--fit filters-notificaciones-hora">
                                <a href="#" class="kt-notification__item" data-filtro="SORT_ASC" id="sort-asc">
                                    <div class="kt-notification__item-icon">
                                        
                                    </div>
                                    <div class="kt-notification__item-details">
                                        <div class="kt-notification__item-title">
                                            Ascendente
                                        </div>

                                    </div>
                                </a>
                                <a href="#" class="kt-notification__item" data-filtro="SORT_DESC" id="sort-desc">
                                    <div class="kt-notification__item-icon">

                                    </div>
                                    <div class="kt-notification__item-details">
                                        <div class="kt-notification__item-title">
                                           Descendente
                                        </div>

                                    </div>
                                </a>
                                <a href="#" class="kt-notification__item" data-filtro="RECENT" id="recent">
                                    <div class="kt-notification__item-icon">

                                    </div>
                                    <div class="kt-notification__item-details">
                                        <div class="kt-notification__item-title">
                                           Más reciente
                                        </div>

                                    </div>
                                </a>
                            </div>
                            <div class="kt-separator kt-separator--space-lg kt-separator--border-dashed"></div>
                        </div>
                    </div>
                    <!--end::Portlet-->
                </div>
            </div>
        </div>
        <div id="confirmarCitaModal" class="modal fade">
            <div class="modal-dialog modal-sm">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Confirmar</h4>
                        <button class="close"></button>
                    </div>
                    <div class="modal-body">
                        <p>¿El paciente asistió a su cita?</p>
                    </div>
                    <div class="modal-footer">
                        <button id="btn-confirmarCitaModalNo" class="btn btn-sm btn-default">No</button>
                        <button id="btn-confirmarCitaModalYes" class="btn btn-sm btn-primary">Si</button>
                    </div>
                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->
        
        <div id="seguimientosModal" class="modal-seg">
            <div class="modal-contenido">
                <div class="modal-head">
                  <h4 class="title-mod" id="segTitulo"></h4> 
                  <span id="closeModalSeg" class="close">&times;</span>
                </div>
              <div id="segCuerpo"></div>
            </div>
        </div>
        <!-- Modal seguimiento: end -->

        <?= $this->render('../modals/modals-solicitud-cita.php')?>
             
        <?php }else{ ?>
        <div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content" style="background-color: transparent; box-shadow: none;"> 
            <div class="row">
                <div class="col-lg-9">
                    <!--begin::Portlet-->
                    <div class="kt-portlet" style="background-color: white;">
                        <div class="kt-portlet__head">
                            <div class="kt-portlet__head-label">
                                <h3 class="kt-portlet__head-title">Comentarios</h3>
                            </div>
                        </div>
                        <div class="kt-portlet__body">
                            <div class="kt-notification-v2" id="comentarios-ls">
                                
                            </div>
                        </div>
                    </div>
                <!--end::Portlet-->
                </div>
                <div class="col-lg-3">
                    <!--begin::Portlet-->
                    <div class="actividad-body kt-portlet" style="background-color: transparent; box-shadow: none;">
                        <div class="kt-portlet__head">
                            <div class="kt-portlet__head-label">
                                <h3 class="kt-portlet__head-title">
                                    Filtros de actividad
                                </h3>
                            </div>
                        </div>
                        <input id="fecha-comentario" class="btn btn-success mt-2 mb-2 col-md-10 col-sm-6" value="<?=date('d/m/Y')?>" style="font-size:16px;">
                    </div>
                    <!--end::Portlet-->
                </div>
            </div>
        </div>
    <?php }?>
</div>