<?php

use yii\helpers\Html;
use app\assets\ConfiguracionAsset;
use app\models\CobroPagadito;
use app\models\Suscripcion;
use app\customs\QuiiEditorConf;
use bizley\quill\assets\QuillAsset;

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */
/* @var $pagadito app\models\Pagadito */
/* @var $usuario app\models\Usuario */
/* @var $suscripcion app\models\Suscripcion */

$usuario = Yii::$app->user->identity;
$suscripcion = $usuario->suscripcion;


$opt_iva_1_chk = ($pagadito != null && $pagadito->cargar_iva == CobroPagadito::IVA_INCLUIDO) ? 'checked' : '';
$opt_iva_2_chk = ($pagadito != null && $pagadito->cargar_iva == CobroPagadito::AGREGAR_IVA) ? 'checked' : '';
$opt_iva_3_chk = ($pagadito != null && $pagadito->cargar_iva == CobroPagadito::SIN_IVA) ? 'checked' : '';

$metodo_cobro_1_chk = ($pagadito != null && $pagadito->metodo_cobro == CobroPagadito::ASUMIR_CARGO_PASARELA) ? 'checked' : '';
$metodo_cobro_2_chk = ($pagadito != null && $pagadito->metodo_cobro == CobroPagadito::CARGO_PASARELA_PACIENTE) ? 'checked' : '';
$cobrar_pasarel_chk = ($pagadito != null && boolval($pagadito->cobrar_pasarela)) ? 'checked' : '';

$this->title = 'Configuraciones' . (($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA && $admin) ? ' Generales' : ' del terapeuta');
$this->params['breadcrumbs'][] = $this->title;
ConfiguracionAsset::register($this);
QuillAsset::register($this);
?>
<script>
    var esAdminJerarquia = <?= ($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA && $admin) ? 'true' : 'false' ?>;
</script>
<div class="configuracion-suscripcion-configs kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
        <div class="mt-3 mb-2">
            <button class="btn btn-success bnt-float save-btn" id="save">Guardar</button>
        </div>
    </div>
    <div class="kt-portlet__body">
        <?php if ($suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL || ($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA && $admin)) { ?>
            <div class="row">
                <div class="col-md-12">
                    <h4>Plantillas para diagnóstico</h4>
                </div>
            </div>
            <div class="row">
                <div class="col-md-7">
                    <p>Modelo de texto para agregar un diagnostico precargado configurado por el usuario.</p>
                </div>
                <div class="col-md-5">
                    <button class="btn btn-primary" data-toggle="modal" data-target="#plantillas-crud">Plantillas de Historial Médico</button>
                </div>
            </div>
            <div class="line"></div>
            <div class="row">
                <div class="col-md-12">
                    <h4>Configuración de Recetas</h4>
                </div>
            </div>
            <div class="row">
                <div class="col-md-7">
                    <p>Configuración de la información necesaria para el uso de recetas digitales, tales como la información de contacto, la especialidad del profesional, el número de cédula o JVMP, entre otros.</p>
                </div>
                <div class="col-md-5">
                    <button style="width: 214px;" class="btn btn-primary" data-toggle="modal" data-target="#info-receta">Configuración de Recetas</button>
                </div>
            </div>
            <div class="line"></div>
        <?php } ?>
        <?php foreach ($configs as $conf) : ?>
            <?php
                $blokeds = ['google_calendar','link_medio_teleconsulta','link_teleconsulta','informacion_recetas_medicas'];
                if (in_array($conf['llave'], $blokeds)) {
                }else{  
            ?>

                <div class="conf-<?= $conf['llave'] ?>">
                    <div class="row">
                        <div class="col-md-12">
                            <h4><?= $conf['nombre'] ?></h4>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-7">
                            <p><?= $conf['descripcion'] ?></p>
                        </div>
                        <div class="col-md-5">
                            <?= $this->render('_field', ['conf' => $conf]); ?>
                            <?php if ($conf['llave'] == 'conf_medio_pago') : ?>
                                <div class="row">
                                    <div class="col-md-4">
                                        <button id="conf-pagadito-btn" style="width: 210px; display: none;" class="btn btn-primary" data-toggle="modal" data-target="#info-pagadito-modal">Configuración de Pagos
                                        </button>
                                        <button id="conf-url-propia-btn" style="width: 210px; 
                                    display: none;" class="btn btn-primary" data-toggle="modal" data-target="#modal-url-cobro">Configuración de Pagos
                                        </button>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="line"></div>
                </div>
            <?php    }?>
        <?php endforeach; ?>
        <div class="row">
            <div class="col-md-12">
                <h4>Medio de consulta virtual</h4>
            </div>
        </div>
        <div class="row">
            <div class="col-md-7">
                <p>Escribe tu link de consultas virtuales o indica en qué medio realizarás la consulta</p>
            </div>
            <div class="col-md-5">
                <input id="<?= $teleconsultaConf->llave ?>" class="form-control ctrl-config-libre" data-tipo="<?= $teleconsultaConf->tipo ?>" value="<?= $teleconsultaConf->valor == null ? 'Meet, Zoom, Skype o link de Doxy' : $teleconsultaConf->valor ?>" placeholder="Meet, Zoom, Skype o link de Doxy" data-long="35">
                <span id="leng-teleconsulta" style="font-size: 12px;" class="kt-badge kt-badge--brand kt-badge--inline kt-badge--pill kt-badge--rounded mt-1"></span>
            </div>
        </div>
        <?php if ($suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL || ($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA && $admin)) : ?>

            <div class="line"></div>
            <div class="row">
                <div class="col-md-12">
                    <h4>Configuracion de url para solicitudes de cita</h4>
                </div>
            </div>
            <div class="row">
                <div class="col-md-7">
                    <p>Configuracion del usuario con el que sera configurada la url para realizar solicitud de citas externas</p>
                </div>
                <div class="col-md-5">
                    <div class="input-group mb-3">
                        <div class="input-group-prepend">
                            <span class="input-group-text" id="url-solicitud-add"><?= Yii::$app->params['shortUrlServer'] . 'me/?' ?></span>
                        </div>
                        <input type="text" class="form-control" id="url-solicitud">
                        <div class="input-group-append">
                            <button id="url-solicitud-btn" type="button" class="btn btn-primary copy-btn" data-id="url-solicitud">Copiar</button>
                        </div>
                    </div>
                    <span id="leng-url-sus" style="font-size: 12px; display: none;" class="kt-badge kt-badge--brand kt-badge--inline kt-badge--pill kt-badge--rounded mt-1"></span>
                    <span id="mensaje-url-conf"></span>
                </div>
            </div>
            <div class="line"></div>
            <div class="row">
                <div class="col-md-12">
                    <h4><?= $medioTeleconsultaConf->nombre ?></h4>
                </div>
            </div>
            <div class="row">
                <div class="col-md-7">
                    <p><?= $medioTeleconsultaConf->descripcion ?></p>
                </div>
                <div class="col-md-5">
                    <div class="input-group mb-3">
                        <div class="input-group-prepend">
                            <span class="input-group-text" id="<?= $medioTeleconsultaConf->llave ?>-add">https://</span>
                        </div>
                        <input id="<?= $medioTeleconsultaConf->llave ?>" class="form-control ctrl-config-libre" data-tipo="<?= $teleconsultaConf->tipo ?>" value="<?= $medioTeleconsultaConf->valor ?>">
                        <div class="input-group-append">
                            <button id="<?= $medioTeleconsultaConf->llave ?>-btn" type="button" class="btn btn-primary copy-btn" data-id="<?= $medioTeleconsultaConf->llave ?>">Copiar</button>
                        </div>
                    </div>
                </div>
            </div>
            
        <?php endif ?>
        <div class="line"></div>
            <div class="row">
                <div class="col-md-12">
                    <h4>Configuracion de Google Calendar</h4>
                </div>
            </div>
            <div class="row" id="google-calendar-conf">
                <div class="col-md-7">
                    <p>Configuracion del usuario con el que sera configurada la url para realizar solicitud de citas externas</p>
                </div>
                <div class="col-md-5">
                    <?php if (is_null($calendars)) : ?>
                        <a href="<?php echo $url_auth_calendar; ?>" style="width: 214px;" class="btn btn-primary">Autorizar</a>
                    <?php else : ?>
                        <select name="google_calendar" id="google_calendar" class="form-control ctrl-config-libre">
                            <option value="">Seleccione un calendario</option>
                            <?php foreach ($calendars as $cals => $ca): ?>
                            <option value="<?=$cals?>" <?=($cals==$googlecalendarConf->valor)?'selected':''?>><?=$ca?></option>
                            <?php endforeach; ?>
                        </select>
                        <a href="#" to="<?php echo $url_desvincular_calendar; ?>" class="btn btn-primary desvincular-calendario" id="save3">Desvincular Calendario</a>

                    <?php endif ?>
                </div>
            </div>
        <div class="line"></div>
        <div class="row">
            <div class="col-lg-12 text-right">
                <button class="btn btn-success save-btn" id="save2">Guardar</button>
            </div>
        </div>
    </div>
</div>


<div id="plantillas-crud" class="modal fade">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content" id="crud-content">
            <div class="modal-header">
                <h4 class="modal-title" id="_segTitle">Plantillas para Diagnóstico</h4>
                <button class="close" data-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row mb-4 text-right">
                    <div class="offset-8 col-md-4">
                        <button class="btn btn-success" id="crear-plantilla">Crear Plantilla</button>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover" id="plantillas-t">
                        <thead>
                            <tr>
                                <th>N</th>
                                <th>Título</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<div id="plantillaView" class="modal fade">
    <div class="modal-dialog modal-dialog-top modal-lg">
        <div class="modal-content" id="plantillaViewCont">
            <div class="modal-header">
                <h4 class="modal-title" id="tituloView"></h4>
                <button class="close" data-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body bodyView" id="bodyView">

            </div>
            <div class="modal-footer" id="footerView">
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<div id="plantillaCrear" class="modal fade">
    <div class="modal-dialog modal-dialog-top modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="tituloCrear"></h4>
                <button class="close" data-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                <div class="col-md-12">
                    <label>Título<span style="color:red;">&nbsp;*</span></label>
                    <input type="text" class="form-control" value="" id="tituloCrearInput">
                    <input type="hidden" value="" id="id-plantilla">
                </div>
             </div>
             <div class="row mt-3">
                <div class="col-md-12">
                    <label>Cuerpo<span style="color:red;">&nbsp;*</span></label>
                    <?=QuiiEditorConf::init($id='plantilla')?>
                </div>
             </div>
            </div>
            <div class="modal-footer" id="footerCrear">
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<div id="info-receta" class="modal fade">
    <div class="modal-dialog modal-dialog-top modal-md">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="infoReceta_titulo">Información de Receta Médica</h4>
                <button class="close" data-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="infoReceta_body">
                <div class="row">
                    <div class="col-md-12">
                        <label>Nombre:</label><span style="color: red;"> *</span>
                        <input type="text" name="nombre" id="nombre" class="form-control max" data-long="30" required>
                        <small id="error-nombre" class="error" style="display: none;">Máximo 30 carácteres</small>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <label>Apellido:</label><span style="color: red;"> *</span>
                        <input type="text" name="apellido" id="apellido" class="form-control max" data-long="30" required>
                        <small id="error-apellido" class="error" style="display: none;">Máximo 30 carácteres</small>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <label>Cédula/JVMP:</label><span style="color: red;"> *</span>
                        <select id="cedula-jvmp" name="cedula-jvmp" class="form-control" required>
                            <option value="JVMP">JVMP</option>
                            <option value="JVPP">JVPP</option>
                            <option value="Cédula">Cédula</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label>Cédula Profesional/JVPM:</label><span style="color: red;"> *</span>
                        <input type="text" name="cedula" id="cedula" class="form-control" required>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <label>Especialidad:</label><span style="color: red;"> *</span>
                        <input type="text" name="especialidad" id="especialidad" class="form-control max" data-long="30" required>
                        <small id="error-especialidad" class="error" style="display: none;">Máximo 30 carácteres</small>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <label>Intitución que lo certifique o Universidad:</label><span style="color: red;"> *</span>
                        <input type="text" name="institucion" id="institucion" class="form-control max" data-long="40" required>
                        <small id="error-institucion" class="error" style="display: none;">Máximo 40 carácteres</small>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <label>Correo de Contacto:</label>
                        <input type="email" name="correo-contacto" id="correo-contacto" class="form-control">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <label>País:</label>
                        <input type="text" name="pais" id="pais" class="form-control">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <label class="kt-checkbox mt-3">
                            <input type="checkbox" id="confirmacion"> Confirmo que esta información es válida y se puede utilizar en recetas médicas.
                            <span></span>
                        </label>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <p>
                            *La información del teléfono de contacto, la dirección y el logo que se despliega en la receta se toman a partir de los datos proporcionados en la creación de una clínica.
                            <u><?= Html::a('Click aquí para editarlos.', ['clinica/index']) ?></u>
                        </p>
                    </div>
                </div>
            </div>
            <div class="modal-footer" id="infoReceta_foot">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <button type="button" id="guardar-info-receta" class="btn btn-success">Guardar</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->


<!--Modal datos pagadito-->
<div id="info-pagadito-modal" class="modal fade">
    <div class="modal-dialog modal-dialog-centered modal-md">
        <div class="modal-content" id="contenido-cobro">
            <div class="modal-header">
                <h4 class="modal-title">Cuenta Pagadito</h4>
                <button class="close" data-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form class="form" autocomplete="off">
                    <div>
                        <p>
                            Los campos "UID" y "WSK" son identificadores que la plataforma de Pagadito provee luego de realizar el registro del comercio.<br>
                            Estos campos son de suma imporancia ya que son los que le permitirán realizar cobros.
                        </p>
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <label>UID</label>
                            <input type="hidden" id="id-pagadito" value="<?= $pagadito != null ? $pagadito->id : '' ?>">
                            <input type="text" class="form-control" id="uid" value="<?= $pagadito != null ? $pagadito->uid : '' ?>" maxlength="32">
                        </div>
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <label>WSK</label>
                            <input type="text" class="form-control" id="wsk" value="<?= $pagadito != null ? $pagadito->wsk : '' ?>" maxlength="32">
                        </div>
                    </div>
                    <div class="row ml-2">
                        <div class="form-group mt-5">
                            <label><strong>¿Cobro de IVA?</strong></label>
                            <div class="radio-inline">
                                <label class="radio p-1">
                                    <input type="radio" name="iva" value="<?= CobroPagadito::IVA_INCLUIDO ?>" <?= $opt_iva_1_chk == 'checked' ? $opt_iva_1_chk : 'checked' ?>>
                                    <span></span>IVA Incluido en Monto
                                </label>
                                <label class="radio p-1">
                                    <input type="radio" name="iva" value="<?= CobroPagadito::AGREGAR_IVA ?>" <?= $opt_iva_2_chk ?>>
                                    <span></span>Agregar IVA
                                </label>
                                <label class="radio p-1">
                                    <input type="radio" name="iva" value="<?= CobroPagadito::SIN_IVA ?>" <?= $opt_iva_3_chk ?>>
                                    <span></span>No Cobrar IVA
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="row ml-2">
                        <div class="form-group mt-2">
                            <label><strong>¿Cargo de Pasarela de Pago?</strong></strong><span class="text-muted" style="font-size: 11px;"> (Pertenece a la Pasarela y no a Olivia)</span></label>
                            <div class="radio-inline">
                                <label class="radio p-1">
                                    <input type="radio" name="cargo-pasarela" value="<?= CobroPagadito::ASUMIR_CARGO_PASARELA ?>" <?= $metodo_cobro_1_chk == 'checked' ? $metodo_cobro_1_chk : 'checked' ?>>
                                    <span></span>Asumir Cobro
                                </label>
                                <label class="radio p-1">
                                    <input type="radio" name="cargo-pasarela" value="<?= CobroPagadito::CARGO_PASARELA_PACIENTE ?>" <?= $metodo_cobro_2_chk ?>>
                                    <span></span>Cobrar al Paciente
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <p>
                                Copia y pega los siguientes links:<br><br>
                                <span><strong>https://ohdr.co/c/resultado-pago?token={value}</strong></span><br><br>
                                En la sección de "Parámetros de Integración" de tu plataforma de Pagadito.
                                En esa sección encontrarás un parámetro llamado: URL de Retorno.
                                Allí debes de ingresarlo para un correcto funcionamiento.<br><br>
                                <span><strong>https://ohdr.co/mpd/index</strong></span><br><br>
                                En la sección de "Webhooks" de tu plataforma de Pagadito, habilitando el envío de notificaciones via Webhooks y luego en el campo:
                                Webhooks URL debes de ingresarlo para un correcto funcionamiento.<br><br>
                            </p>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" id="guardar-pagadito">Guardar</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->


<!--url de cobro personalizado-->
<div class="modal fade" id="modal-url-cobro" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Link de cobro</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Agrega el link que redigirá a tus pacientes a tu página de cobros.
                    Responde las preguntas para configurar tus facturas digitales y hacer que Olivia recuerde tus preferencias.
                </p>
                <hr />
                <div class="form-group">
                    <label><strong>Link de Página de Cobros:</strong></label>
                    <input id="link-cobro" class="form-control" name="link-cobro" value="<?= $pagadito != null ? $pagadito->link_externo : '' ?>">
                </div>
                <div class="form-group">
                    <label><strong>¿Cobro de IVA? </strong><span class="text-grey">Valor de IVA agregado al monto del servicio</span></label>
                    <div class="radio-inline">
                        <label class="radio p-1">
                            <input type="radio" name="iva-link" value="<?= CobroPagadito::IVA_INCLUIDO ?>" checked="">
                            <span></span>IVA Incluido en Monto
                        </label>
                        <label class="radio p-1">
                            <input type="radio" name="iva-link" value="<?= CobroPagadito::AGREGAR_IVA ?>" <?= $opt_iva_2_chk ?>>
                            <span></span>Agregar IVA
                        </label>
                        <label class="radio p-1">
                            <input type="radio" name="iva-link" value="<?= CobroPagadito::SIN_IVA ?>" <?= $opt_iva_3_chk ?>>
                            <span></span>No Cobrar IVA
                        </label>
                    </div>
                </div>
                <div class="form-group">
                    <label><strong>¿La pasarela de pagos que utilizas tiene un cobro extra?</strong></label>
                    <div class="radio-inline">
                        <label class="radio p-1">
                            <input type="radio" name="cobrar-pasarela-link" value="SI" <?= $cobrar_pasarel_chk ?>>
                            <span></span>Sí
                        </label>
                        <label class="radio p-1">
                            <input type="radio" name="cobrar-pasarela-link" value="NO" checked="">
                            <span></span>No
                        </label>
                    </div>
                </div>
                <div class="form-group campos-cargo-pasarela" <?= ($pagadito != null && \boolval($pagadito->cobrar_pasarela)) ? 'style="display:block;"' : 'style="display:none;"' ?>>
                    <label><strong>¿Cuál es este cobro extra? </strong></label>
                    <div class="row">
                        <div class="col-md-6">
                            <label><strong>Monto fijo:</strong><small>(en centavos - ej: 25ctvs)</small></label>
                            <input type="number" id="valor-fijo" name="valor-fijo" class="form-control" value="<?= ($pagadito != null) ? $pagadito->monto_fijo : 0 ?>" />
                        </div>
                        <div class="col-md-6">
                            <label><strong>Monto porcentual:</strong><small>(en % - ej: 5%)</small></label>
                            <input type="number" id="valor-porcentual" name="valor-porcentual" class="form-control" value="<?= ($pagadito != null) ? $pagadito->monto_porcentual : 0 ?>" />
                        </div>
                    </div>
                </div>
                <div class="form-group campos-cargo-pasarela" <?= ($pagadito != null && \boolval($pagadito->cobrar_pasarela)) ? 'style="display:block;"' : 'style="display:none;"' ?>>
                    <label><strong>¿Cargo de Pasarela de Pago?</strong></strong><span class="text-muted" style="font-size: 11px;"> (Pertenece a la Pasarela y no a Olivia)</span></label>
                    <div class="radio-inline">
                        <label class="radio p-1">
                            <input type="radio" name="cobro-pasarela-link" value="<?= CobroPagadito::ASUMIR_CARGO_PASARELA ?>" <?= $metodo_cobro_1_chk == 'checked' ? $metodo_cobro_1_chk : 'checked' ?>>
                            <span></span>Asumir Cobro
                        </label>
                        <label class="radio p-1">
                            <input type="radio" name="cobro-pasarela-link" value="<?= CobroPagadito::CARGO_PASARELA_PACIENTE ?>" <?= $metodo_cobro_2_chk ?>>
                            <span></span>Cobrar al Paciente
                        </label>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button id="guardar-link-cobro" type="button" class="btn btn-primary">Guardar</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
