<?php

use yii\helpers\Html;
use app\models\Configuracion;
/* @var $this yii\web\View */

$posiblesValores = ( $conf['tipo'] == Configuracion::TIPO_CHECKBOX_GROUP 
        || $conf['tipo'] == Configuracion::TIPO_LISTA 
        || $conf['tipo'] == Configuracion::TIPO_RADIO_BTN_GROUP ) 
        ?  explode("|", $conf['posibles_valores']) 
        : null;                
$Valores = ($conf['tipo'] == Configuracion::TIPO_CHECKBOX_GROUP 
        || $conf['tipo'] == Configuracion::TIPO_LISTA 
        || $conf['tipo'] == Configuracion::TIPO_RADIO_BTN_GROUP ) 
        ? explode("|", $conf['valor']) 
        : null;

?>
<?php if( $conf['tipo'] == Configuracion::TIPO_BOLEANO ){?>  
    <div class="custom-control custom-switch">
        <input 
            id="<?=$conf['llave']?>" 
            type="checkbox" 
            data-tipo="<?=$conf['tipo']?>" 
            name="<?=$conf['llave']?>" 
            class="custom-control-input ctrl-config-swt" 
            <?= boolval($conf['valor']) ? "checked='checked'" : ""?> >
        <label class="custom-control-label" for="<?=$conf['llave']?>"></label>
    </div>
<?php } else if( $conf['tipo'] == Configuracion::TIPO_CHECKBOX_GROUP ){ 
    foreach ($posiblesValores as $valor){ ?>
        <div class="kt-checkbox-inline">
            <label class="kt-checkbox">
            <input 
                type="checkbox" 
                data-tipo="<?=$conf['tipo']?>" 
                class="ctrl-config-check values-<?=$conf['llave']?>" 
                value="<?=$valor?>" id="<?=$conf['llave']?>" 
                <?= in_array($valor,$Valores) ? "checked='checked'" : "" ?>> <?=ucwords($valor)?>
            <span></span>
            </label>
        </div>

    <?php } ?>
<?php } else if( $conf['tipo'] == Configuracion::TIPO_LISTA ){ ?>
      <label></label>
      <select class="form-control ctrl-config-ls" id="<?=$conf['llave']?>" data-tipo="<?=$conf['tipo']?>" >
          <?php foreach ($posiblesValores as $valor){?>
            <option value="<?=$valor?>" <?= $valor == $conf['valor'] ? 'selected' : '' ?>><?=ucwords($valor)?></option>
          <?php }?>
      </select>
<?php } else if($conf['tipo'] == Configuracion::TIPO_TEXTO && $conf['llave'] != 'informacion_recetas_medicas' ){  ?> 
        <label></label>
        <textarea 
            id="<?=$conf['llave']?>" 
            class="form-control 
            ctrl-config-text" 
            data-tipo="<?=$conf['tipo']?>"><?=$conf['valor']?></textarea>
        <span 
            id="<?=$conf['llave']?>-length" 
            style="font-size: 12px;" 
            class="kt-badge kt-badge--brand kt-badge--inline kt-badge--pill kt-badge--rounded mt-1"
            ><?= strlen($conf['valor'])?>
        </span>
<?php } else if( $conf['tipo'] == Configuracion::TIPO_RADIO_BTN_GROUP  ) { ?>
    <?php foreach ( $posiblesValores as $k => $val ):?>
        <div class="custom-control custom-switch mb-2">    
            <input 
            id="<?=$conf['llave'].'-'.$k?>" 
            data-llave="<?=$conf['llave']?>" 
            type="checkbox"
            class="custom-control-input ctrl-config-swt-2"
            data-tipo="<?=$conf['tipo']?>" 
            name="<?=$conf['llave']?>" 
            value="<?=$val?>" 
            <?= in_array($val,$Valores) ? 'checked="checked"' : ''?> >
            <label class="custom-control-label" for="<?=$conf['llave'].'-'.$k?>" ><?=$val?></label>
        </div>
    <?php endforeach;?>
<?php } else { ?>
    <div class="form-group">
        <label></label><br>
        <input 
            id="<?=$conf['llave']?>" 
            type="number" 
            value="<?=$conf['valor']?>" 
            class="form-control ctrl-config-int values-<?=$conf['llave']?>" 
            pattern="[0-9]" 
            data-tipo="<?=$conf['tipo']?>">
    </div>
<?php }?>   