<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model app\models\Seguimiento */

$clasePaciente =  empty($model['paciente']) ? '' : ' cuadro-lleno';
$nombrePaciente = $model->isNewRecord ? '' : $model->paciente->nombreCompleto;
$codigo = $model->isNewRecord ? '-----' : $model->paciente->codigo;
$nombrePaciente = (!$model->isNewRecord && isset($pacienteNombre) && $pacienteNombre != null ) ? $pacienteNombre : ($model->isNewRecord ? '' : $model->paciente->nombreCompleto);
$codigo = (!$model->isNewRecord && isset($codigo) && $codigo != null ) ? $codigo : ($model->isNewRecord ? '' : $model->paciente->codigo);
$disabled = true;

?>
<style>
    .cuadro-lleno{
        background-color: #f7f8fa !important;
        cursor: pointer;
    }
</style>
<?php $form = ActiveForm::begin(['options' => ['class' => 'kt-form', 'autocomplete' => 'off', 'id'=>'seg-form' ]]); ?>
<div class="row" id="field">
    <div class="col-md-12"><br>
        Código: <span id="cod-pac"><?=$codigo == null ? 'No definido' : $codigo ?></span>
        <?= $form->field($model, 'id')->hiddenInput(['class'=>'seg form-control' ])->label(false) ?>
    </div>
</div>
<?php if(!$model->isNewRecord){?>
<div class="row">
    <div class="col-lg-4">
        <?= $form->field($model, 'estado')->checkbox(['id'=>'seguimiento-estado']) ?>
    </div>
</div>
<?php }?>
<div class="row">
    <div class="col-md-12 required">
        <label class="control-label" for="pacienteAutocomplete">Paciente</label>
        <?= Html::textInput('pacienteAutocomplete', $nombrePaciente, ['id' => 'pacienteAutocomplete', 'class' => 'form-control' . $clasePaciente]) ?>
        <?= $form->field($model, 'id_paciente')->hiddenInput()->label(false) ?>
    </div>
</div>    
<div class="row">
    <div class="col-md-6">
        <?= $form->field($model, 'fecha_seguimiento')->textInput(['class'=>'seg form-control' ]) ?>
    </div>
    <div class="col-md-6">
        <?= $form->field($model, 'hora_seguimiento')->textInput(['class'=>'seg form-control' ]) ?>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <?= $form->field($model, 'motivo')->textArea(['class'=>'seg-motivo form-control','placeholder'=>'Escribe aquí el motivo por el cual el paciente no se presentó a su cita. Por ejemplo: ¡Tuvo que salir de viaje!' ]) ?>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <?= $form->field($model, 'interaccion')->textArea(['class'=>'seg-interaccion form-control', 'placeholder'=>'Escribe aquí la acción que debes de hacer para dar el seguimiento necesario. Por ejemplo: ¡Llamar al paciente porque él no ha marcado aún!' ]) ?>
    </div>
</div>
<div class="row seg-btn">
    <div class="col-lg-12">
        <?= Html::submitButton('Guardar', ['class' => 'btn btn-success btn-block', 'id'=>'guardar-seg']) ?>
    </div>
</div>
<?php ActiveForm::end(); ?>
