<?php
use yii\helpers\Html;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $model app\models\Seguimiento */
/* @var $interaccion app\models\BitacoraSeguimiento */

$nombrePaciente = $model->paciente->nombreCompleto;
$codigo = $model->paciente->codigo != null ? $model->paciente->codigo : 'No definido';
?>
<style>
    .detalle-tittle{
        font-size: 1.2rem !important;
        margin-left: 5px !important;
        margin-bottom: 30px !important;
        line-height: 25px;
    }
    .detalle-text{
        font-size: 1.2rem !important;
        margin-bottom: 20px !important;
        margin-left: 5px !important;
        line-break: auto !important;

    }
</style>
<div class="row">
     <div class="col-md-7">
        <strong class="detalle-tittle">Código:</strong><br><span class="detalle-text" id="cod-pac"><?=$codigo == null ? 'No definido' : $codigo ?></span><br>
        <strong class="detalle-tittle">Paciente:</strong><br><span class="detalle-text"><?=$nombrePaciente?></span><br>
        <strong class="detalle-tittle">Fecha de Seguimiento:</strong><br><span class="detalle-text" id="fechaSegDB"><?=$model->fecha_seguimiento.' '. substr($model->hora_seguimiento,0,5)?> </span><br>
    </div>
    <div class="col-md-5 text-right" id="acciones">
        <button id="btnAcercamiento" class="btn btn-success acercamiento" 
        data-id="<?=$interaccion->id_seguimiento?>"
        data-fecha="<?=$model->fecha_seguimiento?>"
        data-hora="<?=$model->hora_seguimiento?>"
        data-paciente="<?=$nombrePaciente?>"><i class="fa fa-plus"></i>Seguimiento</button>
       <div class="dropdown dropdown-inline">
           <button type="button" class="btn btn-clean btn-icon btn-sm btn-icon-md" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
               <i class="flaticon-more"></i>
           </button>
           <div class="dropdown-menu dropdown-menu-right" style="">
                <?= Html::a('<i class="la la-plus mt-2"></i> Agregar Cita</a>', ['cita/create', 'pid' => $model->id_paciente], ['class' => 'dropdown-item']) ?>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item mc-s-mod" href="#" data-id="<?=$model->id?>"><i class="la la-check-circle mt-2"></i>Marcar como Completado</a>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item mp-s-mod" href="#" data-id="<?=$model->id?>"><i class="la la-trash mt-2"></i>Marcar como Perdido</a>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item" href="<?= Url::to(['paciente/view', 'id' => $model->id_paciente])?>"><i class="la la-user mt-2"></i>Ver Paciente</a>
           </div>
       </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <strong class="detalle-tittle">Motivo:</strong><br><span class="detalle-text"><?=$model->motivo?> </span><br>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <ul class="nav nav-tabs  nav-tabs-line" role="tablist">
            <li class="nav-item mr-lg-5">
                <a class="nav-link active" data-toggle="tab" href="#interaccion" role="tab" aria-selected="true">Seguimiento</a>
            </li>
            <li class="nav-item mr-lg-5"></li>            
            <li class="nav-item mr-lg-5"></li>            
            <li class="nav-item mr-lg-5"></li>            
            <li class="nav-item mr-lg-5"></li>            
            <li class="nav-item mr-lg-5"></li>
            <li class="nav-item mr-lg-5"></li>
            <li class="nav-item">
                <a class="nav-link" data-toggle="tab" href="#bitacora" role="tab" aria-selected="false">Historial</a>
            </li>
        </ul>
        <div class="tab-content">
            <div class="tab-pane active" id="interaccion" role="tabpanel">
                <div id="w1" class="grid-view">
                    <div class="kt-list-timeline">
                        <div class="kt-list-timeline__items">
                            <div class="kt-list-timeline__item">
                                <span class="kt-list-timeline__badge kt-list-timeline__badge--info"></span>
                                <span class="kt-list-timeline__text" id="acercamientoBD">Creado el <strong><?= substr($interaccion->fecha_incidencia,0,10)?></strong> para  <strong><?=$interaccion->fecha_seguimiento?></strong><br>
                                    <strong><?=$interaccion->interaccion?></strong><br>
                                    <span id="comentarioDB">&nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;&nbsp;<?=$interaccion->comentario != null ? $interaccion->comentario : 'No has ingresado un comentario...' ?></span>
                                </span>
                                <span class="kt-list-timeline__time"></span>
                            </div>

                            <div class="kt-list-timeline__item">
                                <span class="kt-list-timeline__badge kt-list-timeline__badge--ligth"></span>
                                <span class="kt-list-timeline__text">
                                    <button id="btnComentario" class="btn btn-success btn-sm" style="font-size:0.8em;" 
                                            data-segid="<?=$interaccion->id_seguimiento?>" 
                                            data-id="<?=$interaccion->id?>"
                                            data-comentario="<?=$interaccion->comentario?>"
                                            data-paciente="<?=$nombrePaciente?>"><i class="fa fa-edit fa-md"></i>Comentario</button>
                                </span>    
                            </div>
                        </div>
                    </div>  
                </div>      
            </div>
            <div class="tab-pane" id="bitacora" role="tabpanel">
                <div id="w2" class="grid-view">
                    <div class="kt-list-timeline">
                        <div class="kt-list-timeline__items" id="kt-list-bitacora">
                        </div>
                    </div>
                </div>       
            </div>
        </div>  
    </div>    
</div>
