<?php

use yii\helpers\Html;
use app\themes\metronic\assets\ChartJsAssets;
use app\themes\metronic\assets\Select2Assets;
use yii\helpers\Url;
use app\themes\metronic\assets\BootstrapDatepickerAssets;
use app\models\Paciente;
use app\customs\Utils;

/* @var $this yii\web\View */
/* @var $resultado array */

$this->title = 'Pacientes';
$this->params['breadcrumbs'][] = $this->title;

ChartJsAssets::register($this);
Select2Assets::register($this);
BootstrapDatepickerAssets::register($this);


$cantidadesEstadosStr = "";
$labelsEstadoStr = "";
$colorEstadoStr = "";
foreach($resultadoEstados as $grupo){
    
    $labelsEstadoStr .= "'" . Paciente::$estados[$grupo['estado']] . "',";
    $cantidadesEstadosStr .= $grupo['cantidad'] . ",";
    $color = Utils::getColor($grupo['estado'] . $grupo['cantidad']);
    $colorEstadoStr .=  "'rgb(" .$color[0] . "," . $color[1] . "," . $color[2]   . ")',";
}

$cantidadesGruposStr = "";
$labelsGruposStr = "";
$colorGruposStr = "";
foreach($resultadoGrupos as $grupo){
    $labelsGruposStr .= "'" . $grupo['nombre'] . "',";
    $cantidadesGruposStr .= $grupo['cantidad'] . ",";
    $color = Utils::getColor($grupo['nombre'] . $grupo['cantidad']);
    $colorGruposStr .=  "'rgb(" .$color[0] . "," . $color[1] . "," . $color[2]   . ")',";
}

$cantidadesSexosStr = "";
$labelsSexosStr = "";
$colorSexosStr = "";
foreach($resultadoSexos as $res){
    $labelsSexosStr .= "'" . $res['sexo'] . "',";
    $cantidadesSexosStr .= $res['cantidad'] . ",";
    $color = Utils::getColor($res['sexo'] . $res['cantidad']);
    $colorSexosStr .=  "'rgb(" .$color[0] . "," . $color[1] . "," . $color[2]   . ")',";
}

$cantidadesEdadStr = "";
$labelsEdadStr = "";
$colorEdadStr = "";
foreach($resultadoEdad as $res){
    $labelsEdadStr .= "' Edad " . $res['edad'] . "',";
    $cantidadesEdadStr .= $res['cantidad'] . ",";
    $color = Utils::getColor($res['edad'] . $res['cantidad']);
    $colorEdadStr .=  "'rgb(" .$color[0] . "," . $color[1] . "," . $color[2]   . ")',";
}

$cantidadesTipoCitaStr = "";
$labelsTipoCitaStr = "";
$colorTipoCitaStr = "";
foreach($resultadoTipoCita as $res){
    $labelsTipoCitaStr .= "' " . $res['tipo_cita'] . "',";
    $cantidadesTipoCitaStr .= $res['cantidad'] . ",";
    $color = Utils::getColor($res['tipo_cita'] . $res['cantidad']);
    $colorTipoCitaStr .=  "'rgb(" .$color[0] . "," . $color[1] . "," . $color[2]   . ")',";
}

$cantidadesPorProcedimientoStr = "";
$labelsPorProcedimientoStr = "";
$colorPorProcedimientoStr = "";
foreach($resultadoPorProcedimiento as $res){
    $labelsPorProcedimientoStr .= "' " . $res['nombre'] . "',";
    $cantidadesPorProcedimientoStr .= $res['cantidad'] . ",";
    $color = Utils::getColor($res['nombre'] . $res['cantidad']);
    $colorPorProcedimientoStr .=  "'rgb(" .$color[0] . "," . $color[1] . "," . $color[2]   . ")',";
}


$cantidadesNivelSocialStr = "";
$labelsNivelSocialStr = "";
$colorNivelSocialStr = "";
foreach($resultadoNivelSocial as $res){
    $labelsNivelSocialStr .= "' " . $res['nombre'] . "',";
    $cantidadesNivelSocialStr .= $res['cantidad'] . ",";
    $color = Utils::getColor($res['nombre'] . $res['cantidad']);
    $colorNivelSocialStr .=  "'rgb(" .$color[0] . "," . $color[1] . "," . $color[2]   . ")',";
}



$this->registerJs("
    var dataEstados = {
        datasets: [{
            data: [" . $cantidadesEstadosStr . "],
            backgroundColor:[
                " . $colorEstadoStr . "
            ]
        }],

        // These labels appear in the legend and in the tooltips when hovering different arcs
        labels: [" . $labelsEstadoStr . "]
    };
    
    var dataGrupos = {
        datasets: [{
            data: [" . $cantidadesGruposStr . "],
            backgroundColor:[
                " . $colorGruposStr . "
            ]
        }],

        // These labels appear in the legend and in the tooltips when hovering different arcs
        labels: [" . $labelsGruposStr . "]
    };
    
    var dataSexos = {
        datasets: [{
            data: [" . $cantidadesSexosStr . "],
            backgroundColor:[
                " . $colorSexosStr . "
            ]
        }],

        // These labels appear in the legend and in the tooltips when hovering different arcs
        labels: [" . $labelsSexosStr . "]
    };

    var dataEdad = {
        datasets: [{
            labels: [" . $labelsEdadStr . "],

            data: [" . $cantidadesEdadStr . "],
            backgroundColor:[
                " . $colorEdadStr . "
            ]
        }],
        labels: [" . $labelsEdadStr . "]
    };


    var dataTipoCita = {
        datasets: [{
            labels: [" . $labelsTipoCitaStr . "],
            data: [" . $cantidadesTipoCitaStr . "],
            backgroundColor:[
                " . $colorTipoCitaStr . "
            ]
        }],
        labels: [" . $labelsTipoCitaStr . "]
    };


    var dataPorProcedimiento = {
        datasets: [{
            labels: [" . $labelsPorProcedimientoStr . "],
            data: [" . $cantidadesPorProcedimientoStr . "],
            backgroundColor:[
                " . $colorPorProcedimientoStr . "
            ]
        }],
        labels: [" . $labelsPorProcedimientoStr . "]
    };

    var dataNivelSocial = {
        datasets: [{
            labels: [" . $labelsNivelSocialStr . "],
            data: [" . $cantidadesNivelSocialStr . "],
            backgroundColor:[
                " . $colorNivelSocialStr . "
            ]
        }],
        labels: [" . $labelsNivelSocialStr . "]
    };


    $(document).ready(function(){
        
        
        $('#fechaHasta').datepicker({
            format: 'dd/mm/yyyy'
        });

        $('#fechaDesde').datepicker({
            format: 'dd/mm/yyyy'
        });
        
        var ctxEstados = $('canvas.chart-estados');
        var myPieChart = new Chart(ctxEstados, {
            type: 'pie',
            data: dataEstados,
            options: {
                legend: { position: 'right' },               
                
            }
        });
        
        var ctxGrupos = $('canvas.chart-grupos');
        var myPieChartGrupos = new Chart(ctxGrupos, {
            type: 'pie',
            data: dataGrupos,
            options: {
                legend: { position: 'right' },               
                
            }
        });
        

        var ctxSexos = $('canvas.chart-sexos');
        var myPieChartSexos = new Chart(ctxSexos, {
            type: 'pie',
            data: dataSexos,
            options: {
                legend: { position: 'right' },               
                
            }
        });

         
        var ctxEdad = $('canvas.chart-edad');
        var myChartEdad = new Chart(ctxEdad, {
            type: 'pie', 
            data: dataEdad,
            options: {
                legend: { position: 'right' },               
                
            }
        });

        var ctxTipoCita = $('canvas.chart-tipo-cita');
        var myChartTipoCita = new Chart(ctxTipoCita, {
            type: 'pie', 
            data: dataTipoCita,
            options: {
                legend: { position: 'right' },               
                
            }

             
        });

        var ctxTPorProcedimiento = $('canvas.chart-por-procedimiento');
        var myChartTPorProcedimiento = new Chart(ctxTPorProcedimiento, {
            type: 'bar', 
            data: dataPorProcedimiento,
            options: {
                legend: { display: false },               
                scales: {
                    yAxes: [{
                        ticks: {
                            beginAtZero: true
                        }
                    }],
                },
            }
        });


        var ctxNivel = $('canvas.chart-nivel-social');
        var myPieChart = new Chart(ctxNivel, {
            type: 'pie',
            data: dataNivelSocial,
            options: {
                legend: { position: 'right' },               
                
            }
        });
        

        $('.groups').select2({
            tags: true,
            placeholder: 'Selecione uno o mas grupos',
            tokenSeparators: [',', ' '],
             width: 'resolve'
        })
    });
    

");

$fechaHastaFormato = date('d/m/Y' , strtotime($fechaHasta));
$fechaDesdeFormato = date('d/m/Y' , strtotime($fechaDesde));
?>
<style type="text/css">
    .hiden{
        display: none !important;
    }

    #box_filter{
        padding: 15px 20px 0;
    }
</style>
<div class="rol-index kt-portlet">
    <div class="kt-portlet__body" id="box_filter">
        <div class="row">
            <div class="col-md-12">
                <form method="post"  class="form-inline" action="<?= Url::to(['reportes/pacientes-unis'])?>">
                  <input type="hidden" name="_csrf" value="<?=Yii::$app->request->getCsrfToken()?>" />
                  <div class="form-group p-3 col-md-4">
                      <label for="grupos" style="padding-right: 10px; ">Elegir Grupos: </label>
                      <select id="grupos" name="grupos[]" class="form-control groups" style="width: 75%;margin-left: 0.5rem !important;" multiple="multiple">
                            <?php 
                                foreach($grupos as $id=>$grupo){ 
                                $selected = (in_array($id, $idGrupos)) ? $id.' selected '.$value : $id.' '.$value ;
                            ?>
                                <option  <?= $selected ?> value="<?= $id ?>"><?= $grupo ?></option>
                            <?php } ?>
                        </select>
                  </div>
                   
                  <div class="form-group p-3">
                      <label for="fechaDesde">Ver desde: </label>
                      <input type="text" style="width: 100px;" class="form-control form-control-sm" id="fechaDesde" name="fechaDesde" placeholder="Fecha desde" value="<?= $fechaDesdeFormato ?>" />
                  </div>
                  <div class="form-group p-3">
                      <label for="fechaHasta">Ver hasta: </label>
                      <input type="text" style="width: 100px;" class="form-control form-control-sm" id="fechaHasta" name="fechaHasta" placeholder="Fecha hasta" value="<?= $fechaHastaFormato ?>" />
                  </div>
                  <button type="submit" class="btn btn-success d-none d-md-block">Filtrar</button>
                  <button type="submit" class="btn btn-success btn-block btn-sm d-md-none p-3 ">Filtrar</button>
                </form>  
            </div>
        </div>
         <div class="row text-right d-md-none d-none">
            <div class="offset-8 col-md-4">
                <span id="badge-periodo" style="font-size: 14px;" class="kt-badge kt-badge--brand kt-badge--inline kt-badge--pill kt-badge--rounded">
                    <b>Filtro:</b>&nbsp; hasta el <?= $fechaHastaFormato ?>
                </span>
            </div>    
        </div>
    </div>
</div>

<div class="row <?php if(!$grupoIs) { echo "hiden"; } ?>">
    <div class="col-lg-4">
        <div class="rol-index kt-portlet">

            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h1 class="kt-portlet__head-title">Pacientes Totales</h1>
                </div>
            </div>

            <div class="kt-portlet__body">
                <div class="row">
                    <div class="col-1"></div>
                    <div class="col-10">
                        <div id="pacientes-chart-container">   
                            <canvas class="chart-grupos" height="400" width="400"></canvas>
                        </div>
                    </div>
                    <div class="col-1"></div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                         <div class="table-responsive scroll scroll-pull" data-scroll="true" data-suppress-scroll-x="false" data-swipe-easing="false" style="height: 200px">
                            <table class="table">
                                <thead>
                                    <th>ÁREA</th>
                                    <th>CANTIDAD</th>
                                </thead>
                                <tbody>
                                    <?php 
                                    $totales = 0;
                                    foreach ($resultadoGruposTotal as $grupo){ 
                                        $totales += intval($grupo['cantidad']);
                                    ?>
                                    <tr>
                                        <td><?= $grupo['nombre']?></td>
                                        <td><?= $grupo['cantidad']?></td>
                                    </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <th>Total general</th>
                                    <th><?= $totales?></th>
                                </tfoot>
                            </table>
                        </div>    
                    </div>
                </div>
            </div>

        </div>
    </div><!--End PACIENTES TOTALES-->
    
    <div class="col-lg-4">
        <div class="rol-index kt-portlet">

            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h1 class="kt-portlet__head-title">Pacientes Por edad</h1>
                </div>
            </div>

            <div class="kt-portlet__body">
                <div class="row">
                    <div class="col-1"></div>
                    <div class="col-10">
                        <div id="pacientes-edad-chart-container">   
                            <canvas class="chart-edad" height="400" width="400"></canvas>
                        </div>
                    </div>
                    <div class="col-1"></div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                         <div class="table-responsive scroll scroll-pull" data-scroll="true" data-suppress-scroll-x="false" data-swipe-easing="false" style="height: 200px">
                            <?php 
                                    $totales = 0;
                                    foreach ($resultadoEdadTotal as $res=>$val){ 
                                        
                                    ?>
                                    <table class="table">
                                    <thead>
                                    <tr>
                                        <th>Grupo - <?= $res ?></th>
                                        <th>Cantidad</th>
                                        
                                    </tr>
                                    </thead>
                                    <?php
                                        foreach($val as $value){
                                            $totales = $totales + $value['cantidad'];
                                    ?>
                                     <tbody>
                                    <tr>
                                        <td><?= $value['grupo']?></td>
                                        <td><?= $value['cantidad']?></td>
                                    </tr>
                                    </tbody>

                                    <?php

                                        }
                                    ?>
                                     </table>
                                    <?php
                                     } 
                                    ?>
                                    <table class="table">
                                        <tfoot>
                                            <th>Total general</th>
                                            <th><?= $totales?></th>
                                        </tfoot>
                                    </table>
                        </div>    
                    </div>
                </div>
            </div>

        </div>
    </div><!--End PACIENTES SEGUN EDAD-->

   
    <div class="col-lg-4">
        <div class="rol-index kt-portlet">
            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h1 class="kt-portlet__head-title">Pacientes según Sexo</h1>
                </div>
            </div>
            <div class="kt-portlet__body">
                <div class="row">
                    <div class="col-1"></div>
                    <div class="col-10">
                        <div id="pacientes-chart-container">   
                            <canvas class="chart-sexos" height="400" width="400"></canvas>
                        </div>

                    </div>
                    <div class="col-1"></div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                         <div class="table-responsive scroll scroll-pull" data-scroll="true" data-suppress-scroll-x="false" data-swipe-easing="false" style="height: 200px">
                                    <?php 
                                    $totales = 0;
                                    foreach ($resultadoSexosTotal as $res=>$val){ 
                                        
                                    ?>
                                    <table class="table">
                                    <thead>
                                    <tr>
                                        <th>Grupo - <?= $res ?></th>
                                        <th>Cantidad</th>

                                        
                                    </tr>
                                    </thead>
                                    <?php
                                        foreach($val as $value){
                                            $totales = $totales +$value['cantidad'];

                                    ?>
                                     <tbody>
                                    <tr>
                                        <td><?= $value['sexo']?></td>
                                        <td><?= $value['cantidad']?></td>
                                    </tr>
                                    </tbody>

                                    <?php

                                        }
                                    ?>
                                     </table>
                                    <?php
                                     } 
                                    ?>

                                    <table class="table">
                                        <tfoot>
                                            <th>Total general</th>
                                            <th><?= $totales?></th>
                                        </tfoot>
                                    </table>
                        </div>    
                    </div>
                </div>
            </div>
        </div>
    </div><!--End PACIENTES SEGUN SEXO-->   
</div> 

<div class="row <?php if(!$grupoIs) { echo "hiden"; } ?>">
    <div class="col-lg-4">
        <div class="rol-index kt-portlet">
            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h1 class="kt-portlet__head-title">Pacientes según Estado</h1>
                </div>
            </div>
            <div class="kt-portlet__body">
                <div class="row">
                    <div class="col-1"></div>
                    <div class="col-10">
                        <div id="pacientes-chart-container">   
                            <canvas class="chart-estados" height="300" width="300"></canvas>
                        </div>
                    </div>
                    <div class="col-1"></div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                         <div class="table-responsive scroll scroll-pull" data-scroll="true" data-suppress-scroll-x="false" data-swipe-easing="false" style="height: 200px">
                             <?php 
                                    $totales = 0;
                                    foreach ($resultadoEstadosTotal as $res=>$val){ 
                                        
                                    ?>
                                    <table class="table">
                                    <thead>
                                    <tr>
                                        <th >Grupo - <?= $res ?></th>
                                        <th>Cantidad</th>
                                        
                                    </tr>
                                    </thead>
                                    <?php
                                        foreach($val as $value){
                                            $totales = $totales +$value['cantidad'];

                                    ?>
                                     <tbody>
                                    <tr>
                                        <td><?= $value['estado']?></td>
                                        <td><?= $value['cantidad']?></td>
                                    </tr>
                                    </tbody>

                                    <?php

                                        }
                                    ?>
                                     </table>
                                    <?php
                                     } 
                                    ?>
                                    <table class="table">
                                        <tfoot>
                                            <th>Total general</th>
                                            <th><?= $totales?></th>
                                        </tfoot>
                                    </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div><!--End PACIENTES SEGUN ESTADOS-->

    <div class="col-lg-4">
        <div class="rol-index kt-portlet">

            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h1 class="kt-portlet__head-title">Pacientes por Tipo Cita</h1>
                </div>
            </div>

            <div class="kt-portlet__body">
                <div class="row">
                    <div class="col-1"></div>
                    <div class="col-10">
                        <div id="pacientes-edad-chart-container">   
                            <canvas class="chart-tipo-cita" height="400" width="400"></canvas>
                        </div>
                    </div>
                    <div class="col-1"></div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                         <div class="table-responsive scroll scroll-pull" data-scroll="true" data-suppress-scroll-x="false" data-swipe-easing="false" style="height: 200px">
                            <?php 
                                    $totales = 0;
                                    foreach ($resultadoTipoCitaTotal as $res=>$val){ 
                                        
                                    ?>
                                    <table class="table">
                                    <thead>
                                    <tr>
                                        <th>Grupo - <?= $res ?></th>
                                        <th>Cantidad</th>

                                        
                                    </tr>
                                    </thead>
                                    <?php
                                        foreach($val as $value){
                                            $totales = $totales +$value['cantidad'];
                                    ?>
                                     <tbody>
                                    <tr>
                                        <td><?= $value['estado']?></td>
                                        <td><?= $value['cantidad']?></td>
                                    </tr>
                                    </tbody>

                                    <?php

                                        }
                                    ?>
                                     </table>
                                    <?php
                                     } 
                                    ?>
                                <table class="table">
                                    <tfoot>
                                        <th>Total general</th>
                                        <th><?= $totales?></th>
                                    </tfoot>
                                </table>
                        </div>    
                    </div>
                </div>
            </div>

        </div>
    </div><!--End PACIENTES SEGUN TIPO CITAS-->

    <div class="col-lg-4">
        <div class="rol-index kt-portlet">

            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h1 class="kt-portlet__head-title">Pacientes por Nivel SocioEconómico</h1>
                </div>
            </div>

            <div class="kt-portlet__body">
                <div class="row">
                    <div class="col-1"></div>
                    <div class="col-10">
                        <div id="pacientes-chart-container">   
                            <canvas class="chart-nivel-social" height="400" width="400"></canvas>
                        </div>
                    </div>
                    <div class="col-1"></div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                         <div class="table-responsive scroll scroll-pull" data-scroll="true" data-suppress-scroll-x="false" data-swipe-easing="false" style="height: 200px">
                            <?php 
                                    $totales = 0;
                                    foreach ($resultadoNivelSocialTotal as $res=>$val){ 
                                        
                                    ?>
                                    <table class="table">
                                    <thead>
                                    <tr>
                                        <th>Grupo - <?= $res ?></th>
                                        <th>Cantidad</th>
                                        
                                    </tr>
                                    </thead>
                                    <?php
                                        foreach($val as $value){
                                            $totales = $totales + $value['cantidad'];
                                    ?>
                                     <tbody>
                                    <tr>
                                        <td><?= $value['estado']?></td>
                                        <td><?= $value['cantidad']?></td>
                                    </tr>
                                    </tbody>

                                    <?php

                                        }
                                    ?>
                                     </table>
                                    <?php
                                     } 
                                    ?>
                                    <table class="table">
                                        <tfoot>
                                            <th>Total general</th>
                                            <th><?= $totales?></th>
                                        </tfoot>
                                    </table>
                        </div>    
                    </div>
                </div>
            </div>

        </div>
    </div><!--End PACIENTES POR NIVELES SOCIOS ECONOMICOS-->
    
    
      
</div><!--End Row-->

<div class="row <?php if(!$grupoIs) { echo "hiden"; } ?>">
    <div class="col-lg-6">
        <div class="rol-index kt-portlet">
            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h1 class="kt-portlet__head-title">Pacientes por Procedimiento</h1>
                </div>
            </div>

            <div class="kt-portlet__body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive" style="height: auto;">
                            <?php 
                                    $totales = 0;
                                    foreach ($resultadoPorProcedimientoTotal as $res=>$val){ 
                                        
                                    ?>
                                    <table class="table">
                                    <thead>
                                    <tr>
                                        <th>Grupo - <?= $res ?></th>
                                        <th>Cantidad</th>
                                        
                                    </tr>
                                    </thead>
                                    <?php
                                        foreach($val as $value){
                                            $totales = $totales + $value['cantidad'];
                                    ?>
                                     <tbody>
                                    <tr>
                                        <td><?= $value['estado']?></td>
                                        <td><?= $value['cantidad']?></td>
                                    </tr>
                                    </tbody>

                                    <?php

                                        }
                                    ?>
                                     </table>
                                    <?php
                                     } 
                                    ?>
                                    <table class="table">
                                        <tbody>
                                            <td>Total general</td>
                                            <td><?= $totales?></td>
                                        </tbody>
                                    </table>
                        </div>    
                    </div>
                </div>
            </div>

        </div>
    </div><!--End PACIENTES POR PROCEDIMIENTOS -->
    <div class="col-lg-6">
        <div class="rol-index kt-portlet">
            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h1 class="kt-portlet__head-title">Pacientes por Procedencia</h1>
                </div>
            </div>
            <div class="kt-portlet__body">
                <div class="row">
                    <div class="col-md-12">
                        <?php $total = 0; ?>
                        <table class="table">
                            <thead>
                                <tr><th>Procedencia</th><th>Total</th></tr>

                            </thead>
                            <tbody>

                                <?php
                                foreach ($resultadoProcedencias as $procedencia) {

                                    $total += $procedencia['cantidad'];
                                    ?>

                                    <tr><td><?= $procedencia['procedencia'] ?></td><td><?= $procedencia['cantidad'] ?></td></tr>

                                <?php } ?>
                            </tbody>
                            <tfoot>

                                <tr><th>Totales</th><th><?= $total ?></th></tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>  

</div>
