<?php

use yii\helpers\Html;
use app\themes\metronic\assets\ChartJsAssets;
use yii\helpers\Url;
use app\themes\metronic\assets\BootstrapDatepickerAssets;
use app\models\Paciente;
use app\customs\Utils;

/* @var $this yii\web\View */
/* @var $resultado array */

$this->title = 'PACIENTES EN ATENCIÓN SEGÚN ESTADO';
$this->params['breadcrumbs'][] = $this->title;

ChartJsAssets::register($this);
BootstrapDatepickerAssets::register($this);


$cantidadesEstadosStr = "";
$labelsEstadoStr = "";
$colorEstadoStr = "";
foreach($resultadoEstados as $grupo){
    
    $labelsEstadoStr .= "'" . Paciente::$estados[$grupo['estado']] . "',";
    $cantidadesEstadosStr .= $grupo['cantidad'] . ",";
    $color = Utils::getColor($grupo['estado'] . $grupo['cantidad']);
    $colorEstadoStr .=  "'rgb(" .$color[0] . "," . $color[1] . "," . $color[2]   . ")',";
}

$cantidadesGruposStr = "";
$labelsGruposStr = "";
$colorGruposStr = "";
foreach($resultadoGrupos as $grupo){
    $labelsGruposStr .= "'" . $grupo['nombre'] . "',";
    $cantidadesGruposStr .= $grupo['cantidad'] . ",";
    $color = Utils::getColor($grupo['nombre'] . $grupo['cantidad']);
    $colorGruposStr .=  "'rgb(" .$color[0] . "," . $color[1] . "," . $color[2]   . ")',";
}

$cantidadesSexosStr = "";
$labelsSexosStr = "";
$colorSexosStr = "";
foreach($resultadoSexos as $res){
    $labelsSexosStr .= "'" . $res['sexo'] . "',";
    $cantidadesSexosStr .= $res['cantidad'] . ",";
    $color = Utils::getColor($res['sexo'] . $res['cantidad']);
    $colorSexosStr .=  "'rgb(" .$color[0] . "," . $color[1] . "," . $color[2]   . ")',";
}

$this->registerJs("
    var dataEstados = {
        datasets: [{
            data: [" . $cantidadesEstadosStr . "],
            backgroundColor:[
                " . $colorEstadoStr . "
            ]
        }],

        // These labels appear in the legend and in the tooltips when hovering different arcs
        labels: [" . $labelsEstadoStr . "]
    };
    
    var dataGrupos = {
        datasets: [{
            data: [" . $cantidadesGruposStr . "],
            backgroundColor:[
                " . $colorGruposStr . "
            ]
        }],

        // These labels appear in the legend and in the tooltips when hovering different arcs
        labels: [" . $labelsGruposStr . "]
    };
    
    var dataSexos = {
        datasets: [{
            data: [" . $cantidadesSexosStr . "],
            backgroundColor:[
                " . $colorSexosStr . "
            ]
        }],

        // These labels appear in the legend and in the tooltips when hovering different arcs
        labels: [" . $labelsSexosStr . "]
    };
    $(document).ready(function(){
        
        
        $('#fechaHasta').datepicker({
            format: 'dd/mm/yyyy'
        });
        
        var ctxEstados = $('canvas.chart-estados');
        var myPieChart = new Chart(ctxEstados, {
            type: 'pie',
            data: dataEstados
        });
        
        var ctxGrupos = $('canvas.chart-grupos');
        var myPieChartGrupos = new Chart(ctxGrupos, {
            type: 'pie',
            data: dataGrupos
        });
        

        var ctxSexos = $('canvas.chart-sexos');
        var myPieChartSexos = new Chart(ctxSexos, {
            type: 'pie',
            data: dataSexos
        });
    });
    

");

$fechaHastaFormato = date('d/m/Y' , strtotime($fechaHasta));
?>
<div class="rol-index kt-portlet">
    <div class="kt-portlet__body">
        <div class="row">
            <div class="col-md-12">
                <form method="post"  class="form-inline" action="<?= Url::to(['reportes/pacientes-unis'])?>">
                  <input type="hidden" name="_csrf" value="<?=Yii::$app->request->getCsrfToken()?>" />
                  <div class="form-group p-3">
                      <label for="idGrupo">Elegir Grupo: </label>
                      <?= Html::dropDownList('idGrupo',$idGrupo,$grupos,['class' => 'form-control form-control-sm'])?>
                  </div>
                  <div class="form-group p-3">
                      <label for="fechaHasta">Ver hasta: </label>
                      <input type="text" style="width: 100px;" class="form-control form-control-sm" id="fechaHasta" name="fechaHasta" placeholder="Fecha hasta" value="<?= $fechaHastaFormato ?>" />
                  </div>
                  <button type="submit" class="btn btn-success d-none d-md-block">Filtrar</button>
                  <button type="submit" class="btn btn-success btn-block btn-sm d-md-none p-3 ">Filtrar</button>
                </form>  
            </div>
        </div>
         <div class="row text-right d-md-none d-none">
            <div class="offset-8 col-md-4">
                <span id="badge-periodo" style="font-size: 14px;" class="kt-badge kt-badge--brand kt-badge--inline kt-badge--pill kt-badge--rounded">
                    <b>Filtro:</b>&nbsp; hasta el <?= $fechaHastaFormato ?>
                </span>
            </div>    
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-4">
        <div class="rol-index kt-portlet">

            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h1 class="kt-portlet__head-title">Pacientes Totales</h1>
                </div>
            </div>

            <div class="kt-portlet__body">
                <div class="row">
                    <div class="col-1"></div>
                    <div class="col-10">
                        <div id="pacientes-chart-container">   
                            <canvas class="chart-grupos" height="400" width="400"></canvas>
                        </div>
                    </div>
                    <div class="col-1"></div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive" style="height: 200px;">
                            <table class="table">
                                <thead>
                                    <th>ÁREA</th>
                                    <th>CANTIDAD</th>
                                </thead>
                                <tbody>
                                    <?php 
                                    $totales = 0;
                                    foreach ($resultadoGrupos as $grupo){ 
                                        $totales += intval($grupo['cantidad']);
                                    ?>
                                    <tr>
                                        <td><?= $grupo['nombre']?></td>
                                        <td><?= $grupo['cantidad']?></td>
                                    </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <th>Total general</th>
                                    <th><?= $totales?></th>
                                </tfoot>
                            </table>
                        </div>    
                    </div>
                </div>
            </div>

        </div>
    </div><!--End col-->
    
    <div class="col-lg-4">
        <div class="rol-index kt-portlet">
            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h1 class="kt-portlet__head-title">Pacientes según Estado</h1>
                </div>
            </div>
            <div class="kt-portlet__body">
                <div class="row">
                    <div class="col-1"></div>
                    <div class="col-10">
                        <div id="pacientes-chart-container">   
                            <canvas class="chart-estados" height="300" width="300"></canvas>
                        </div>
                    </div>
                    <div class="col-1"></div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive" style="height: 200px;">
                            <table class="table">
                                <thead>
                                <th>ÁREA</th>
                                <th>CANTIDAD</th>
                                </thead>
                                <tbody>
                                    <?php
                                    $totales = 0;
                                    foreach ($resultadoEstados as $grupo) {
                                        $totales += intval($grupo['cantidad']);
                                        ?>
                                        <tr>
                                            <td><?= Paciente::$estados[$grupo['estado']] ?></td>
                                            <td><?= $grupo['cantidad'] ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                <th>Total general</th>
                                <th><?= $totales ?></th>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <div class="rol-index kt-portlet">
            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h1 class="kt-portlet__head-title">Pacientes según Sexo</h1>
                </div>
            </div>
            <div class="kt-portlet__body">
                <div class="row">
                    <div class="col-1"></div>
                    <div class="col-10">
                        <div id="pacientes-chart-container">   
                            <canvas class="chart-sexos" height="400" width="400"></canvas>
                        </div>

                    </div>
                    <div class="col-1"></div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive" style="height: 200px;">
                            <table class="table">
                                <thead>
                                    <th>ÁREA</th>
                                    <th>CANTIDAD</th>
                                </thead>
                                <tbody>
                                    <?php 
                                    $totales = 0;
                                    foreach ($resultadoSexos as $res){ 
                                        $totales += intval($res['cantidad']);

                                    ?>
                                    <tr>
                                        <td><?= $res['sexo']?></td>
                                        <td><?= $res['cantidad']?></td>
                                    </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <th>Total general</th>
                                    <th><?= $totales?></th>
                                </tfoot>
                            </table>
                        </div>    
                    </div>
                </div>
            </div>
        </div>
    </div><!--End col-->   
</div><!--End Row-->

<div class="row">
    <div class="col-lg-6">
        <div class="rol-index kt-portlet">
            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h1 class="kt-portlet__head-title">Pacientes por Procedencia</h1>
                </div>
            </div>
            <div class="kt-portlet__body">
                <div class="row">
                    <div class="col-md-12">
                        <?php $total = 0; ?>
                        <table class="table">
                            <thead>
                                <tr><th>Procedencia</th><th>Total</th></tr>

                            </thead>
                            <tbody>

                                <?php
                                foreach ($resultadoProcedencias as $procedencia) {

                                    $total += $procedencia['cantidad'];
                                    ?>

                                    <tr><td><?= $procedencia['procedencia'] ?></td><td><?= $procedencia['cantidad'] ?></td></tr>

                                <?php } ?>
                            </tbody>
                            <tfoot>

                                <tr><th>Totales</th><th><?= $total ?></th></tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>  
</div>
