<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use app\assets\RecordatorioDoctorAsset;
use app\models\Usuario;
use app\models\Paciente;
/* @var $this yii\web\View */
/* @var $model app\models\RecordatorioDoctor */
/* @var $usuario app\models\Usuario */
/* @var $form yii\widgets\ActiveForm */

RecordatorioDoctorAsset::register($this);
$privacidad = [0 => 'público', 1 => 'privado'];
$nombrePaciente = $model->isNewRecord ? ((isset($paciente) && !$paciente->isNewRecord) ? $paciente->nombreCompleto : '') 
        : ( (boolval($model->es_paciente) && !$model->isNewRecord ) 
            ? Paciente::findOne($model->id_paciente)->nombreCompleto : ''  );
$clasePaciente = ($model->isNewRecord ? '' : (empty($nombrePaciente) ? '' : ' cuadro-lleno') );
$usuario = Yii::$app->user->identity;

if($usuario->tipo == Usuario::ASISTENTE){
    $model->privacidad = 0;
}
?>
<script type="text/javascript">
    var showPacienteField = <?= $pacienteField ?>;
</script>
<?php $form = ActiveForm::begin(['options' => ['class' => 'kt-form', 'autocomplete' => 'off']]); ?>
    <div class="nota-form kt-portlet__body">
        <div class="row">
            <div class="col-lg-2 col-md-2">
                <?php if($usuario->tipo == app\models\Usuario::DOCTOR){ ?>
                <?= $form->field($model, 'privacidad')->radioList($privacidad) ?>
                <?php }else{ ?>
                <?= $form->field($model, 'privacidad')->hiddenInput()->label(false) ?>
                <?php } ?>
            </div>
            <div class="col-lg-2 col-md-2">
                <label class="form-label">¿Todo el día?</label>
                <?= $form->field($model, 'todo_dia')->checkbox(['label' => null]) ?>
            </div>
            <div class="col-lg-4">
                <?= $form->field($model, 'fecha_inicio')->textInput() ?>
            </div>
            <div class="col-lg-4">
                <?= $form->field($model, 'asunto')->textInput(['maxlength' => true]) ?>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-6">
                <?= $form->field($model, 'comentarios')->textInput(['maxlength' => true]) ?>
            </div>
            <div class="col-lg-2 col-md-2">     
                <label class="form-label">¿Agregar a un paciente?</label>
                <?= $form->field($model, 'es_paciente')->checkbox(['label' => null]) ?>
            </div>
            <div class="col-lg-4 col-md-4 paciente">
                <label class="control-label" for="pacienteAutocomplete">Paciente</label>
                <?= Html::textInput('pacienteAutocomplete', $nombrePaciente, ['id' => 'pacienteAutocomplete', 'class' => 'form-control' . $clasePaciente]) ?>
                <?= $form->field($model, 'id_paciente')->hiddenInput()->label(false) ?>
            </div>
        </div>
    </div>
    <div class="kt-portlet__foot">
        <div class="form-group kt-form__actions">
            <?= Html::submitButton('Guardar', ['class' => 'btn btn-success']) ?>
        </div>
    </div>
<?php ActiveForm::end(); ?>