<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model app\models\Producto */
/* @var $form yii\widgets\ActiveForm */
?>

<?php $form = ActiveForm::begin(['options' => ['class' => 'kt-form']]); ?>
<div class="producto-form kt-portlet__body">
    <div class="row">
        <div class="col-lg-3">
            <?= $form->field($model, 'codigo')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-6">
            <?= $form->field($model, 'nombre')->textInput(['maxlength' => true]) ?>
            <?= $form->field($model, 'id_proveedor')->dropDownList($proveedores) ?>
        </div>
        <div class="col-lg-6">
            <?= $form->field($model, 'descripcion')->textarea(['maxlength' => true, 'rows'=>6]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-4">
            <?= $form->field($model, 'id_categoria')->dropDownList($categorias) ?>
        </div>
        <div class="col-lg-4">
            <?= $form->field($model, 'id_unidad_medida')->dropDownList($unidades) ?>
        </div>
        <div class="col-lg-4">
            <?= $form->field($model, 'costo')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-4">
            <?= $form->field($model, 'activo')->checkbox() ?>
        </div>
    </div>
</div>
<div class="kt-portlet__foot">
    <div class="form-group kt-form__actions">
        <?= Html::submitButton('Guardar', ['class' => 'btn btn-success']) ?>
    </div>
</div>
<?php ActiveForm::end(); ?>