<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Planes';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="plan-index kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
    </div>
    <div class="kt-portlet__body">
        <p>
            <?= Html::a('Crear Plan', ['create'], ['class' => 'btn btn-success']) ?>
        </p>

        
            <?= GridView::widget([
            'dataProvider' => $dataProvider,
            'summary' => 'Mostrando {begin} - {end} de {totalCount} ítems',
            'columns' => [
                ['class' => 'yii\grid\SerialColumn'],

                'nombre',
                'precio',
                'precio_cita',
                'stripe_id',
                [
                    'label'=>'Tipo',
                    'value' => function($model){
                        return $model->textoTipo;
                    }
                ],
                'activo:boolean',
                ['class' => 'app\customs\ActionColumn'],
            ],
        ]); ?>
    
    
    </div>
</div>
