<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use yii\widgets\ActiveForm;
use app\assets\PermisosAsset;

/* @var $this yii\web\View */
/* @var $model app\models\Rol */
PermisosAsset::register($this);
$this->title = 'Permisos para '.$model->nombre;
$this->params['breadcrumbs'][] = ['label' => 'Roles', 'url' => ['rol/index']];
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="col-md-12 kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
    </div>
    <div class="box box-primary kt-portlet__body">
        <div class="rol-view">

        <div class="box-body">
            <?= DetailView::widget([
                'model' => $model,
                'attributes' => [
                    'nombre',
                    'descripcion',
                    [
                        'attribute' => 'activo',
                        'value' => ($model->activo==1? "Si" : "No" ),
                    ],
                ],
            ]) ?>
            <?php $form=ActiveForm::begin(['options' => ['class' => 'kt-form kt-form--label-right']]); ?>
            <h2>Permisos</h2>
            <table  class="table table-striped">
                <tr>
                    <th></th>
                    <th>Nombre</th>
                    <th>Grupo</th>
                    <th>Descripción</th>
                </tr>
            <?php

                 foreach($controladores as $controlador){
                    $total=$controlador->getPermisionCount($model->id);
                    echo '<tr class="controller '.$controlador->nombre.'">';
                    echo '<td><input class="main-checkbox" type="checkbox" value="'
                        .$controlador->nombre.'" '.($total > 0 ?'checked="checke"':'').'/>'
                        . '&nbsp;<span class="totales" id="total|'.$controlador->nombre.'"><span></td>';
                    echo '<td class="ck abierto" colspan="2">';
                    echo $controlador->nombre_amigable.'</td><td class="ck abierto" >'.$controlador->descripcion.'</td></tr>';
                    $acciones=$controlador->acciones;

                    foreach($acciones as $accion){
                        echo '<tr class="action '.$controlador->nombre.'"><td></td>';
                        echo '<td><input class="sec-checkbox" name="permisos[]" type="checkbox" ';
                        echo (in_array($accion->id,$permisos)?'checked="checked" ':'').' value="'.$accion->id.'" /></td>';
                        echo '<td>'.$accion->nombre_amigable.'</td><td>'.$accion->descripcion.'</td></tr>';
                    }
                 }

             ?>
            </table>
            <div class="box-footer">
                <div class="form-group">
                    <?= Html::submitButton('Guardar', ['class' => 'btn btn-primary']) ?>
                </div>
            </div>
            <?php 

                ActiveForm::end();
            ?>
        </div>
        </div>
    </div>
</div>

