<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Pais';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="pais-index kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
    </div>
    <div class="kt-portlet__body">
        <p>
            <?= Html::a('Crear Pais', ['create'], ['class' => 'btn btn-success']) ?>
        </p>
            
            <?= GridView::widget([
            'dataProvider' => $dataProvider,
            'summary' => 'Mostrando {begin} - {end} de {totalCount} ítems',
            'filterModel' => $searchModel,
            'columns' => [
                'iso',
                'nombre',
                'moneda',
                'simbolo',
                ['class' => 'app\customs\ActionColumn'],
            ],
        ]); ?>
    
    
    </div>
</div>
