<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\helpers\Url;
use app\assets\PacienteIndexAsset;

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */
/* @var $usuario app\models\Usuario */

PacienteIndexAsset::register($this);
$this->title = 'Pacientes';
$this->params['breadcrumbs'][] = $this->title;
$usuario = Yii::$app->user->identity;
?>
<style>
    th { font-size: 16px; }
    td { font-size: 14px; }
    
    .trpointer{
        cursor:pointer !important;
    }
</style>
<div class="paciente-index kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
        <p class="d-none d-md-block mt-2">
            <?= Html::a('Duplicados', ['duplicados'], ['class' => 'btn btn btn-dark my-4 mb-2']) ?>
            <?= Html::a('Crear Paciente', ['create'], ['class' => 'btn btn-success']) ?>
            <?= Html::a('<i class="flaticon-download-1"></i>Descargar Excel', ['reportes/pacientes-xls'], ['class' => 'btn btn-dark my-4 mb-2']) ?>
        </p>
        <div class="d-md-none">
            <div class="btn-group">
                <button type="button" class="btn btn-secondary dropdown-toggle mt-2" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="margin-left: 0 !important;">
                    Opciones
                </button>
                <div class="dropdown-menu dropdown-menu-left">
                    <?= Html::a('Crear Paciente', ['create'], ['class' => 'dropdown-item']) ?>
                    <div class="dropdown-divider"></div>
                    <?= Html::a('Descargar Excel', ['reportes/pacientes-xls'], ['class' => 'dropdown-item']) ?>
                </div>
            </div>
        </div>
    </div>
    <div class="kt-portlet__body">
        <div class="table-responsive">
            <table class="table table-hover" id="pacientes">
                <thead>
                    <tr>
                        <th>Código</th>
                        <th>Nombre</th>
                        <th>Apellido</th>
                        <th>Email</th>
                        <th>Teléfono Fijo</th>
                        <th>Celular</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
            </table>

        </div>
 
<?php 
$this->registerJs("
    $('tbody td:not(.disable-click)').css('cursor', 'pointer');
    $(document).on('click','table tr td:not(.disable-click)',function(e) {      
        var id = $(this).closest('tr').data('id');
        if (e.target == this && id)
            location.href = '" . Url::to(['/paciente/view']) . "?id=' + id;
    });
    ");
?>
    </div>
</div>
