<?php

use yii\helpers\Html;
use app\assets\PacientesDuplicadoAsset;
/* @var $this yii\web\View */
/* @var $pacientes app\models\Paciente[] */
/* @var $usuario app\models\Usuario */

$this->title = 'Pacientes duplicados';
$this->params['breadcrumbs'][] = $this->title;
$usuario = Yii::$app->user->identity;

PacientesDuplicadoAsset::register($this);
?>
<div class="paciente-index kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
    </div>
    
    <div class="kt-portlet__body">
        <div class="kt-portlet__content">
            <p class="text-primary">
                Arraste un contacto sobre otro para unir.
            </p>
        </div>
    </div>
</div>



<div class="row ui-sortable" id="kt_sortable_portlets">
    
    <?php foreach ($pacientes as $paciente){ ?>
    <div class="col-lg-6">

        <!--begin::Portlet-->
        <div class="kt-portlet kt-portlet--mobile kt-portlet--sortable kt-portlet--collapsed ficha-paciente" data-ktportlet="true" data-id="<?= $paciente->id?>" id="paciente-<?= $paciente->id?>">
            <div class="kt-portlet__head ui-sortable-handle">
                <div class="kt-portlet__head-label ">
                    <h3 class="kt-portlet__head-title">
                        <?= $paciente->nombreCompleto?>
                    </h3>
                </div>
                <div class="kt-portlet__head-toolbar">
                    <div class="kt-portlet__head-group">
                        <a href="javascript:void(0);" class="abrir-ficha-paciente btn btn-sm btn-primary"><i class="fa fa-plus"></i> Expandir</a>

                        <a href="javascript:void(0);" data-ktportlet-tool="remove" class="btn btn-sm btn-icon btn-warning btn-icon-md"><i class="la la-close"></i></a>
                    </div>
                </div>
            </div>
            <div class="kt-portlet__body">
                <div class="kt-portlet__content">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Email:</label>
                                <input class="form-control" readonly="readonly" value="<?= $paciente->email?>" />
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Teléfono:</label>
                                <input class="form-control" readonly="readonly" value="<?= $paciente->telefono_fijo?>" />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Celular:</label>
                                <input class="form-control" readonly="readonly" value="<?= $paciente->celular?>" />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Dirección:</label>
                                <input class="form-control" readonly="readonly" value="<?= $paciente->direccion?>" />
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php } ?>
</div>



<!-- Modal -->
<div class="modal fade" id="dialog-union-pacientes" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="myModalLabel">Unir pacientes</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label">Nombre:</label>
                            <input id="p1-nombreCompleto" class="form-control" readonly="readonly" value="" />
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label">Email:</label>
                            <input id="p1-email" class="form-control" readonly="readonly" value="" />
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label">Teléfono:</label>
                            <input id="p1-telefono_fijo" class="form-control" readonly="readonly" value="" />
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label">Celular:</label>
                            <input id="p1-celular" class="form-control" readonly="readonly" value="" />
                        </div>
                    </div>
                    <div class="col-md-12" style="display:none;">
                        <div class="form-group">
                            <label class="form-label">Dirección:</label>
                            <input id="p1-direccion" class="form-control" readonly="readonly" value="" />
                        </div>
                    </div>
                </div>
                <hr/>
                <div class="row">
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label">Nombre:</label>
                            <input id="p2-nombreCompleto" class="form-control" readonly="readonly" value="" />
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label">Email:</label>
                            <input id="p2-email" class="form-control" readonly="readonly" value="" />
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label">Teléfono:</label>
                            <input id="p2-telefono_fijo" class="form-control" readonly="readonly" value="" />
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label">Celular:</label>
                            <input id="p2-celular" class="form-control" readonly="readonly" value="" />
                        </div>
                    </div>
                    <div class="col-md-12" style="display:none;">
                        <div class="form-group">
                            <label class="form-label">Dirección:</label>
                            <input id="p2-direccion" class="form-control" readonly="readonly" value="" />
                        </div>
                    </div>
                </div>
                
        </div>
            <div class="modal-footer">
                <button id="btn-cancelar" type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
                <button id="btn-unir" type="button" class="btn btn-primary">Unir</button>
            </div>
        </div>
    </div>
</div>