<?php

use yii\helpers\Url;
use app\models\ProcedimientoCita;
use app\assets\ViewAdjuntoAsset;
use app\assets\ViewPacienteAsset;
use app\models\Cita;
use app\models\Suscripcion;
use kartik\file\FileInputAsset;
use app\assets\FileInputEsAsset;
use app\customs\QuiiEditorConf;
use bizley\quill\assets\QuillAsset;

/* @var $this yii\web\View */
/* @var $model app\models\Paciente */

$this->title = $model->nombre." ".$model->apellido;
$this->params['breadcrumbs'][] = ['label' => 'Pacientes', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
ViewAdjuntoAsset::register($this);
FileInputAsset::register($this);
FileInputEsAsset::register($this);
ViewPacienteAsset::register($this);
QuillAsset::register($this);

$boolCobroPasarela = \boolval( $pagadito->cobrar_pasarela );

if($model->ultimaCita != null){
    $procedimiento_cita_array=ProcedimientoCita::find()->where(['id_cita' => $model->ultimaCita->id])->all();
}
$classPill = '';
?>
<script>
    var hoy = '<?= date('d/m/Y');?>';
    var tipoUsuario = '<?= $tipo_usuario?>'-0;
    var tipoSuscripcion = '<?= $tipo_suscripcion?>'-0;
    var clinicaSeleccionada = '<?= $clinica_seleccionada;?>';
    var configInfoReceta = '<?=$confInfoRecetas?>';
    var _homeUrl = '<?=Yii::$app->homeUrl?>';
    var id_cita = '<?= $id_cita != null ? $id_cita : 0 ?>'-0;
    var id_paciente = '<?=$model->id?>';
    const URL_SERVER = '<?=Yii::$app->params['urlAplicacion']?>';
    const TIPO_COBRO = '<?=$pagadito->tipo?>'-0;
    const boolCobroPasarela = '<?=$boolCobroPasarela ? 1 : 0 ?>'-0 === 0 ? false : true;
    const porcentajePasarela = '<?=$pagadito->monto_porcentual > 0 ? $pagadito->monto_porcentual : 0 ?>'-0 / 100;
    const montoPasarela = '<?=$pagadito->monto_fijo > 0 ? $pagadito->monto_fijo : 0 ?>'-0 / 100;
</script>
<div class="evento-view  kt-grid__item kt-grid__item--fluid" id="kt_content_evento">
    <div class="row" style="text-shadow: none;">
        <div class="col-xl-12" style="text-shadow: none;">
            <!--begin:: Widgets/Applications/User/Profile3-->
            <div class="kt-portlet kt-portlet--height-fluid" style="text-shadow: none;">
                <div class="kt-portlet__body" style="text-shadow: none;">
                    <div class="kt-widget kt-widget--user-profile-3" style="text-shadow: none;">
                        <div class="kt-widget__top" style="text-shadow: none;">
                            <div class="kt-widget__content">
                                <div class="kt-widget__head">
                                    <p>
                                        <a href="#" class="kt-portlet__head-title" style="margin-left: -20px;font-size: 1.8rem; 
                                           font-weight:500; color: #464457; ">
                                           <?=$model->nombre.' '.$model->apellido?>
                                        </a>
                                    </p>
                                    <div class="paciente-head-container">
                                        <?php if( $tipo_suscripcion == Suscripcion::TIPO_JERARQUIZADA ): ?>
                                            <?=$model->getDropdownEstados($tipoUsuarioJerarquia)?>
                                        <?php endif; ?>
                                        <div class="dropdown">
                                            <button class="btn btn-success dropdown-toggle" type="button" id="agregar-dropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                Agregar
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="agregar-dropdown">
                                                <a class="dropdown-item" href="<?= Url::to(['cita/create','pid' => $model->id]) ?>"><span class="flaticon2-plus kt-font-success mr-2"></span> Agregar Cita</a>
                                                <a class="dropdown-item crear-seguimiento-pac" href="javascript:void(0);"><span class="flaticon2-plus kt-font-success mr-2"></span> Seguimiento</a>
                                            </div>
                                        </div>
                                        <p class="bnt-modales-pacientes d-none d-md-block">
                                            <a id="btn-modal-seg-1" class="btn btn-primary btn-sm btn-upper mt-3" href="#" data-toggle="modal" data-target="#seguimientos-paciente" style="display: none; padding: 9px 10px;"><i class="la la-retweet"></i>Ver Seguimientos</a>
                                            <a href="#" class="btn btn-primary btn-sm btn-upper flaticon-eye mt-3" style="padding: 9px 10px;" id="ver" data-toggle="modal" data-target="#paciente-info"> Ver Paciente  </a>

                                        </p>
                                        <div class="d-md-none">
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-secondary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="margin-left: 0 !important;">
                                                    Opciones
                                                </button>
                                                <div class="dropdown-menu">
                                                    <a  href="#" class="dropdown-item" id="ver" data-toggle="modal" data-target="#paciente-info"><i class="la la-eye kt-font-primary mt-2"></i> Ver Paciente  </a>
                                                    <div class="dropdown-divider"></div>
                                                    <a  id="btn-modal-seg" class="dropdown-item" href="#" data-toggle="modal" data-target="#seguimientos-paciente" style="display: none;"><i class="la la-retweet kt-font-primary mt-2"></i>Ver Seguimientos</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div> 
                                </div>
                            </div>
                        </div>
                        <hr>

                        <div class="kt-widget kt-widget--user-profile-3" style="text-shadow: none;">
                                <div class="row" style="margin-top: -30px;">
                                    <div class="col-lg-8" >
                                        <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>
                                        <div class="kt-widget1 kt-widget1--fit">
                                            <div class="kt-widget1__item">
                                                <div class="kt-widget1__info">
                                                    <h3 class="kt-widget1__title">Primera cita: <strong><?=$model->primeraCita == null ? 'No definido' : $model->primeraCita->fecha?></strong></h3>
                                                </div>
                                            </div>
                                            <div class="kt-widget1__item">
                                                <div class="kt-widget1__info">
                                                    <h3 class="kt-widget1__title">Observaciones:</h3>
                                                    <span class="kt-widget1__desc" >
                                                        <?= ($model->notas == NULL) ? "(No definido)": $model->notas ?>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4" >
                                        <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>
                                        <div class="kt-widget1 kt-widget1--fit">
                                            <div class="kt-widget1__item">
                                                <div class="kt-widget1__info">
                                                    <h3 class="kt-widget1__title">Proxima cita: <strong><?=$model->citaProxima == null ? 'No hay cita' : $model->citaProxima->fecha ?></strong></h3>
                                                </div>
                                            </div>
                                            <div class="kt-widget1__item">
                                                <div class="kt-widget1__info">
                                                    <h3 class="kt-widget1__title">Edad: <strong><?=$model->edad?></strong></h3>
                                                </div>
                                            </div>
                                            <div class="kt-widget1__item"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <hr>
                    </div>
                </div>
            </div>
            <!--end:: Widgets/Applications/User/Profile3-->
        </div>
    </div>
</div>


<div class="evento-view  kt-grid__item kt-grid__item--fluid">
    <div class="row">
        <div class="col-lg-3">
            <div class="kt-portlet">
                <div class="kt-portlet__body">
                    <div class="kt-infobox">
                        <div class="kt-infobox__header">
                            <h3 class="kt-infobox__title">Historial Citas                                
                                <span class="kt-badge kt-badge--unified-brand kt-badge--lg kt-badge--rounded kt-badge--bold" data-toggle="kt-tooltip" title="" data-html="true" data-original-title="<div class='text-justify'>Estados de Cita<br><span class='kt-badge kt-badge--primary kt-badge--dot kt-badge--lg'></span>&nbsp;Pendiente<br><span class='kt-badge kt-badge--success kt-badge--dot kt-badge--lg'></span>&nbsp;Completa<br><span class='kt-badge kt-badge--danger kt-badge--dot kt-badge--lg'></span>&nbsp;Cancelada<br><span class='kt-badge kt-badge--ligth kt-badge--dot kt-badge--lg'></span>&nbsp;Inasistencia<br><span class='kt-badge kt-badge--warning kt-badge--dot kt-badge--lg'></span>&nbsp;Confrimar<br>&nbsp;&nbsp;&nbsp;&nbsp;asistencia</div>">
                                    <i class="la la-info"></i>
                                </span>
                            </h3>
                        </div>
                        <div class="kt-infobox__body">
                            <hr>
                            <div class="kt-infobox__section">
                                <div class="kt-infobox__content">
                                    <div class="kt-list-timeline">
                                        <div class="kt-scroll" data-scroll="true" data-mobile-height="150" data-height="200" style="overflow-y: scroll; height: 200px;">
                                            <div class="kt-list-timeline__items scrollarea-content" id="items-fecha">
                                                <?php if(!empty($model->historicoCitas)){?>
                                                    <?php foreach($model->historicoCitas as $k => $cita):?>
                                                    <?php if(strtotime($cita->fechaDB)> time() && $cita->estado < Cita::CANCELADA  ){ 
                                                       $classPill = 'kt-list-timeline__badge--primary';
                                                    }else{  
                                                        $classPill = $cita->estado == Cita::CANCELADA ? 'kt-list-timeline__badge--danger' 
                                                            : ($cita->estado == Cita::COMPLETADA ? 'kt-list-timeline__badge--success' 
                                                                :($cita->estado == Cita::INASISTENCIA ? 'kt-list-timeline__badge--secondary' 
                                                                    :((strtotime($cita->fechaDB) < time() && $cita->estado < Cita::CANCELADA ) ? 'kt-list-timeline__badge--warning' : 'kt-list-timeline__badge--primary' ))) ?> 
                                                    <?php } ?>
                                                    <div class="kt-list-timeline__item">
                                                        <span class="kt-list-timeline__badge <?=$classPill?>"></span>
                                                        <span class="kt-list-timeline__text text-center cita-lista-el" style="cursor: pointer;" id="<?=$cita->id?>" data-key="<?=$k?>"><?=$cita->fecha?></span>
                                                    </div>
                                                    <?php endforeach;?>
                                                <?php }else{?>
                                                    <div class="kt-list-timeline__item">
                                                        <span class="kt-list-timeline__badge kt-list-timeline__badge--secondary"></span>
                                                        <span class="kt-list-timeline__text text-center cita-lista-el" style="cursor: pointer;" id="0" >No hay citas para mostrar!</span>
                                                    </div>
                                                <?php }?>
                                            </div>                                                    
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- fin de lista de fechas citas -->
            <div class="kt-portlet">
                <div class="kt-portlet__body">
                    <div class="kt-infobox">
                        <div class="kt-infobox__header">
                            <h3 class="kt-infobox__title">Historial Médico</h3>
                        </div>
                        <div class="kt-infobox__body">
                            <hr>
                            <div class="kt-infobox__section">
                                <div class="kt-infobox__content">
                                    <div class="kt-list-timeline">
                                        <div class="kt-scroll" data-scroll="true" data-mobile-height="150" data-height="200" style="overflow-y: scroll; height: 200px;">
                                            <div class="kt-list-timeline__items scrollarea-content" id="items-fecha-historial">

                                            </div>                                                    
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- fin de lista de fechas historiales -->
        </div>
        <div class="col-lg-9">
            <div class="kt-portlet">
                <div class="row">
                    <div class="col-md-7">
                        <div class="kt-portlet__body">
                            <div class="kt-infobox kt-infobox--success">
                                <div class="kt-infobox__body">
                                    <div class="kt-infobox__section">
                                        <div class="kt-infobox__content">
                                            <div class="kt-infobox__header">
                                                <h3 class="kt-infobox__title">Historial Médico</h3>
                                            </div>
                                            <hr>
                                                <button 
                                                    style="margin-right: 2px; font-size: 0.7rem;" 
                                                    id="nuevo-historial" 
                                                    class="btn btn-success btn-sm btn-upper flaticon2-plus mt-4"
                                                >&nbsp;Récord
                                                </button>
                                                <button 
                                                    style="margin-right: 2px; font-size: 0.7rem;" 
                                                    id="new-receta" 
                                                    class="btn btn-success btn-sm btn-upper flaticon2-plus mt-4"
                                                >&nbsp;Receta
                                                </button>
                                                <button 
                                                    style="margin-right: 2px; font-size: 0.7rem;" 
                                                    data-toggle="modal" 
                                                    data-target="#documento-paciente-modal"
                                                    class="btn btn-success btn-sm btn-upper flaticon2-plus mt-4"
                                                >&nbsp;Documento
                                                </button>
                                            <div class="kt-scroll scrollarea-invalid" data-scroll="true" data-mobile-height="300" data-height="500">
                                                <div class="scrollarea-content" id="historiales-paciente" style="margin-left: -7px">

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="kt-portlet__body">
                            <div class="kt-infobox kt-infobox--success">
                                <div class="kt-infobox__body">
                                    <div class="kt-infobox__section">
                                        <div class="kt-infobox__content">
                                            <div class="kt-infobox__header">
                                                <h3 class="kt-infobox__title" id="fecha-label"></h3>
                                            </div>
                                            <hr>
                                            <div id="cita-view"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="row">
        <div class="col-lg-9 offset-3">
            <div class="kt-portlet">
                <div class="kt-portlet__body">
                    <div class="kt-infobox">
                        <div class="kt-infobox__header">
                            <h3 class="kt-infobox__title">Documentos Adjuntos</h3>
                        </div>
                        <div class="kt-infobox__body">
                            <hr>
                            <div class="kt-infobox__section">
                                <div class="kt-infobox__content">
                                    <div class="kt-list-timeline">
                                        <div class="kt-scroll" id="sec-documentos-scroll" data-scroll="true" data-mobile-height="250" data-height="350" style="overflow-y: scroll; height: 200px;">
                                            <div class="row ml-2 mr-2 scrollarea-content" id="sec-documentos"  style="display: none;">

                                            </div>
                                        </div>
                                        <div class="diagnostico" id="docs-vacio-msg" style="display:none;">
                                            <div class="diagnostico-fecha text-right"></div>
                                            <div class="diagnostico-box">
                                                No existen documentos en la fecha que estás buscando.
                                                Filtra nuevamente en las fechas del recuardo: “Historial Médico”...
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" role="dialog" aria-hidden="true" id="view-imagen">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title title mt-2" id="title"></h5><span class="kt-badge kt-badge--brand kt-badge--lg title ml-2" id="edit-title"><i class="far fa-edit" style="font-size: 20px;"></i></span>
                    <textarea cols="2" rows="1" class="col-sm-3 col-md-6 form-control edit-title" id="descripcion" name="descripcion"></textarea>
                    <span class="kt-badge kt-badge--danger kt-badge--lg edit-title ml-2 mr-2" id="close-edit"><i class="far fa-times-circle" style="font-size: 20px;"></i></span>
                    <span class="kt-badge kt-badge--success kt-badge--lg edit-title mr-2" id="guardar"><i class="far fa-save" style="font-size: 20px;"></i></span>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="view-modal-body">
                <div id="post-slide" class="post-slide">
                    <div class="circle-prev">
                        <i class="flaticon2-fast-back navigation-btn prev" id="prev"></i>
                    </div>
                    <div class="circle-next">
                        <i class="flaticon2-fast-next navigation-btn next" id="next"></i>
                    </div>
                    <div class="circle-delete">
                        <i class="fa fa-trash-alt delete" id="eliminar-adjunto"></i>
                    </div>
                    <div class="circle-download" id="descargar-adjunto">
                        <a href="" id="url-adjunto" download=""><i class="fa fa-download download"></i></a>
                    </div>
                    <img id="img-view" src="" width="100%" alt="...">
                </div>    
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div><!-- /.modal -->

<div id="paciente-info" class="modal fade">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title"><?='Paciente - ' . $model->nombreCompleto?></h4>
                <button data-dismiss="modal" class="close"></button>
            </div>
            <div class="modal-body">
                <div class="container">
                    <?= $this->render('_datos-paciente',['model'=>$model,'procedimiento_cita_array'=>isset($procedimiento_cita_array) ? $procedimiento_cita_array : null ])?>
                </div>    
            </div>
            <div class="modal-footer">
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<div id="confirmarCitaModal" class="modal fade">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Confirmar</h4>
                <button class="close"></button>
            </div>
            <div class="modal-body">
                <p>¿El paciente asistió a su cita?</p>
            </div>
            <div class="modal-footer">
                <button id="btn-confirmarCitaModalNo" class="btn btn-sm btn-default">No</button>
                <button id="btn-confirmarCitaModalYes" class="btn btn-sm btn-primary">Si</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->


<div id="seguimientosModal" class="modal-seg">
    <div class="modal-contenido">
        <div class="modal-head">
          <h4 class="title-mod" id="segTitulo"></h4> 
          <span id="closeModalSeg" class="close">&times;</span>
        </div>
      <div id="segCuerpo"></div>
    </div>
</div>  


<div id="seguimientos-paciente" class="modal fade">
    <div class="modal-dialog modal-md">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="pseg-title"></h4>
                <button data-dismiss="modal" class="close"></button>
            </div>
            <div class="modal-body" id="cuerpo">
                <div id="desc" class="description"></div>
                <div class="kt-list-timeline">
                    <div class="kt-list-timeline__items" id="kt-list-items">
                    </div>
                </div>
            </div>
            <div class="modal-footer" id="foot">
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<div id="pd-modal" class="modal fade">
    <div class="modal-dialog modal-dialog-top modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="tituloPD"></h4>
                <button class="close" data-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="bodyPD">
                <div class="container">
                    <div class="row" id="campos">
                        <div class="col-md-6">
                            <div class="form-group required">
                                <label class="control-label" for="plantillas">Seleccione una plantilla</label>
                                <select id="plantillas" name="plantillas" class="form-control" title="Seleccione una plantilla">
                                    <option value="" >-Seleccione una plantilla-</option>
                                    <?php
                                    foreach ($plantillasDiagnostico as $plantilla) {
                                        echo "<option value='$plantilla->id' >"."$plantilla->titulo</option>";
                                    }
                                    ?>
                                </select>
                                <input type="hidden" id="id_historial">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label>Fecha</label><span style="color: red;"> *</span>
                            <input id="fecha_historial" name="fecha-historial" class="form-control">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <label>Historial</label><span style="color: red;"> *</span>
                            <?= QuiiEditorConf::init($id='historial')?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer" id="footerPD">
                <button class="btn btn-success" id="guardar-historial" style="display:none;">Guardar</button>
                <button class="btn btn-success" id="editar-historial" style="display:none;">Guardar</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->


<div id="view-receta" class="modal fade">
    <div class="modal-dialog modal-md">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="recetaTitle"></h4>
                <button data-dismiss="modal" class="close"></button>
            </div>
            <div class="modal-body" id="recetaBody">
                <div id="bnt-print" class="text-right"></div>
                <div id="receta"></div>
            </div>
            <div class="modal-footer" id="recetaFooter">
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->


<div id="receta-modal" class="modal fade">
    <div class="modal-dialog modal-dialog-top modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Nueva Receta</h4>
                <button class="close" data-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" >
                <div class="container">
                    <div class="row" >
                        <div class="col-md-6">
                            <label>Fecha Cita</label><span style="color: red;"> *</span>
                            <input id="fechaCita" name="fechaCita" class="form-control">
                            <input type="hidden" id="id_receta" value="">
                        </div>
                        <div class="col-md-6">
                            <label>Próxima Cita</label>
                            <input id="proximaCita" name="proximaCita" class="form-control">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <label>Receta</label><span style="color: red;"> *</span>
                            <textarea id="receta" rows="12" class="form-control"></textarea>
                            <input value="<?=$model->id?>" id="id_paciente" type="hidden" name="id_paciente" >

                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer" id="receta-footer">
                <button id="crear-receta" class="btn btn-success">Guardar</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->


<div id="documento-paciente-modal" class="modal fade">
    <div class="modal-dialog modal-dialog-top modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Nuevo Documento</h4>
                <button class="close" data-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="container">
                    <div class="row" >
                        <div class="col-lg-12">
                            <div class="form-group" >
                                <label for="fecha-doc">Fecha del Documento</label>   
                                <input id="fecha_doc" name="fecha-doc" class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="form-group" >
                                <label for="documentos-paciente">Adjuntar Archivos</label>   
                                <input id="documentos-paciente" name="documentos-paciente[]" type="file" accept="image/* aplication/*" multiple>
                            </div>
                        </div> 
                     </div>
                </div>
            </div>
            <div class="modal-footer" >
                <button type="button" class="btn btn-success" id="enviar-docs">Guardar Documento</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->


<?php if($tipo_usuario == \app\models\Usuario::DOCTOR):?>
<div id="clinicas-modal" class="modal fade">
    <div class="modal-dialog modal-md">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="clinicasTitle"></h4>
                <button data-dismiss="modal" class="close"></button>
            </div>
            <div class="modal-body" id="clinicasBody">
                <div class="row">
                    <div class="col-md-12">
                        <label>Seleccione una clinica</label><span style="color: red;"> *</span>
                        <select name="id_clinica" id="id_clinica" class="form-control">
                            <?php foreach ($clinicas as $clinica):?>
                                <option value="<?=$clinica->id?>"><?=$clinica->nombre?></option>
                            <?php endforeach;?>
                        </select>    
                    </div>
                </div>
            </div>
            <div class="modal-footer" id="clinicasFooter">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button id="verReceta" class="btn btn-success">Continuar</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<?php endif;?>

<!-- /.modal -->
<div id="seguimientosModal" class="modal-seg">
    <div class="modal-contenido">
        <div class="modal-head">
          <h4 class="title-mod" id="segTitulo"></h4> 
          <span id="closeModalSeg" class="close">&times;</span>
        </div>
      <div id="segCuerpo"></div>
    </div>
</div>  