<?php

use yii\helpers\Html;
use app\models\Cita;

/* @var $this yii\web\View */
/* @var $model app\models\Cita[] */

$historySide = "right";
$imgs= $this->theme->baseUrl;
?>

<div class="kt-widget__top" style="text-shadow: none;">
    <div class="kt-widget__content">
        <div class="kt-widget__head">
            <a href="#" class="kt-portlet__head-title" style="margin-left: -20px;font-size: 1.2rem; 
                font-weight:500; color: #646c9a;;">
                <h2>Historial</h2>
            </a>
        </div>
    </div>
</div>
<hr>
<div class="kt-portlet__body">
    <div class="row">
        <div class="col-xl-1">
        </div>
        <div class="col-xl-10">
            <div class="kt-timeline-v1">
                <div class="kt-timeline-v1__items">
                    <div class="kt-timeline-v1__marker"></div>
                    <?php 
                        foreach ($model as $cita)
                        {  
                            $historySide = ($historySide == "left") ? "right" : "left";
                    ?>
                            <div class="kt-timeline-v1__item kt-timeline-v1__item--<?=$historySide?>">
                                <div class="kt-timeline-v1__item-circle">
                                    <div class="kt-bg-danger"></div>
                                </div>
                                <span class="kt-timeline-v1__item-time kt-font-brand">
                                    <?= \date('d/m/Y', strtotime($cita->fechaDB))?>
                                </span>
                                <div class="kt-timeline-v1__item-content">
                                    <div class="kt-timeline-v1__item-title">
                                        <img  src="<?= $imgs ?>/assets/media/icons/Clipboard-check.svg">
                                        <?php if(strtotime($cita->fechaDB)> time() && $cita->estado < Cita::CANCELADA  ){ ?>
                                        Cita pendiente
                                        <?php }else{ ?>
                                        <?= $cita->estado == Cita::CANCELADA ? 'Cita cancelada' 
                                                : ($cita->estado == Cita::COMPLETADA ? 'Asistió' 
                                                    :($cita->estado == Cita::INASISTENCIA ? 'No Asistió' 
                                                        :((strtotime($cita->fechaDB) < time() && $cita->estado < Cita::CANCELADA ) ? 'Por confirmar asistencia' : 'Cita pendiente' ))) ?> 
                                        <?php } ?>
                                    </div>
                                    <div class="kt-timeline-v1__item-title" style="margin-top:15px;">
                                        <img  src="<?= $imgs ?>/assets/media/icons/Clip.svg">
                                        Asunto:
                                    </div>
                                    <div class="kt-timeline-v1__item-body" style="margin-top:0px;" >
                                        <p style="margin-left:30px;">
                                              <?= ($cita->asunto==NULL) ? "(No definido)" : $cita->asunto ?>
                                        </p>
                                    </div>
                                    <div class="kt-timeline-v1__item-title">
                                        <img  src="<?= $imgs ?>/assets/media/icons/Edit.svg">
                                        Procedimientos:
                                    </div>
                                    <div class="kt-timeline-v1__item-body" style="margin-top: 0px; ">
                                        <ul>
                                    <?php foreach ($cita->procedimientoCitas as $model_cli_pro){ ?>
                                            <li class="kt-widget1__desc"><?= $model_cli_pro->procedimiento->nombre ?></li>
                                    <?php   } ?>
                                        </ul>
                                    </div>
                                    <div class="kt-timeline-v1__item-title" style="margin-top:15px;">
                                        <img  src="<?= $imgs ?>/assets/media/icons/Diagnostics.svg">
                                        Diagnostico:
                                    </div>
                                    <div class="kt-timeline-v1__item-body" style="margin-top:0px;" >
                                        <p style="margin-left:30px;">
                                              <?= ($cita->diagnostico==NULL) ? "(No definido)" : $cita->asunto ?>
                                        </p>
                                    </div>
                                    <div class="kt-timeline-v1__item-actions">
                                        <?= Html::a("Ir a Cita",["cita/view","id" => $cita->id],["class" => "btn btn-label btn-bold btn-sm"])?>
                                    </div>
                                </div>
                            </div>
                    <?php 

                        }
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>