<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use app\assets\PacienteAsset;
use yii\widgets\MaskedInput;
use app\themes\metronic\assets\Select2Assets;
use borales\extensions\phoneInput\PhoneInput;


/* @var $this yii\web\View */
/* @var $model app\models\Paciente */
/* @var $form yii\widgets\ActiveForm */
$sexo = ['h' => 'Hombre', 'm' => 'Mujer'];

Select2Assets::register($this);
PacienteAsset::register($this);

$clasePais = ($model->isNewRecord ? "" : (is_null($model->id_pais) ? "" : " cuadro-lleno"));
$nombrePais = ($model->isNewRecord ? "" : (is_null($model->id_pais) ? "" : $model->pais->nombre . " (" . $model->pais->iso . ")"));
?>
<style>
    .campo-activo{
        border-color: green;
    }
</style>
<input type="hidden" id="valores-comunicacion" value="<?=$valores?>">
<?php $form = ActiveForm::begin([ 'options'=>[
        'class' => 'kt-form',
        'id' => 'pacienteModal',
        'autocomplete' => 'off'
        ]
    ]); ?>
<div class="paciente-form kt-portlet__body">
    <div class="row">
        <div class="col-lg-12">
            <?= $form->field($model, 'nombre')->textInput(['maxlength' => true, 'required' => 'true']) ?>            
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <?= $form->field($model, 'apellido')->textInput(['maxlength' => true, 'required' => 'true']) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-6">
            <?= $form->field($model, 'sexo')->radioList($sexo, ['required' => 'true', ]) ?>
        </div>
        <div class="col-lg-6">
                <?= $form->field($model, 'celular')->widget(PhoneInput::className(), [
                        'jsOptions' => [
                            'preferredCountries' => ['sv', 'gt', 'hn', 'ni', 'cr','pa', 'mx', 'us'],
                        ]
                    ]); 
                ?>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <?= $form->field($model, 'email')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="form-group kt-form__actions">
        <?= Html::submitButton('Guardar',['id'=>'save-paciente', 'class' => 'btn btn-success btn-block', 'name'=>'guardar']) ?>
    </div>
</div>
<?php ActiveForm::end(); ?>