<?php

use yii\helpers\Html;

?>
<div class="kt-widget kt-widget--user-profile-3" style="text-shadow: none;">
    <div class="kt-widget__top" style="text-shadow: none;">
        <div class="kt-widget__content">
            <div class="kt-widget__head">
                <a href="#" class="kt-portlet__head-title" style="margin-left: -20px;font-size: 1.2rem; 
                        font-weight:500; color: #646c9a;;">
                    <h2>Datos principales</h2>
                </a>
                <div class="kt-widget__action " style="margin-left:-55px;">
                    <p class="d-none d-md-block">
                        <?= Html::a('Actualizar', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
                        <?= Html::a('Eliminar', ['delete', 'id' => $model->id], [
                            'class' => 'btn btn-danger',
                            'data' => [
                                'confirm' => '¿Está seguro de eliminar este elemento?',
                                'method' => 'post',
                            ],
                        ]) ?>
                    </p>
                </div>
                <div class="d-md-none">
                    <div class="btn-group">
                        <button type="button" class="btn btn-secondary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="margin-left: 0 !important;">
                            Opciones
                        </button>
                        <div class="dropdown-menu">
                            <?= Html::a('<i class="la la-edit kt-font-primary mt-2"></i>Actualizar', ['update', 'id' => $model->id], ['class' => 'dropdown-item']) ?>
                            <div class="dropdown-divider"></div>
                            <?= Html::a('<i class="la la-trash kt-font-danger mt-2"></i>Eliminar', ['delete', 'id' => $model->id], [
                            'class' => 'dropdown-item',
                            'data' => [
                                'confirm' => '¿Está seguro de eliminar este elemento?',
                                'method' => 'post',
                            ],
                        ]) ?>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <hr>
    <div class="row" style="margin-top: -30px;">
        <div class="col-lg-6" >
            <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>
            <div class="kt-widget1 kt-widget1--fit">
                <div class="kt-widget1__item">
                    <div class="kt-widget1__info">
                        <h3 class="kt-widget1__title">Nombre Completo</h3>
                        <span class="kt-widget1__desc" ><?=$model->nombre.' '.$model->apellido?></span>
                        <br>
                    </div>
                </div>
                <div class="kt-widget1__item">
                    <div class="kt-widget1__info">
                        <h3 class="kt-widget1__title">Edad</h3>
                        <span class="kt-widget1__desc"><?=$model->edad?></span>
                        <br>
                    </div>
                </div>
                <div class="kt-widget1__item">
                    <div class="kt-widget1__info">
                        <h3 class="kt-widget1__title">Teléfono fijo</h3>
                        <span class="kt-widget1__desc" >
                            <?= ($model->telefono_fijo == NULL) ? "(no definido)" : $model->telefono_fijo ?>
                        </span>
                        <br>
                    </div>
                </div>
                <div class="kt-widget1__item">
                    <div class="kt-widget1__info">
                        <h3 class="kt-widget1__title">Celular</h3>
                        <span class="kt-widget1__desc" >
                            <?= ($model->celular == NULL) ? "(no definido)" : $model->celular ?>
                        </span>
                        <br>
                    </div>
                </div>
              </div>
        </div>
        <div class="col-lg-6" >
            <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>
            <div class="kt-widget1 kt-widget1--fit">
                <div class="kt-widget1__item">
                    <div class="kt-widget1__info">
                        <h3 class="kt-widget1__title">Email</h3>
                        <span class="kt-widget1__desc"><?=$model->email?></span>
                    </div>
                </div>
                <div class="kt-widget1__item">
                    <div class="kt-widget1__info">
                        <h3 class="kt-widget1__title">Aseguradora</h3>
                        <span class="kt-widget1__desc">
                            <?= ($model->aseguradora == NULL) ? "(No definido)" : $model->aseguradora ?>
                        </span>
                    </div>
                </div>
                <div class="kt-widget1__item">
                    <div class="kt-widget1__info">
                        <h3 class="kt-widget1__title">Número tarjeta aseguradora</h3>
                        <span class="kt-widget1__desc">
                            <?= ($model->no_aseguradora == NULL) ? "(No definido)": $model->no_aseguradora ?>
                        </span>
                    </div>
                </div>
                <div class="kt-widget1__item">
                    <div class="kt-widget1__info">
                        <h3 class="kt-widget1__title">Observaciones</h3>
                        <span class="kt-widget1__desc" >
                            <?= ($model->notas == NULL) ? "(No definido)": $model->notas ?>
                        </span>
                        <br>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <hr>
    <div class="row">
        <div class="col-md-3">
            <button class="btn btn-primary btn-sm btn-block mt-1" type="button" data-toggle="collapse" data-target="#datos-encargado-secundario" aria-expanded="false" aria-controls="collapseExample">
                Datos de Encargado
            </button>
        </div>
        <div class="col-md-3">
            <button class="btn btn-success btn-sm btn-block mt-1" type="button" data-toggle="collapse" data-target="#datos-medicos" aria-expanded="false" aria-controls="collapseExample">
                Datos Médicos
            </button>
        </div>
        <div class="col-md-3">
            <button class="btn btn-primary btn-sm btn-block mt-1" type="button" data-toggle="collapse" data-target="#datos-secundarios" aria-expanded="false" aria-controls="collapseExample">
                Datos Secundarios
            </button>
        </div>
    </div>
    <div class="collapse" id="datos-encargado-secundario">
        <div class="well">
            <hr>
            <div class="row">
                <div class="col">
                    <h4 class="kt-widget1__desc" >Datos de Encargado</h4>
                </div>
            </div>
            <hr>
            <div class="row" style="margin-top: -15px;">
                <div class="col-lg-6">
                    <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>
                    <div class="kt-widget1 kt-widget1--fit">
                        <div class="kt-widget1__item">
                            <div class="kt-widget1__info">
                                <h3 class="kt-widget1__title">Nombre</h3>
                                <span class="kt-widget1__desc" >
                                    <?= ($model->nombre_encargado_sec == NULL)? "(No definido)" : $model->nombre_encargado_sec?>
                                </span>
                                <br>
                            </div>
                        </div>
                        <div class="kt-widget1__item">
                            <div class="kt-widget1__info">
                                <h3 class="kt-widget1__title">Enfermedades Actuales</h3>
                                <span class="kt-widget1__desc">
                                    <?= ($model->apellido_encargado_sec == NULL)? "(No definido)" : $model->apellido_encargado_sec ?>
                                </span>
                                <br>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>
                    <div class="kt-widget1 kt-widget1--fit">
                        <div class="kt-widget1__item">
                            <div class="kt-widget1__info">
                                <h3 class="kt-widget1__title">Celular</h3>
                                <span class="kt-widget1__desc" >
                                    <?= ($model->celular_encargado_sec == NULL)? "(No definido)" : $model->celular_encargado_sec?>
                                </span>
                                <br>
                            </div>
                        </div>
                        <div class="kt-widget1__item">
                            <div class="kt-widget1__info">
                                <h3 class="kt-widget1__title">Email</h3>
                                <span class="kt-widget1__desc">
                                    <?= ($model->email_encargado_sec == NULL)? "(No definido)" : $model->email_encargado_sec ?>
                                </span>
                                <br>
                            </div>
                        </div>
                    </div>
                </div>
            </div>            
        </div>
    </div>
    <div class="collapse" id="datos-medicos">
        <div class="well">
            <hr>
            <div class="row">
                <div class="col">
                    <h4 class="kt-widget1__desc" >Datos Médicos</h4>
                </div>
            </div>
            <hr>
            <div class="row" style="margin-top: -15px;">
                <div class="col-lg-6" >
                    <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>
                    <div class="kt-widget1 kt-widget1--fit">
                        <div class="kt-widget1__item">
                            <div class="kt-widget1__info">
                                <h3 class="kt-widget1__title">Referido por</h3>
                                <span class="kt-widget1__desc" >
                                    <?= ($model->referido_por == NULL)? "(No definido)" : $model->referido_por?>
                                </span>
                                <br>
                            </div>
                        </div>
                        <div class="kt-widget1__item">
                            <div class="kt-widget1__info">
                                <h3 class="kt-widget1__title">Enfermedades Actuales</h3>
                                <span class="kt-widget1__desc">
                                    <?= ($model->enfermedades_actuales == NULL)? "(No definido)" : $model->enfermedades_actuales ?>
                                </span>
                                <br>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6" >
                    <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>
                    <div class="kt-widget1 kt-widget1--fit">
                        <div class="kt-widget1__item">
                            <div class="kt-widget1__info">
                                <h3 class="kt-widget1__title">Alergias</h3>
                                <span class="kt-widget1__desc">
                                    <?= ($model->alergias == NULL)? "(No definido)" : $model->alergias ?>
                                </span>
                            </div>
                        </div>
                        <div class="kt-widget1__item">
                            <div class="kt-widget1__info">
                                <h3 class="kt-widget1__title">Medicamentos</h3>
                                <span class="kt-widget1__desc">
                                    <?= ($model->medicamentos == NULL)? "(No definido)" : $model->medicamentos ?>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>            
        </div>
    </div>
    <div class="collapse" id="datos-secundarios">
        <div class="well">
            <hr>
            <div class="row">
                <div class="col">
                    <h4 class="kt-widget1__desc" >Datos secundarios</h4>
                </div>
            </div>
            <hr>
            <div class="row" style="margin-top: -15px;">
                <div class="col-lg-6" >
                    <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>
                    <div class="kt-widget1 kt-widget1--fit">
                        <div class="kt-widget1__item">
                            <div class="kt-widget1__info">
                                <h3 class="kt-widget1__title">País</h3>
                                <span class="kt-widget1__desc" ><?=$model->pais == null ? 'No definido' : $model->pais->nombre ?></span>
                                <br>
                            </div>
                        </div>
                        <div class="kt-widget1__item">
                            <div class="kt-widget1__info">
                                <h3 class="kt-widget1__title">C&oacute;digo</h3>
                                <span class="kt-widget1__desc">
                                    <?= ($model->codigo == NULL)? "(No definido)" : $model->codigo ?>
                                </span>
                                <br>
                            </div>
                        </div>
                    </div>
               </div>
                <div class="col-lg-6" >
                    <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>
                    <div class="kt-widget1 kt-widget1--fit">
                        <div class="kt-widget1__item">
                            <div class="kt-widget1__info">
                                <h3 class="kt-widget1__title">Fecha de nacimiento</h3>
                                <span class="kt-widget1__desc"><?=$model->fecha_nacimiento?></span>
                            </div>
                        </div>
                        <div class="kt-widget1__item">
                            <div class="kt-widget1__info">
                                <h3 class="kt-widget1__title">Sexo</h3>
                                <span class="kt-widget1__desc">
                                    <?= $model->sexo == null ? 'No definido' : ($model->sexo == 'h' ? 'Masculino' : 'Femenino')?>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>                
            </div>
        </div>
    </div>
</div>