<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use borales\extensions\phoneInput\PhoneInput;

$camposRequeridos = explode('|', $valoresCamposRequeridos);

$sexo = ['h' => 'Hombre', 'm' => 'Mujer'];
$span = '<span style="color:red;">*</span>';
$labelNombre = 'Nombre '.$span;
$labelApellido = 'Apellido '.$span;
$labelCelular = in_array('celular', $camposRequeridos) ? 'Celular '.$span : 'Celular';
$labelCorreo = in_array('correo', $camposRequeridos) ? 'Correo '.$span : 'Correo';
?>

<?php if( $actionName == 'create' ) : ?>    
<div class="modal fade" role="dialog" aria-hidden="true" id="_formModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Crear Nuevo Paciente</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
            </div>
            <div class="modal-body">

            <?php $form = ActiveForm::begin([ 'options'=>[
                'class' => 'kt-form',
                'id' => 'pacienteModal',
                'autocomplete' => 'off'
                ]]); 
            ?>
                <div class="paciente-form kt-portlet__body">
                    <div class="row">
                        <div class="col-lg-12">
                            <?= $form->field($model, 'nombre')->textInput(['maxlength' => true, 'required' => true])->label($labelNombre) ?>            
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <?= $form->field($model, 'apellido')->textInput(['maxlength' => true, 'required' => true])->label($labelApellido) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-6">
                            <?= $form->field($model, 'sexo')->radioList($sexo) ?>
                        </div>
                        <div class="col-lg-6">
                                <?= $form->field($model, 'celular')->widget(PhoneInput::className(), [
                                        'options' =>[ 
                                            'required' => in_array('celular', $camposRequeridos)  
                                        ],
                                        'jsOptions' => [
                                            'preferredCountries' => ['sv', 'gt', 'hn', 'ni', 'cr','pa', 'mx', 'us'],
                                        ]
                                    ])->label($labelCelular); 
                                ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <?= $form->field($model, 'email')->textInput(['maxlength' => true, 'required' => in_array('correo', $camposRequeridos)])->label($labelCorreo) ?>
                        </div>
                    </div>
                    <div class="form-group kt-form__actions">
                        <!--button type="button" id="save-paciente" class="btn btn-success btn-block">Guardar</button-->
                        <?= Html::submitButton('Guardar', ['class' => 'btn btn-success btn-block', 'id'=>'save-paciente']) ?>
                    </div>
                </div>
            <?php ActiveForm::end(); ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<?php endif; ?>


<div id="solicitud-cita-web-info" class="modal fade modal-solicitud">
    <div class="modal-dialog modal-dialog-centered modal-md">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="titulo-solicitud"></h4>
                <button class="close" data-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <p>
                            <input type="hidden" id="id_solicitud" value="0">
                            <span id="paciente"></span><br>
                            <span id="fecha"></span><br>
                            <span id="tipo-cita"></span>
                        </p>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <ul>
                                <li id="tipo-cita-label"></li>
                                <li id="procedimiento"></li>
                                <li id="cometario"></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button data-modal="solicitud-cita-web-info" class="btn btn-danger btn-sm denegar" id="denegar-solicitud">Denegar</button>
                <button data-modal="solicitud-cita-web-info" class="btn btn-primary btn-sm aceptar" id="aceptar-solicitud">Aceptar</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<div id="confirmar-denegacion-modal" class="modal fade modal-solicitud">
    <div class="modal-dialog modal-dialog-centered modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Denegar solicitud de cita</h4>
                <button class="close" data-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <p>
                            ¿Enviar al paciente a la lista de espera?
                        </p>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <button id="enviar-ls-espera" class="btn btn-success btn-sm btn-block">Sí</button>
                    </div>
                    <div class="col-md-6">
                        <button id="no-enviar-ls-espera" class="btn btn-secondary btn-sm btn-block">No</button>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->